/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.bndtools.core.templates;

import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.clauses.ImportPattern;
import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.resource.CapReqBuilder;
import com.liferay.ide.bndtools.core.templates.AbstractProjectTemplate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bndtools.api.BndProjectResource;
import org.bndtools.api.IBndProject;
import org.bndtools.api.ProjectPaths;

public class PortletTemplate
extends AbstractProjectTemplate {
    public boolean enableTestSourceFolder() {
        return false;
    }

    @Override
    public void modifyInitialBndModel(BndEditModel model, String projectName, ProjectPaths projectPaths) {
        super.modifyInitialBndModel(model, projectName, projectPaths);
        String buildpath = "${buildpath-rule}";
        model.setBuildPath(Collections.singletonList(new VersionedClause("${buildpath-rule}", Attrs.EMPTY_ATTRS)));
        model.setIncludeResource(Collections.singletonList("${includeresource-rule}"));
        ImportPattern[] patterns = new ImportPattern[]{new ImportPattern("${imports-rule}", Attrs.EMPTY_ATTRS), new ImportPattern("*", new Attrs())};
        patterns[1].setOptional(true);
        model.setImportPatterns(Arrays.asList(patterns));
        model.setGenericString("Web-ContextPath", "/" + projectName);
        String safePackageName = this.safePackageName(projectName);
        CapReqBuilder cap = new CapReqBuilder("osgi.identity").addDirective("filter", "(osgi.identity=" + safePackageName + ")");
        model.setRunRequires(Collections.singletonList(cap.buildSyntheticRequirement()));
    }

    public void modifyInitialBndProject(IBndProject project, String projectName, ProjectPaths projectPaths) {
        String src = projectPaths.getSrc();
        String safePackageName = this.safePackageName(projectName);
        String pkgPath = safePackageName.toLowerCase().replaceAll("\\.", "/");
        String ruleJavaClassName = this.safeJavaClassName(projectName).replaceAll("^Rule", "").replaceAll("Test$", "");
        LinkedHashMap<String, String> exprs = new LinkedHashMap<String, String>();
        exprs.put("@rule.java.package.name@", safePackageName);
        exprs.put("@rule.java.class.name@", ruleJavaClassName);
        project.addResource(String.valueOf(src) + "/" + pkgPath + "/" + ruleJavaClassName + "Rule.java", this.newResource("ExampleRule.java.txt", exprs));
        project.addResource("/META-INF/liferay-hook.xml", this.newResource("liferay-hook.xml", exprs));
        project.addResource(String.valueOf(src) + "/content/Language.properties", this.newResource("Language.properties.txt", exprs));
        project.addResource(String.valueOf(src) + "/templates/ct_fields.ftl", this.newResource("ct_fields.ftl", exprs));
    }

    private BndProjectResource newResource(String resource, Map<String, String> exprs) {
        return new BndProjectResource(PortletTemplate.class.getResource(resource), exprs);
    }
}

