/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.notifications.feed;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.notifications.core.NotificationEnvironment;
import org.eclipse.mylyn.commons.notifications.feed.IServiceMessageListener;
import org.eclipse.mylyn.commons.notifications.feed.ServiceMessageEvent;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedReader;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;

public class ServiceMessageManager {
    private static final String ID_EVENT_SERVICE_MESSAGE = "org.eclipse.mylyn.notifications.feed.events.ServiceMessage";
    private static final long RECHECK_DELAY = 1209600000L;
    private static final long START_DELAY = 30000L;
    private final long checktime;
    private final NotificationEnvironment environment;
    private String eTag;
    private String eventId;
    private String lastModified;
    private final List<IServiceMessageListener> listeners = new CopyOnWriteArrayList<IServiceMessageListener>();
    private Job messageCheckJob;
    private volatile List<? extends ServiceMessage> messages = Collections.emptyList();
    private boolean statusLogged;
    private String url;

    public ServiceMessageManager(String serviceMessageUrl, String lastModified, String eTag, long checktime) {
        this(serviceMessageUrl, lastModified, eTag, checktime, new NotificationEnvironment());
    }

    public ServiceMessageManager(String serviceMessageUrl, String lastModified, String eTag, long checktime, NotificationEnvironment environment) {
        this.url = serviceMessageUrl;
        this.lastModified = lastModified;
        this.checktime = checktime;
        this.eTag = eTag;
        this.environment = environment;
        this.eventId = ID_EVENT_SERVICE_MESSAGE;
    }

    public void addServiceMessageListener(IServiceMessageListener listener) {
        this.listeners.add(listener);
    }

    public final String getEventId() {
        return this.eventId;
    }

    public List<ServiceMessage> getServiceMessages() {
        return new ArrayList<ServiceMessage>(this.messages);
    }

    public String getUrl() {
        return this.url;
    }

    public void removeServiceMessageListener(IServiceMessageListener listener) {
        this.listeners.remove(listener);
    }

    public final void setEventId(String eventId) {
        Assert.isNotNull((Object)eventId);
        this.eventId = eventId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void start() {
        if (this.messageCheckJob == null) {
            this.messageCheckJob = new Job("Checking for new service message"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ServiceMessageManager.this.refresh(monitor);
                        return Status.OK_STATUS;
                    }
                    catch (Throwable throwable) {
                        return Status.CANCEL_STATUS;
                    }
                }
            };
            this.messageCheckJob.setSystem(true);
            this.messageCheckJob.setPriority(50);
            this.messageCheckJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (ServiceMessageManager.this.messageCheckJob != null) {
                        ServiceMessageManager.this.messageCheckJob.schedule(1209600000L);
                    }
                }
            });
        }
        if (this.checktime == 0L) {
            this.messageCheckJob.schedule(30000L);
        } else {
            long nextCheckTime = this.checktime + 1209600000L;
            long now = System.currentTimeMillis();
            if (nextCheckTime < now) {
                this.messageCheckJob.schedule(30000L);
            } else if (nextCheckTime > now) {
                if (nextCheckTime - now < 30000L) {
                    this.messageCheckJob.schedule(30000L);
                } else {
                    this.messageCheckJob.schedule(nextCheckTime - now);
                }
            }
        }
    }

    public void stop() {
        if (this.messageCheckJob != null) {
            this.messageCheckJob.cancel();
            this.messageCheckJob = null;
        }
        final ServiceMessageEvent event = new ServiceMessageEvent(this, ServiceMessageEvent.Kind.STOP);
        for (final IServiceMessageListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.commons.notifications.feed", "Listener failed: " + listener.getClass(), e));
                }

                public void run() throws Exception {
                    listener.handleEvent(event);
                }
            });
        }
    }

    public int refresh(IProgressMonitor monitor) {
        List<? extends ServiceMessage> messages;
        int status;
        block15: {
            status = -1;
            messages = null;
            try {
                HttpURLConnection connection = this.openConnection(this.url);
                if (this.lastModified != null && this.lastModified.length() > 0) {
                    try {
                        connection.setIfModifiedSince(Long.parseLong(this.lastModified));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (this.eTag != null && this.eTag.length() > 0) {
                    connection.setRequestProperty("If-None-Match", this.eTag);
                }
                try {
                    connection.connect();
                    status = connection.getResponseCode();
                    if (status == 200 && !monitor.isCanceled()) {
                        this.lastModified = connection.getHeaderField("Last-Modified");
                        this.eTag = connection.getHeaderField("ETag");
                        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());){
                            messages = this.readMessages(in, monitor);
                            break block15;
                        }
                    }
                    if (status != 404 && status != 304) {
                        this.logStatus((IStatus)new Status(2, "org.eclipse.mylyn.commons.notifications.feed", "Http error retrieving service message: " + connection.getResponseMessage()));
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                this.logStatus((IStatus)new Status(2, "org.eclipse.mylyn.commons.notifications.feed", "Http error retrieving service message.", (Throwable)e));
            }
        }
        if (messages != null && messages.size() > 0) {
            this.notifyListeners(messages);
        }
        return status;
    }

    private HttpURLConnection openConnection(String url) throws IOException, MalformedURLException {
        Proxy proxy = NetUtil.getProxyForUrl((String)url);
        if (proxy != null) {
            return (HttpURLConnection)new URL(url).openConnection(proxy);
        }
        return (HttpURLConnection)new URL(url).openConnection();
    }

    private void logStatus(IStatus status) {
        if (!this.statusLogged) {
            this.statusLogged = true;
        }
    }

    private void notifyListeners(List<? extends ServiceMessage> messages) {
        this.messages = messages;
        for (ServiceMessage serviceMessage : messages) {
            serviceMessage.setETag(this.eTag);
            serviceMessage.setLastModified(this.lastModified);
        }
        ArrayList<ServiceMessage> arrayList = new ArrayList<ServiceMessage>(messages);
        Collections.sort(messages);
        final ServiceMessageEvent event = new ServiceMessageEvent(this, ServiceMessageEvent.Kind.MESSAGE_UPDATE, arrayList);
        for (final IServiceMessageListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.commons.notifications.feed", "Listener failed: " + listener.getClass(), e));
                }

                public void run() throws Exception {
                    listener.handleEvent(event);
                }
            });
        }
    }

    private List<? extends ServiceMessage> readMessages(InputStream in, IProgressMonitor monitor) throws IOException {
        FeedReader reader = new FeedReader(this.eventId, this.environment);
        reader.parse(in, monitor);
        return reader.getEntries();
    }
}

