/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import java.io.IOException;
import java.util.ResourceBundle;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.services.SQLUIService;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.sqleditor.IPageUpdate;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.dialog.EditTemplateDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AddTemplateAction
extends TextEditorAction
implements IPageUpdate {
    private SQLEditor _sqlEditor;
    private boolean _isSourcePage = true;

    public AddTemplateAction(ResourceBundle bundle, String prefix, SQLEditor targetEditor) {
        super(bundle, prefix, (ITextEditor)targetEditor);
        this.setImageDescriptor(SQLEditorResources.getImageDescriptor("template_obj"));
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.saveAsTemplateAction");
        this.setId("org.eclipse.datatools.sqltools.sqleditor.saveAsTemplateAction");
        this._sqlEditor = targetEditor;
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"save_as_template_action", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void update() {
        this.setEnabled(this._isSourcePage && this._sqlEditor != null && this._sqlEditor.getSelectedText() != null);
    }

    public void run() {
        Template template = new Template();
        template.setPattern(this._sqlEditor.getSelectedText());
        SQLDevToolsUIConfiguration config = SQLToolsUIFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this._sqlEditor.getConnectionInfo().getDatabaseVendorDefinitionId());
        SQLUIService sqlService = config.getSQLUIService();
        template.setContextTypeId(sqlService.getSQLContextType().getSQLContextId());
        EditTemplateDialog dialog = new EditTemplateDialog(null, template, false, true, SQLEditorPlugin.getDefault().getTemplateContextTypeRegistry());
        if (dialog.open() == 0) {
            TemplatePersistenceData data = new TemplatePersistenceData(template, true);
            SQLEditorPlugin.getDefault().getTemplateStore().add(data);
            try {
                SQLEditorPlugin.getDefault().getTemplateStore().save();
            }
            catch (IOException e) {
                this.openWriteErrorDialog(e);
            }
        }
    }

    private void openWriteErrorDialog(Exception e) {
        String title = Messages.AddTemplateAction_error_write_title;
        String message = Messages.AddTemplateAction_error_write_message;
        MessageDialog.openError(null, (String)title, (String)message);
    }

    @Override
    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }
}

