/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.notifications;

import java.util.Collections;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mylyn.commons.notifications.core.AbstractNotification;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class NotificationsCore
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "com.liferay.ide.ui.notifications";
    public static final String SHOULD_SHOW_NOTIFICATIONS = "SHOULD_SHOW_NOTIFICATIONS";
    private static NotificationsCore plugin;

    private AbstractNotification createJava8RequiredNotification() {
        final Date date = new Date();
        return new AbstractUiNotification("com.liferay.ide.ui.notifications.java8required"){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public Date getDate() {
                return date;
            }

            public String getDescription() {
                return "This Eclipse instance is running on java " + NotificationsCore.this.getCurrentJavaVersion() + "\n" + "Liferay IDE needs at least Java 1.8 to run, please launch Eclipse with 1.8 and try again.";
            }

            public String getLabel() {
                return "Java 8 Required";
            }

            public Image getNotificationImage() {
                return null;
            }

            public Image getNotificationKindImage() {
                return null;
            }

            public void open() {
            }
        };
    }

    public void earlyStartup() {
        if (this.shouldShowNotifications() && !this.matchRequiredJavaVersion()) {
            NotificationsUi.getService().notify(Collections.singletonList(this.createJava8RequiredNotification()));
        }
    }

    private String getCurrentJavaVersion() {
        return System.getProperty("java.specification.version");
    }

    public static NotificationsCore getDefault() {
        return plugin;
    }

    public static void logError(Exception e) {
        NotificationsCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    private boolean matchRequiredJavaVersion() {
        Version requiredVersion;
        String javaVersion = this.getCurrentJavaVersion();
        Version currentVersion = new Version(javaVersion);
        return currentVersion.compareTo(requiredVersion = new Version("1.8")) >= 0;
    }

    private boolean shouldShowNotifications() {
        IScopeContext[] scopes = new IScopeContext[]{ConfigurationScope.INSTANCE, InstanceScope.INSTANCE};
        return Platform.getPreferencesService().getBoolean(PLUGIN_ID, SHOULD_SHOW_NOTIFICATIONS, true, scopes);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

