/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.BundleDTOWithStatus;
import com.liferay.ide.server.core.portal.BundlePublishOperation;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.osgi.framework.dto.BundleDTO;

public class BundlePublishFullAdd
extends BundlePublishOperation {
    public BundlePublishFullAdd(IServer s, IModule[] modules) {
        super(s, modules);
    }

    private IStatus autoDeploy(IPath output) throws CoreException {
        IStatus retval = null;
        IPath autoDeployPath = this.portalRuntime.getPortalBundle().getAutoDeployPath();
        IPath statePath = this.portalRuntime.getPortalBundle().getModulesPath().append("state");
        if (autoDeployPath.toFile().exists()) {
            try {
                FileUtil.writeFileFromStream((File)autoDeployPath.append(output.lastSegment()).toFile(), (InputStream)new FileInputStream(output.toFile()));
                retval = Status.OK_STATUS;
            }
            catch (IOException e) {
                retval = LiferayServerCore.error("Unable to copy file to auto deploy folder", e);
            }
        }
        if (statePath.toFile().exists()) {
            FileUtil.deleteDir((File)statePath.toFile(), (boolean)true);
        }
        return retval;
    }

    protected boolean cleanBuildNeeded() {
        return false;
    }

    @Override
    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        for (IModule module : this.modules) {
            IProject project;
            IStatus retval;
            block9: {
                retval = Status.OK_STATUS;
                project = module.getProject();
                if (project == null) continue;
                IBundleProject bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)project);
                if (bundleProject != null) {
                    monitor.subTask("Building " + module.getName() + " output bundle...");
                    IPath outputJar = null;
                    try {
                        outputJar = bundleProject.getOutputBundle(this.cleanBuildNeeded(), monitor);
                        if (outputJar != null && outputJar.toFile().exists()) {
                            if (this.server.getServerState() == 2) {
                                monitor.subTask("Remotely deploying " + module.getName() + " to Liferay module framework...");
                                retval = this.remoteDeploy(bundleProject.getSymbolicName(), outputJar);
                            } else {
                                retval = this.autoDeploy(outputJar);
                            }
                            this.portalServerBehavior.setModuleState2(new IModule[]{module}, 2);
                            break block9;
                        }
                        retval = LiferayServerCore.error("Could not create output jar");
                    }
                    catch (Exception e) {
                        retval = LiferayServerCore.error("Deploy module project error", e);
                    }
                } else {
                    retval = LiferayServerCore.error("Unable to get bundle project for " + module.getProject().getName());
                }
            }
            if (retval.isOK()) {
                this.portalServerBehavior.setModulePublishState2(new IModule[]{module}, 1);
                project.deleteMarkers("com.liferay.ide.server.core.BundleOutputErrorMarker", false, 0);
                continue;
            }
            this.portalServerBehavior.setModulePublishState2(new IModule[]{module}, 3);
            project.createMarker("com.liferay.ide.server.core.BundleOutputErrorMarker");
            LiferayServerCore.logError(retval);
        }
    }

    private String getBundleUrl(File bundleFile, String bsn) throws MalformedURLException {
        String bundleUrl = null;
        bundleUrl = bundleFile.toPath().toString().toLowerCase().endsWith(".war") ? "webbundle:" + bundleFile.toURI().toURL().toExternalForm() + "?Web-ContextPath=/" + bsn : bundleFile.toURI().toURL().toExternalForm();
        return bundleUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus remoteDeploy(String bsn, IPath output) {
        IStatus retval = null;
        if (output == null) return LiferayServerCore.error("Unable to deploy bundle remotely " + output.toPortableString());
        if (!output.toFile().exists()) return LiferayServerCore.error("Unable to deploy bundle remotely " + output.toPortableString());
        BundleSupervisor bundleSupervisor = null;
        try {
            try {
                bundleSupervisor = this.createBundleSupervisor();
                BundleDTO deployed = bundleSupervisor.deploy(bsn, output.toFile(), this.getBundleUrl(output.toFile(), bsn));
                if (deployed instanceof BundleDTOWithStatus) {
                    BundleDTOWithStatus withStatus = (BundleDTOWithStatus)deployed;
                    retval = LiferayServerCore.error("Problem with deploying bundle: " + withStatus._status);
                    return retval;
                }
                retval = new Status(0, "com.liferay.ide.server.core", (int)deployed.id, null, null);
                return retval;
            }
            catch (Exception e) {
                retval = LiferayServerCore.error("Unable to deploy bundle remotely " + output.toPortableString(), e);
                if (bundleSupervisor == null) return retval;
                try {
                    bundleSupervisor.close();
                    return retval;
                }
                catch (IOException iOException) {}
            }
            return retval;
        }
        finally {
            if (bundleSupervisor != null) {
                try {
                    bundleSupervisor.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

