/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.AbstractPortalBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortalJBossBundle
extends AbstractPortalBundle {
    public static final int DEFAULT_JMX_PORT = 2099;

    public PortalJBossBundle(IPath path) {
        super(path);
    }

    public PortalJBossBundle(Map<String, String> appServerProperties) {
        super(appServerProperties);
    }

    @Override
    public IPath getAppServerDeployDir() {
        return this.bundlePath.append("/standalone/deployments/");
    }

    @Override
    public IPath getAppServerLibGlobalDir() {
        return this.getAppServerDir().append("/modules/com/liferay/portal/main");
    }

    @Override
    protected IPath getAppServerLibDir() {
        return this.getAppServerDir().append("modules");
    }

    @Override
    protected int getDefaultJMXRemotePort() {
        return 2099;
    }

    @Override
    public String getHttpPort() {
        String retVal = "8080";
        File standaloneXmlFile = new File(this.getAppServerDir().toPortableString(), "standalone/configuration/standalone.xml");
        String portValue = this.getHttpPortValue(standaloneXmlFile, "socket-binding", "name", "http", "port");
        if (!CoreUtil.empty((String)portValue)) {
            retVal = portValue.lastIndexOf(":") == -1 ? portValue : portValue.substring(portValue.lastIndexOf(":") + 1, portValue.length() - 1);
        }
        return retVal;
    }

    @Override
    public void setHttpPort(String port) {
        File standaloneXmlFile = new File(this.getAppServerDir().toPortableString(), "standalone/configuration/standalone.xml");
        this.setHttpPortValue(standaloneXmlFile, "socket-binding", "name", "http", "port", port);
    }

    @Override
    public String getMainClass() {
        return "org.jboss.modules.Main";
    }

    public IPath getAppServerPortalDir() {
        IPath retval = null;
        if (this.bundlePath != null) {
            retval = this.bundlePath.append("/standalone/deployments/ROOT.war");
        }
        return retval;
    }

    @Override
    public IPath[] getRuntimeClasspath() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        if (this.bundlePath.toFile().exists()) {
            paths.add(this.bundlePath.append("jboss-modules.jar"));
        }
        return paths.toArray(new IPath[0]);
    }

    @Override
    public String[] getRuntimeStartProgArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-mp \"" + this.bundlePath.toPortableString() + "/modules" + "\"");
        args.add("-jaxpmodule");
        args.add("javax.xml.jaxp-provider");
        args.add("org.jboss.as.standalone");
        args.add("-b");
        args.add("localhost");
        args.add("--server-config=standalone.xml");
        args.add("-Djboss.server.base.dir=\"" + this.bundlePath.toPortableString() + "/standalone/" + "\"");
        return args.toArray(new String[0]);
    }

    @Override
    public String[] getRuntimeStopProgArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-mp \"" + this.bundlePath.toPortableString() + "/modules" + "\"");
        args.add("org.jboss.as.cli");
        args.add("--controller=localhost");
        args.add("--connect");
        args.add("--command=:shutdown");
        return args.toArray(new String[0]);
    }

    @Override
    public String[] getRuntimeStartVMArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-Dcom.sun.management.jmxremote");
        args.add("-Dcom.sun.management.jmxremote.authenticate=false");
        args.add("-Dcom.sun.management.jmxremote.port=" + this.getJmxRemotePort());
        args.add("-Dcom.sun.management.jmxremote.ssl=false");
        args.add("-Dorg.jboss.resolver.warning=true");
        args.add("-Djava.net.preferIPv4Stack=true");
        args.add("-Dsun.rmi.dgc.client.gcInterval=3600000");
        args.add("-Dsun.rmi.dgc.server.gcInterval=3600000");
        args.add("-Djboss.modules.system.pkgs=org.jboss.byteman");
        args.add("-Djava.awt.headless=true");
        args.add("-Dfile.encoding=UTF8");
        args.add("-server");
        args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
        args.add("-Xbootclasspath/p:\"" + this.bundlePath + "/modules/org/jboss/logmanager/main/jboss-logmanager-1.2.2.GA.jar" + "\"");
        args.add("-Xbootclasspath/p:\"" + this.bundlePath + "/modules/org/jboss/logmanager/log4j/main/jboss-logmanager-log4j-1.0.0.GA.jar" + "\"");
        args.add("-Xbootclasspath/p:\"" + this.bundlePath + "/modules/org/apache/log4j/main/log4j-1.2.16.jar" + "\"");
        args.add("-Djboss.modules.system.pkgs=org.jboss.logmanager");
        args.add("-Dorg.jboss.boot.log.file=\"" + this.bundlePath.append("/standalone/log/boot.log") + "\"");
        args.add("-Dlogging.configuration=file:\"" + this.bundlePath + "/standalone/configuration/logging.properties" + "\"");
        args.add("-Djboss.home.dir=\"" + this.bundlePath + "\"");
        args.add("-Djboss.bind.address.management=localhost");
        args.add("-Duser.timezone=GMT");
        return args.toArray(new String[0]);
    }

    @Override
    public String[] getRuntimeStopVMArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-Djboss.home.dir=\"" + this.bundlePath + "\"");
        return args.toArray(new String[0]);
    }

    @Override
    public String getType() {
        return "jboss";
    }

    @Override
    public String getDisplayName() {
        return "JBoss AS";
    }

    @Override
    public IPath[] getUserLibs() {
        ArrayList<Path> libs = new ArrayList<Path>();
        try {
            List portallibFiles = FileListing.getFileListing((File)new File(this.getAppServerPortalDir().append("WEB-INF/lib").toPortableString()));
            for (File lib : portallibFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
            List libFiles = FileListing.getFileListing((File)new File(this.getAppServerLibDir().toPortableString()));
            for (File lib : libFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return libs.toArray(new IPath[libs.size()]);
    }

    private void setHttpPortValue(File xmlFile, String tagName, String attriName, String attriValue, String targetName, String value) {
        DocumentBuilder db = null;
        DocumentBuilderFactory dbf = null;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
            Document document = db.parse(xmlFile);
            NodeList connectorNodes = document.getElementsByTagName(tagName);
            int i = 0;
            while (i < connectorNodes.getLength()) {
                Node node = connectorNodes.item(i);
                NamedNodeMap attributes = node.getAttributes();
                Node protocolNode = attributes.getNamedItem(attriName);
                if (protocolNode != null && protocolNode.getNodeValue().equals(attriValue)) {
                    Node portNode = attributes.getNamedItem(targetName);
                    portNode.setNodeValue(value);
                    break;
                }
                ++i;
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            DOMSource domSource = new DOMSource(document);
            StreamResult result = new StreamResult(xmlFile);
            transformer.transform(domSource, result);
        }
        catch (Exception e) {
            LiferayServerCore.logError(e);
        }
    }
}

