/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.core.portal.PortalJBossBundleFactory;
import com.liferay.ide.server.core.portal.PortalJBossEapBundle;
import com.liferay.ide.server.util.JavaUtil;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PortalJBossEapBundleFactory
extends PortalJBossBundleFactory {
    private static final String EAP_DIR_META_INF = "modules/system/layers/base/org/jboss/as/product/eap/dir/META-INF";

    @Override
    public PortalBundle create(Map<String, String> appServerProperties) {
        return new PortalJBossEapBundle(appServerProperties);
    }

    @Override
    public PortalBundle create(IPath location) {
        return new PortalJBossEapBundle(location);
    }

    @Override
    protected boolean detectBundleDir(IPath path) {
        if (!path.toFile().exists()) {
            return false;
        }
        if (path.append("modules").toFile().exists() && path.append("standalone").toFile().exists() && path.append("bin").toFile().exists()) {
            String eapVersion = this.getEAPVersion(path.toFile(), EAP_DIR_META_INF, new String[]{"6.", "7."}, "eap", "EAP");
            return eapVersion != null;
        }
        return false;
    }

    private String getEAPVersion(File location, String metaInfPath, String[] versionPrefix, String slot, String releaseName) {
        String product;
        Properties p;
        Path rootPath = new Path(location.getAbsolutePath());
        IPath productConf = rootPath.append("bin/product.conf");
        if (productConf.toFile().exists() && (p = PropertiesUtil.loadProperties((File)productConf.toFile())) != null && slot.equals(product = (String)p.get("slot"))) {
            return PortalJBossEapBundleFactory.getEAPVersionNoSlotCheck(location, metaInfPath, versionPrefix, releaseName);
        }
        return null;
    }

    public static String getEAPVersionNoSlotCheck(File location, String metaInfPath, String[] versionPrefixs, String releaseName) {
        Path rootPath = new Path(location.getAbsolutePath());
        IPath eapDir = rootPath.append(metaInfPath);
        if (eapDir.toFile().exists()) {
            IPath manifest = eapDir.append("MANIFEST.MF");
            String type = JavaUtil.getManifestProperty(manifest.toFile(), "JBoss-Product-Release-Name");
            String version = JavaUtil.getManifestProperty(manifest.toFile(), "JBoss-Product-Release-Version");
            boolean matchesName = type.contains(releaseName);
            String[] stringArray = versionPrefixs;
            int n = versionPrefixs.length;
            int n2 = 0;
            while (n2 < n) {
                String prefixVersion = stringArray[n2];
                boolean matchesVersion = version.startsWith(prefixVersion);
                if (matchesName && matchesVersion) {
                    return version;
                }
                ++n2;
            }
        }
        return null;
    }
}

