/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.proxy;

import com.liferay.ide.server.core.LiferayServerCore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public abstract class PortalSupportProxy
implements InvocationHandler {
    protected ClassLoader previousClassLoader;
    protected URLClassLoader proxyClassLoader;
    protected Object serviceObject;

    protected void configureClassloader() throws CoreException {
        ClassLoader currentClassLoader;
        if (this.proxyClassLoader == null) {
            this.proxyClassLoader = this.createClassLoader();
        }
        if ((currentClassLoader = Thread.currentThread().getContextClassLoader()).equals(this.proxyClassLoader)) {
            return;
        }
        this.previousClassLoader = currentClassLoader;
        Thread.currentThread().setContextClassLoader(this.proxyClassLoader);
    }

    protected URLClassLoader createClassLoader() throws CoreException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(LiferayServerCore.getPortalSupportLibURL());
        URL[] uRLArray = this.getProxyClasspath();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            urls.add(url);
            ++n2;
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Platform.class.getClassLoader());
    }

    protected abstract URL[] getProxyClasspath() throws CoreException;

    protected Object getServiceObject() throws Exception {
        return this.serviceObject;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Throwable error;
        Object retval;
        block6: {
            retval = null;
            error = null;
            this.configureClassloader();
            try {
                try {
                    Object serviceObject = this.getServiceObject();
                    Method serviceMethod = serviceObject.getClass().getMethod(method.getName(), method.getParameterTypes());
                    retval = serviceMethod.invoke(serviceObject, args);
                }
                catch (Throwable t) {
                    LiferayServerCore.logError("Error in proxy method " + method.getName(), t);
                    error = t;
                    this.unconfigureClassloader();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.unconfigureClassloader();
                throw throwable;
            }
            this.unconfigureClassloader();
        }
        if (error != null) {
            throw new RuntimeException("Error in workflow validation proxy.", error.getCause());
        }
        return retval;
    }

    protected void unconfigureClassloader() {
        if (this.previousClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.previousClassLoader);
        } else {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
    }
}

