/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.remote;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.remote.IRemoteServerPublisher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public abstract class AbstractRemoteServerPublisher
implements IRemoteServerPublisher {
    private IProject project;

    public AbstractRemoteServerPublisher(IProject project) {
        this.project = project;
    }

    protected void addRemoveProps(IPath deltaPath, IResource deltaResource, ZipOutputStream zip, Map<ZipEntry, String> deleteEntries, String deletePrefix) throws IOException {
        String archive = this.removeArchive(deltaPath.toPortableString());
        ZipEntry zipEntry = null;
        for (ZipEntry entry : deleteEntries.keySet()) {
            if (!entry.getName().startsWith(archive)) continue;
            zipEntry = entry;
        }
        if (zipEntry == null) {
            zipEntry = new ZipEntry(String.valueOf(archive) + "META-INF/" + deletePrefix + "-partialapp-delete.props");
        }
        String existingFiles = deleteEntries.get(zipEntry);
        String file = deltaPath.toPortableString().substring(archive.length());
        if (deltaResource.getType() == 2) {
            file = String.valueOf(file) + "/.*";
        }
        deleteEntries.put(zipEntry, String.valueOf(existingFiles != null ? existingFiles : "") + file + "\n");
    }

    protected void addToZip(IPath path, IResource resource, ZipOutputStream zip, boolean adjustGMTOffset) throws IOException, CoreException {
        switch (resource.getType()) {
            case 1: {
                ZipEntry zipEntry = new ZipEntry(path.toString());
                zip.putNextEntry(zipEntry);
                InputStream contents = ((IFile)resource).getContents();
                if (adjustGMTOffset) {
                    TimeZone currentTimeZone = TimeZone.getDefault();
                    GregorianCalendar currentDt = new GregorianCalendar(currentTimeZone, Locale.getDefault());
                    int gmtOffset = currentTimeZone.getOffset(currentDt.get(0), currentDt.get(1), currentDt.get(2), currentDt.get(5), currentDt.get(7), currentDt.get(14));
                    zipEntry.setTime(System.currentTimeMillis() + (long)(gmtOffset * -1));
                }
                try {
                    IOUtils.copy((InputStream)contents, (OutputStream)zip);
                    break;
                }
                finally {
                    contents.close();
                }
            }
            case 2: 
            case 4: {
                IResource[] members;
                IContainer container = (IContainer)resource;
                IResource[] iResourceArray = members = container.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    this.addToZip(path.append(res.getName()), res, zip, adjustGMTOffset);
                    ++n2;
                }
                break;
            }
        }
    }

    protected IProject getProject() {
        return this.project;
    }

    protected void processResourceDeltas(IModuleResourceDelta[] deltas, ZipOutputStream zip, Map<ZipEntry, String> deleteEntries, String deletePrefix, String deltaPrefix, boolean adjustGMTOffset) throws IOException, CoreException {
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            int deltaKind = delta.getKind();
            IResource deltaResource = (IResource)delta.getModuleResource().getAdapter(IResource.class);
            IProject deltaProject = deltaResource.getProject();
            IWebProject lrproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)deltaProject);
            if (lrproject != null) {
                IFolder webappRoot = lrproject.getDefaultDocrootFolder();
                Path deltaPath = null;
                if (webappRoot != null && webappRoot.exists()) {
                    IPath deltaFullPath = deltaResource.getFullPath();
                    IPath containerFullPath = webappRoot.getFullPath();
                    deltaPath = new Path(String.valueOf(deltaPrefix) + deltaFullPath.makeRelativeTo(containerFullPath));
                    if (deltaPath != null && deltaPath.segmentCount() > 0) break;
                }
                if (deltaKind == 1 || deltaKind == 2) {
                    this.addToZip((IPath)deltaPath, deltaResource, zip, adjustGMTOffset);
                } else if (deltaKind == 3) {
                    this.addRemoveProps((IPath)deltaPath, deltaResource, zip, deleteEntries, deletePrefix);
                } else if (deltaKind == 0) {
                    IModuleResourceDelta[] children = delta.getAffectedChildren();
                    this.processResourceDeltas(children, zip, deleteEntries, deletePrefix, deltaPrefix, adjustGMTOffset);
                }
            }
            ++n2;
        }
    }

    @Override
    public IPath publishModuleDelta(String archiveName, IModuleResourceDelta[] deltas, String deletePrefix, boolean adjustGMTOffset) throws CoreException {
        File warfile;
        block15: {
            IPath path = LiferayServerCore.getTempLocation("partial-war", archiveName);
            FileOutputStream outputStream = null;
            ZipOutputStream zip = null;
            warfile = path.toFile();
            warfile.getParentFile().mkdirs();
            try {
                try {
                    outputStream = new FileOutputStream(warfile);
                    zip = new ZipOutputStream(outputStream);
                    HashMap<ZipEntry, String> deleteEntries = new HashMap<ZipEntry, String>();
                    this.processResourceDeltas(deltas, zip, deleteEntries, deletePrefix, "", adjustGMTOffset);
                    for (ZipEntry entry : deleteEntries.keySet()) {
                        zip.putNextEntry(entry);
                        zip.write(((String)deleteEntries.get(entry)).getBytes());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return new Path(warfile.getAbsolutePath());
    }

    private String removeArchive(String archive) {
        int index = Math.max(archive.lastIndexOf(".war"), archive.lastIndexOf(".jar"));
        if (index >= 0) {
            return archive.substring(0, index + 5);
        }
        return "";
    }
}

