/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditorPage;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class StashEditorPage
extends CommitEditorPage {
    public static final int PARENT_COMMIT_STAGED = 1;
    public static final int PARENT_COMMIT_UNTRACKED = 2;
    private Section stagedDiffSection;
    private CommitFileDiffViewer stagedDiffViewer;

    public StashEditorPage(FormEditor editor) {
        super(editor, "stashPage", UIText.CommitEditorPage_Title);
    }

    @Override
    String getParentCommitLabel(int i) {
        switch (i) {
            case 0: {
                return UIText.StashEditorPage_LabelParent0;
            }
            case 1: {
                return UIText.StashEditorPage_LabelParent1;
            }
            case 2: {
                return UIText.StashEditorPage_LabelParent2;
            }
        }
        throw new IllegalStateException("Unexpected parent with index" + i);
    }

    @Override
    void createTagsArea(Composite parent, FormToolkit toolkit, int span) {
    }

    @Override
    void createChangesArea(Composite displayArea, FormToolkit toolkit) {
        this.createDiffArea(displayArea, toolkit, 2);
        this.createIndexArea(displayArea, toolkit, 2);
    }

    private void createIndexArea(Composite parent, FormToolkit toolkit, int span) {
        String sectionTitle = MessageFormat.format(UIText.StashEditorPage_StagedChanges, 0);
        this.stagedDiffSection = this.createSection(parent, toolkit, sectionTitle, span);
        Composite unstagedChangesArea = this.createSectionClient(this.stagedDiffSection, toolkit);
        this.stagedDiffViewer = new CommitFileDiffViewer(unstagedChangesArea, (IWorkbenchSite)this.getSite(), 0x10302 | toolkit.getBorderStyle());
        Control control = this.stagedDiffViewer.getControl();
        control.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        this.addToFocusTracking(control);
        this.stagedDiffViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.stagedDiffViewer.setTreeWalk(this.getCommit().getRepository(), null);
        this.updateSectionClient(this.stagedDiffSection, unstagedChangesArea, toolkit);
    }

    @Override
    void loadSections() {
        RepositoryCommit commit = this.getCommit();
        Job refreshJob = new Job(MessageFormat.format(UIText.CommitEditorPage_JobName, commit.getRevCommit().name())){

            protected IStatus run(IProgressMonitor monitor) {
                final FileDiff[] unstagedDiffs = StashEditorPage.this.getUnstagedDiffs();
                final FileDiff[] indexDiffs = StashEditorPage.this.getStagedDiffs();
                final ScrolledForm form = StashEditorPage.this.getManagedForm().getForm();
                if (UIUtils.isUsable((Control)form)) {
                    form.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!UIUtils.isUsable((Control)form)) {
                                return;
                            }
                            StashEditorPage.this.fillDiffs(unstagedDiffs);
                            StashEditorPage.this.fillStagedDiffs(indexDiffs);
                            form.reflow(true);
                            form.layout(true, true);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.setRule((ISchedulingRule)this);
        refreshJob.schedule();
    }

    protected FileDiff[] getStagedDiffs() {
        ArrayList<FileDiff> stagedDiffsResult = new ArrayList<FileDiff>();
        if (this.getCommit().getRevCommit().getParentCount() > 1) {
            RevCommit stagedCommit = this.getCommit().getRevCommit().getParent(1);
            FileDiff[] stagedDiffs = new RepositoryCommit(this.getCommit().getRepository(), stagedCommit).getDiffs();
            stagedDiffsResult.addAll(Arrays.asList(stagedDiffs));
        }
        return stagedDiffsResult.toArray(new FileDiff[0]);
    }

    protected FileDiff[] getUnstagedDiffs() {
        ArrayList<FileDiff> unstagedDiffs = new ArrayList<FileDiff>();
        RevCommit stagedCommit = this.getCommit().getRevCommit().getParent(1);
        List<FileDiff> workingDirDiffs = Arrays.asList(this.getCommit().getDiffs(stagedCommit));
        unstagedDiffs.addAll(workingDirDiffs);
        if (this.getCommit().getRevCommit().getParentCount() > 2) {
            RevCommit untrackedCommit = this.getCommit().getRevCommit().getParent(2);
            FileDiff[] untrackedDiffs = new RepositoryCommit(this.getCommit().getRepository(), untrackedCommit).getDiffs();
            unstagedDiffs.addAll(Arrays.asList(untrackedDiffs));
        }
        Collections.sort(unstagedDiffs, FileDiff.PATH_COMPARATOR);
        return unstagedDiffs.toArray(new FileDiff[0]);
    }

    private void fillStagedDiffs(FileDiff[] diffs) {
        if (diffs == null) {
            return;
        }
        this.stagedDiffViewer.setInput(diffs);
        this.stagedDiffSection.setText(MessageFormat.format(UIText.StashEditorPage_StagedChanges, diffs.length));
        StashEditorPage.setSectionExpanded(this.stagedDiffSection, diffs.length != 0);
    }

    @Override
    String getDiffSectionTitle(Integer numChanges) {
        return MessageFormat.format(UIText.StashEditorPage_UnstagedChanges, numChanges);
    }
}

