/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.push.ConfirmationPage;
import org.eclipse.egit.ui.internal.push.PushJob;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class PushWizard
extends Wizard {
    private static final String HELP_CONTEXT = "org.eclipse.egit.ui.PushWizard";
    private Repository localDb;
    private final RepositorySelectionPage repoPage;
    private final RefSpecPage refSpecPage;
    private ConfirmationPage confirmPage;

    private static String getURIsString(Collection<URIish> uris) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (URIish uri : uris) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(uri);
        }
        return sb.toString();
    }

    public PushWizard(Repository localDb) throws URISyntaxException {
        this.localDb = localDb;
        List remotes = RemoteConfig.getAllRemoteConfigs((Config)localDb.getConfig());
        this.repoPage = new RepositorySelectionPage(false, remotes, null);
        this.repoPage.setHelpContext(HELP_CONTEXT);
        this.refSpecPage = new RefSpecPage(localDb, true){

            public void setVisible(boolean visible) {
                if (visible) {
                    this.setSelection(PushWizard.this.repoPage.getSelection());
                    this.setCredentials(PushWizard.this.repoPage.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.refSpecPage.setHelpContext(HELP_CONTEXT);
        this.confirmPage = new ConfirmationPage(localDb){

            public void setVisible(boolean visible) {
                if (visible) {
                    this.setSelection(PushWizard.this.repoPage.getSelection(), PushWizard.this.refSpecPage.getRefSpecs());
                    this.setCredentials(PushWizard.this.repoPage.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.confirmPage.setHelpContext(HELP_CONTEXT);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_PUSH);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repoPage);
        this.addPage((IWizardPage)this.refSpecPage);
        this.addPage((IWizardPage)this.confirmPage);
    }

    public boolean canFinish() {
        RepositorySelection sel;
        if (this.getContainer().getCurrentPage() == this.repoPage && (sel = this.repoPage.getSelection()).isConfigSelected()) {
            RemoteConfig config = sel.getConfig();
            return !config.getPushURIs().isEmpty() || !config.getURIs().isEmpty();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        boolean calledFromRepoPage = false;
        if (this.getContainer().getCurrentPage() == this.repoPage) {
            calledFromRepoPage = true;
        }
        if (this.repoPage.getSelection().isConfigSelected() && this.refSpecPage.isSaveRequested()) {
            this.saveRefSpecs();
        }
        if (this.repoPage.getStoreInSecureStore() && !SecureStoreUtils.storeCredentials(this.repoPage.getCredentials(), this.repoPage.getSelection().getURI())) {
            return false;
        }
        PushOperation operation = this.createPushOperation(calledFromRepoPage);
        if (operation == null) {
            return false;
        }
        UserPasswordCredentials credentials = this.repoPage.getCredentials();
        if (credentials != null) {
            operation.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()));
        }
        PushOperationResult resultToCompare = this.confirmPage.isShowOnlyIfChangedSelected() ? this.confirmPage.getConfirmedResult() : null;
        PushJob job = new PushJob(NLS.bind((String)UIText.PushWizard_jobName, (Object)PushWizard.getURIsString(operation.getSpecification().getURIs())), this.localDb, operation, resultToCompare, PushWizard.getDestinationString(this.repoPage.getSelection()), true);
        job.setUser(true);
        job.schedule();
        this.repoPage.saveUriInPrefs();
        return true;
    }

    public String getWindowTitle() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.repoPage || currentPage == null) {
            return UIText.PushWizard_windowTitleDefault;
        }
        String destination = PushWizard.getDestinationString(this.repoPage.getSelection());
        return NLS.bind((String)UIText.PushWizard_windowTitleWithDestination, (Object)destination);
    }

    private void saveRefSpecs() {
        RemoteConfig rc = this.repoPage.getSelection().getConfig();
        rc.setPushRefSpecs(this.refSpecPage.getRefSpecs());
        StoredConfig config = this.localDb.getConfig();
        rc.update((Config)config);
        try {
            config.save();
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_cantSaveTitle, (String)UIText.PushWizard_cantSaveMessage, (IStatus)new Status(2, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PushOperation createPushOperation(boolean calledFromRepoPage) {
        try {
            PushOperationSpecification spec;
            RemoteConfig config = this.repoPage.getSelection().getConfig();
            if (calledFromRepoPage) {
                ArrayList pushSpecs = new ArrayList();
                pushSpecs.addAll(config.getPushRefSpecs());
                Collection updates = Transport.findRemoteRefUpdatesFor((Repository)this.localDb, pushSpecs, (Collection)config.getFetchRefSpecs());
                spec = new PushOperationSpecification();
                for (URIish uri : this.repoPage.getSelection().getPushURIs()) {
                    spec.addURIRefUpdates(uri, ConfirmationPage.copyUpdates(updates));
                }
            } else if (this.confirmPage.isConfirmed()) {
                PushOperationResult confirmedResult = this.confirmPage.getConfirmedResult();
                spec = confirmedResult.deriveSpecification(this.confirmPage.isRequireUnchangedSelected());
            } else {
                List fetchSpecs = config != null ? config.getFetchRefSpecs() : null;
                Collection updates = Transport.findRemoteRefUpdatesFor((Repository)this.localDb, this.refSpecPage.getRefSpecs(), (Collection)fetchSpecs);
                if (updates.isEmpty()) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_missingRefsTitle, null, (IStatus)new Status(4, Activator.getPluginId(), UIText.PushWizard_missingRefsMessage));
                    return null;
                }
                spec = new PushOperationSpecification();
                for (URIish uri : this.repoPage.getSelection().getPushURIs()) {
                    spec.addURIRefUpdates(uri, ConfirmationPage.copyUpdates(updates));
                }
            }
            int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
            return new PushOperation(this.localDb, spec, false, timeout);
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_cantPrepareUpdatesTitle, (String)UIText.PushWizard_cantPrepareUpdatesMessage, (IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
            return null;
        }
    }

    static String getDestinationString(RepositorySelection repoSelection) {
        String destination = repoSelection.isConfigSelected() ? repoSelection.getConfigName() : repoSelection.getURI(true).toString();
        return destination;
    }
}

