/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.contentassist;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.core.xpath.XPathManager;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.editor.contentassist.NodeContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.ui.ImageResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultDOMContentAssistAdditionalProposalInfoProvider
extends NodeContentAssistAdditionalProposalInfoProvider {
    public static final IContentAssistAdditionalProposalInfoProvider<Node> INSTANCE = new DefaultDOMContentAssistAdditionalProposalInfoProvider();

    @Override
    public Image getImage(Node node) {
        if (node == null) {
            return null;
        }
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ImageResource.getImage((String)"attribute_obj");
            }
            case 3: {
                return ImageResource.getImage((String)"text_obj");
            }
            case 1: {
                return ImageResource.getImage((String)"element_obj");
            }
        }
        return null;
    }

    @Override
    public String getDisplayText(String displayText, Node node) {
        String fileName = DOMUtils.getFileName((IDOMNode)((IDOMNode)node));
        return super.getDisplayText(String.valueOf(displayText) + " - [" + fileName + "]", node);
    }

    @Override
    public String getTextInfo(Node node) {
        short nodeType = node.getNodeType();
        StringBuilder buf = new StringBuilder();
        switch (nodeType) {
            case 2: {
                Attr attr = (Attr)node;
                buf.append("<b>Node type:</b> Attribute");
                buf.append("<br><b>Attr name: </b>");
                buf.append(attr.getName());
                buf.append("<br><b>Attr value: </b>");
                buf.append(attr.getValue());
                break;
            }
            case 3: {
                Text text = (Text)node;
                buf.append("<b>Node type:</b> Text");
                buf.append("<br><b>Text content: </b>");
                buf.append(DOMUtils.getTextContent((Text)text));
                break;
            }
            case 1: {
                Element element = (Element)node;
                buf.append("<b>Node type:</b> Element");
                buf.append("<br><b>Element name: </b>");
                buf.append(element.getNodeName());
            }
        }
        Element element = DOMUtils.getOwnerElement((Node)node);
        if (element != null) {
            buf.append("<br><b>Owner element:</b><ul> ");
            Attr attr = null;
            NamedNodeMap attributes = element.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                attr = (Attr)attributes.item(i);
                buf.append("<li><b>@");
                buf.append(attr.getName());
                buf.append(": </b>");
                buf.append(attr.getValue());
                buf.append("</li>");
                ++i;
            }
            buf.append("</ul>");
        }
        buf.append("<br><b>XPath:</b> ");
        buf.append(XPathManager.getManager().computeBasicXPath(node, XPathManager.getManager().getNamespaceInfo(node)));
        buf.append("<br><b>File:</b> ");
        String baseLocation = ((IDOMNode)node).getModel().getBaseLocation();
        buf.append(baseLocation);
        return buf.toString();
    }
}

