/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.hyperlink;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.w3c.dom.Node;

public class HyperlinkUtils {
    public static IRegion getHyperlinkRegion(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 10: {
                    IDOMNode docNode = (IDOMNode)node;
                    return new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
                }
                case 1: {
                    IDOMElement element = (IDOMElement)node;
                    int endOffset = element.hasEndTag() && element.isClosed() ? element.getStartEndOffset() : element.getEndOffset();
                    return new Region(element.getStartOffset(), endOffset - element.getStartOffset());
                }
                case 2: {
                    IDOMAttr att = (IDOMAttr)node;
                    int regOffset = att.getValueRegionStartOffset();
                    int regLength = att.getValueRegionText().length();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    return new Region(regOffset, regLength);
                }
            }
        }
        return null;
    }
}

