/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.references;

import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.search.core.xpath.NamespaceInfos;
import org.eclipse.wst.xml.search.editor.internal.references.AbstractXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToJavaMethod;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.IJavaMethodQuerySpecification;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.classnameprovider.IClassNameExtractor;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.classnameprovider.XPathClassNameExtractor;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor.IJavaMethodRequestor;
import org.w3c.dom.Node;

public class XMLReferenceToJavaMethod
extends AbstractXMLReferenceTo
implements IXMLReferenceToJavaMethod {
    private static final String PARENT_TOKEN = "../";
    private static final int PARENT_TOKEN_LENGTH = "../".length();
    private final String pathForClass;
    private final IJavaMethodQuerySpecification querySpecification;
    private boolean findByParentNode = false;
    private String findByAttrName = null;

    public XMLReferenceToJavaMethod(IReference ownerReference, String id, IXMLSearcher searcher, String querySpecificationId, String pathForClass, IJavaMethodQuerySpecification querySpecification, String tokenId) {
        super(ownerReference, id, searcher, querySpecificationId, tokenId);
        this.pathForClass = pathForClass;
        this.querySpecification = querySpecification;
        if (pathForClass != null) {
            this.findByAttrName = XMLReferenceToJavaMethod.getAttrCondition(pathForClass);
            if (this.findByAttrName == null && pathForClass.startsWith(PARENT_TOKEN)) {
                this.findByParentNode = true;
                this.findByAttrName = XMLReferenceToJavaMethod.getAttrCondition(pathForClass.substring(PARENT_TOKEN_LENGTH, pathForClass.length()));
            }
        }
    }

    private static String getAttrCondition(String s) {
        if (s.startsWith("@")) {
            return s.substring(1, s.length());
        }
        return null;
    }

    @Override
    public IXMLReferenceTo.ToType getType() {
        return IXMLReferenceTo.ToType.JAVA_METHOD;
    }

    @Override
    public String getPathForClass() {
        return this.pathForClass;
    }

    @Override
    public IClassNameExtractor getClassNameExtractor(Object selectedNode, IFile file) {
        if (this.querySpecification != null) {
            return this.querySpecification.getClassNameExtractor(selectedNode, file);
        }
        return null;
    }

    @Override
    public String[] extractClassNames(Node selectedNode, IFile file, String xpathFactoryProviderId, NamespaceInfos namespaceInfo) throws XPathExpressionException {
        IClassNameExtractor extractor = this.getClassNameExtractor(selectedNode, file);
        if (extractor == null) {
            extractor = XPathClassNameExtractor.INSTANCE;
        }
        if (extractor != null) {
            return extractor.extractClassNames(selectedNode, file, this.pathForClass, this.findByAttrName, this.findByParentNode, xpathFactoryProviderId, namespaceInfo);
        }
        return null;
    }

    @Override
    public boolean isFindByParentNode() {
        return this.findByParentNode;
    }

    @Override
    public String getFindByAttrName() {
        return this.findByAttrName;
    }

    @Override
    public IJavaMethodRequestor getRequestor(Object selectedNode, IFile file) {
        if (this.querySpecification != null) {
            return this.querySpecification.getRequestor(selectedNode, file);
        }
        return null;
    }
}

