/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class DocumentHelper {
    public static StringArgument findStringArgument(IDocument document, int offset, boolean full) {
        boolean stop = false;
        StringBuilder matchingString = new StringBuilder("");
        Region region = null;
        String s = null;
        try {
            IRegion li = document.getLineInformationOfOffset(offset);
            int i = offset - 1;
            while (i >= li.getOffset() && !stop) {
                s = document.get(i, 1);
                if (s.equals("\"")) {
                    stop = true;
                }
                if (!stop) {
                    matchingString.insert(0, s);
                } else {
                    int j = offset;
                    while (j <= li.getOffset() + li.getLength()) {
                        s = document.get(j, 1);
                        if (s.equals("\"")) {
                            region = new Region(i + 1, j - i - 1);
                            return new StringArgument((IRegion)region, matchingString.toString());
                        }
                        if (full) {
                            matchingString.append(s);
                        }
                        ++j;
                    }
                }
                --i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public static class StringArgument {
        private final IRegion region;
        private final String matchingString;

        public StringArgument(IRegion region, String matchingString) {
            this.region = region;
            this.matchingString = matchingString;
        }

        public IRegion getRegion() {
            return this.region;
        }

        public String getMatchingString() {
            return this.matchingString;
        }
    }
}

