/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor.IJavaMethodRequestor;

public abstract class AbstractJavaMethodRequestor
implements IJavaMethodRequestor {
    @Override
    public String matchPartial(Object selectedNode, String matching, IMethod method) {
        IStatus status = this.validate(method);
        if (status == null || !status.isOK()) {
            return null;
        }
        String methodNameTest = this.formatMethodName(selectedNode, method);
        if (methodNameTest != null && this.isMatchPartial(matching, methodNameTest)) {
            return methodNameTest;
        }
        return null;
    }

    protected boolean isMatchPartial(String matching, String methodNameTest) {
        return methodNameTest.startsWith(matching);
    }

    @Override
    public IStatus matchTotally(Object selectedNode, String matching, IMethod method) {
        String methodNameTest = this.formatMethodName(selectedNode, method);
        if (methodNameTest != null && this.isMatchTotally(matching, methodNameTest)) {
            return this.validate(method);
        }
        return Status.CANCEL_STATUS;
    }

    protected boolean isMatchTotally(String methodNameFromXML, String methodNameTest) {
        return methodNameFromXML.equals(methodNameTest);
    }

    protected abstract String formatMethodName(Object var1, IMethod var2);

    protected IStatus validate(IMethod method) {
        return this.doValidate(method);
    }

    protected IStatus doValidate(IMethod method) {
        try {
            if (method.isConstructor()) {
                return Status.CANCEL_STATUS;
            }
            int flags = method.getFlags();
            Boolean checkIsPublic = this.checkIsPublic();
            if (checkIsPublic != null && !Flags.isPublic((int)flags) == checkIsPublic) {
                return Status.CANCEL_STATUS;
            }
            Boolean checkIsInterface = this.checkIsInterface();
            if (checkIsInterface != null && !Flags.isInterface((int)flags) == checkIsInterface) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (JavaModelException e) {
            Trace.trace((byte)3, "Method constructor", e);
        }
        return Status.OK_STATUS;
    }

    protected Boolean checkIsPublic() {
        return true;
    }

    protected Boolean checkIsInterface() {
        return false;
    }
}

