/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.internal.Messages;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToJava;
import org.eclipse.wst.xml.search.editor.validation.LocalizedMessage;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ValidatorUtils {
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$wst$xml$search$editor$references$IXMLReferenceTo$ToType;

    public static LocalizedMessage createMessage(IDOMAttr attr, IXMLReference reference, int nbElements) {
        if (nbElements == 1) {
            return null;
        }
        String textContent = attr.getValue();
        int start = attr.getValueRegionStartOffset();
        return ValidatorUtils.createMessage((IDOMNode)attr, start, reference, nbElements, textContent);
    }

    public static LocalizedMessage createMessage(IDOMText text, IXMLReference reference, int nbElements) {
        if (nbElements == 1) {
            return null;
        }
        String textContent = DOMUtils.getTextContent((Text)text);
        int start = text.getStartOffset();
        return ValidatorUtils.createMessage((IDOMNode)text, start, reference, nbElements, textContent);
    }

    public static LocalizedMessage createMessage(IDOMNode node, int start, IXMLReference reference, int nbElements, String textContent) {
        int length = textContent.trim().length() + 2;
        String messageText = ValidatorUtils.getMessageText(reference, nbElements, textContent);
        int severity = ValidatorUtils.getSeverity(reference, nbElements);
        return ValidatorUtils.createMessage(start, length, messageText, severity, node.getStructuredDocument());
    }

    public static int getSeverity(IXMLReference reference, int nbElements) {
        if (nbElements < 1) {
            return 1;
        }
        return 2;
    }

    public static String getMessageText(IXMLReference reference, int nbElements, String textContent, Node node, IFile file) {
        if (nbElements < 0) {
            for (IXMLReferenceTo to : reference.getTo()) {
                IType[] superTypes;
                if (to.getType() != IXMLReferenceTo.ToType.JAVA || (superTypes = ((IXMLReferenceToJava)to).getExtends(node, file)) == null || superTypes.length <= 0) continue;
                StringBuilder sb = new StringBuilder();
                IType[] iTypeArray = superTypes;
                int n = superTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    sb.append(type.getFullyQualifiedName());
                    sb.append(", ");
                    ++n2;
                }
                String superTypeNames = sb.toString().replaceAll(", $", "");
                return NLS.bind((String)ValidatorUtils.getTypeHierarchyIncorrectMessage(), (Object)textContent, (Object)superTypeNames);
            }
        }
        if (nbElements < 1) {
            return NLS.bind((String)ValidatorUtils.getNotFoundedMessage(reference.getTo().get(0)), (Object)textContent, (Object)nbElements);
        }
        if (nbElements > 1) {
            return NLS.bind((String)ValidatorUtils.getNonUniqueMessage(reference.getTo().get(0)), (Object)textContent, (Object)nbElements);
        }
        return NLS.bind((String)ValidatorUtils.getDefaultMessage(), (Object)textContent);
    }

    public static String getMessageText(IXMLReference reference, int nbElements, String textContent) {
        if (nbElements < 1) {
            return NLS.bind((String)ValidatorUtils.getNotFoundedMessage(reference.getTo().get(0)), (Object)textContent, (Object)nbElements);
        }
        return NLS.bind((String)ValidatorUtils.getNonUniqueMessage(reference.getTo().get(0)), (Object)textContent, (Object)nbElements);
    }

    public static LocalizedMessage createMessage(int start, int length, String messageText, int severity, IStructuredDocument structuredDocument) {
        int lineNo = ValidatorUtils.getLineNumber(start, (IDocument)structuredDocument);
        LocalizedMessage message = new LocalizedMessage(severity, messageText);
        message.setOffset(start);
        message.setLength(length);
        message.setLineNo(lineNo);
        return message;
    }

    private static int getLineNumber(int start, IDocument document) {
        int lineNo = -1;
        try {
            lineNo = document.getLineOfOffset(start);
        }
        catch (BadLocationException e) {
            Trace.trace((byte)3, e.getMessage(), e);
        }
        return lineNo;
    }

    public static IFile getFile(String delta) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(delta));
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static String getNotFoundedMessage(IXMLReferenceTo referenceTo) {
        switch (referenceTo.getType()) {
            case RESOURCE: {
                return Messages.Validation_FileNotFounded;
            }
            case JAVA: {
                return Messages.Validation_ClassNotFounded;
            }
            case XML: {
                return Messages.Validation_ElementNotFounded;
            }
        }
        return Messages.Validation_ElementNotFounded;
    }

    public static String getNonUniqueMessage(IXMLReferenceTo referenceTo) {
        switch (referenceTo.getType()) {
            case XML: {
                return Messages.Validation_ElementNonUnique;
            }
        }
        return Messages.Validation_ElementNonUnique;
    }

    public static String getTypeHierarchyIncorrectMessage() {
        return Messages.Validation_ClassHierarchyIncorrect;
    }

    private static String getDefaultMessage() {
        return Messages.Validation_ElementInvalid;
    }
}

