/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.InferredType;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;

public class SingleVariableDeclaration
extends VariableDeclaration {
    public static final SimplePropertyDescriptor MODIFIERS_PROPERTY = new SimplePropertyDescriptor(SingleVariableDeclaration.class, "modifiers", Integer.TYPE, true);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = new ChildListPropertyDescriptor(SingleVariableDeclaration.class, "modifiers", IExtendedModifier.class, true);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(SingleVariableDeclaration.class, "name", SimpleName.class, true, false);
    public static final ChildPropertyDescriptor PATTERN_PROPERTY = new ChildPropertyDescriptor(SingleVariableDeclaration.class, "pattern", Name.class, true, false);
    public static final ChildPropertyDescriptor TYPE_PROPERTY = new ChildPropertyDescriptor(SingleVariableDeclaration.class, "type", Type.class, true, false);
    public static final SimplePropertyDescriptor VARARGS_PROPERTY = new SimplePropertyDescriptor(SingleVariableDeclaration.class, "varargs", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor EXTRA_DIMENSIONS_PROPERTY = new SimplePropertyDescriptor(SingleVariableDeclaration.class, "extraDimensions", Integer.TYPE, true);
    public static final ChildPropertyDescriptor INITIALIZER_PROPERTY = new ChildPropertyDescriptor(SingleVariableDeclaration.class, "initializer", Expression.class, false, true);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private ASTNode.NodeList modifiers = null;
    private int modifierFlags = 0;
    private Name pattern = null;
    private Type type = null;
    private boolean variableArity = false;
    private int extraArrayDimensions = 0;
    private Expression optionalInitializer = null;

    static {
        ArrayList propertyList = new ArrayList(6);
        SingleVariableDeclaration.createPropertyList(SingleVariableDeclaration.class, propertyList);
        SingleVariableDeclaration.addProperty(MODIFIERS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(TYPE_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(NAME_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(PATTERN_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(INITIALIZER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = SingleVariableDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(7);
        SingleVariableDeclaration.createPropertyList(SingleVariableDeclaration.class, propertyList);
        SingleVariableDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(TYPE_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(VARARGS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(NAME_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(PATTERN_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(INITIALIZER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = SingleVariableDeclaration.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    SingleVariableDeclaration(AST ast) {
        super(ast);
        if (ast.apiLevel >= 3) {
            this.modifiers = new ASTNode.NodeList(this, MODIFIERS2_PROPERTY);
        }
    }

    @Override
    final SimplePropertyDescriptor internalExtraDimensionsProperty() {
        return EXTRA_DIMENSIONS_PROPERTY;
    }

    @Override
    final ChildPropertyDescriptor internalInitializerProperty() {
        return INITIALIZER_PROPERTY;
    }

    @Override
    final ChildPropertyDescriptor internalNameProperty() {
        return NAME_PROPERTY;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SingleVariableDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == MODIFIERS_PROPERTY) {
            if (get) {
                return this.getModifiers();
            }
            this.setModifiers(value);
            return 0;
        }
        if (property == EXTRA_DIMENSIONS_PROPERTY) {
            if (get) {
                return this.getExtraDimensions();
            }
            this.setExtraDimensions(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == VARARGS_PROPERTY) {
            if (get) {
                return this.isVarargs();
            }
            this.setVarargs(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == TYPE_PROPERTY) {
            if (get) {
                return this.getType();
            }
            this.setType((Type)child);
            return null;
        }
        if (property == INITIALIZER_PROPERTY) {
            if (get) {
                return this.getInitializer();
            }
            this.setInitializer((Expression)child);
            return null;
        }
        if (property == PATTERN_PROPERTY) {
            if (get) {
                return this.getPattern();
            }
            this.setPattern((Name)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 44;
    }

    @Override
    ASTNode clone0(AST target) {
        SingleVariableDeclaration result = new SingleVariableDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        if (this.ast.apiLevel == 2) {
            result.setModifiers(this.getModifiers());
        } else {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
            result.setVarargs(this.isVarargs());
        }
        result.setType((Type)this.getType().clone(target));
        result.setExtraDimensions(this.getExtraDimensions());
        result.setPattern((Name)this.getPattern().clone(target));
        result.setInitializer((Expression)ASTNode.copySubtree(target, this.getInitializer()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel >= 3) {
                this.acceptChildren(visitor, this.modifiers);
            }
            this.acceptChild(visitor, this.getType());
            this.acceptChild(visitor, this.getPattern());
            this.acceptChild(visitor, this.getInitializer());
        }
        visitor.endVisit(this);
    }

    public List modifiers() {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        return this.modifiers;
    }

    public int getModifiers() {
        if (this.modifiers == null) {
            return this.modifierFlags;
        }
        int computedModifierFlags = 0;
        for (Object x : this.modifiers()) {
            if (!(x instanceof Modifier)) continue;
            computedModifierFlags |= ((Modifier)x).getKeyword().toFlagValue();
        }
        return computedModifierFlags;
    }

    public void setModifiers(int modifiers) {
        this.internalSetModifiers(modifiers);
    }

    final void internalSetModifiers(int pmodifiers) {
        this.supportedOnlyIn2();
        this.preValueChange(MODIFIERS_PROPERTY);
        this.modifierFlags = pmodifiers;
        this.postValueChange(MODIFIERS_PROPERTY);
    }

    @Override
    public SimpleName getName() {
        if (this.getPattern().getNodeType() != 42) {
            return null;
        }
        return (SimpleName)this.getPattern();
    }

    @Override
    public void setName(SimpleName variableName) {
        this.setPattern(variableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name getPattern() {
        if (this.pattern == null) {
            SingleVariableDeclaration singleVariableDeclaration = this;
            synchronized (singleVariableDeclaration) {
                if (this.pattern == null) {
                    this.preLazyInit();
                    this.pattern = new SimpleName(this.ast);
                    this.postLazyInit(this.pattern, PATTERN_PROPERTY);
                }
            }
        }
        return this.pattern;
    }

    public void setPattern(Name pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        Name oldChild = this.pattern;
        this.preReplaceChild(oldChild, pattern, PATTERN_PROPERTY);
        this.pattern = pattern;
        this.postReplaceChild(oldChild, pattern, PATTERN_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getType() {
        if (this.type == null) {
            SingleVariableDeclaration singleVariableDeclaration = this;
            synchronized (singleVariableDeclaration) {
                if (this.type == null) {
                    this.preLazyInit();
                    this.type = this.ast.newInferredType(null);
                    this.postLazyInit(this.type, TYPE_PROPERTY);
                }
            }
        }
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            return;
        }
        Type oldChild = this.type;
        this.preReplaceChild(oldChild, type, TYPE_PROPERTY);
        this.type = type instanceof InferredType && ((InferredType)type).getType() == null ? null : type;
        this.postReplaceChild(oldChild, type, TYPE_PROPERTY);
    }

    public boolean isVarargs() {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        return this.variableArity;
    }

    public void setVarargs(boolean variableArity) {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        this.preValueChange(VARARGS_PROPERTY);
        this.variableArity = variableArity;
        this.postValueChange(VARARGS_PROPERTY);
    }

    @Override
    public int getExtraDimensions() {
        return this.extraArrayDimensions;
    }

    @Override
    public void setExtraDimensions(int dimensions) {
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(EXTRA_DIMENSIONS_PROPERTY);
        this.extraArrayDimensions = dimensions;
        this.postValueChange(EXTRA_DIMENSIONS_PROPERTY);
    }

    @Override
    public Expression getInitializer() {
        return this.optionalInitializer;
    }

    @Override
    public void setInitializer(Expression initializer) {
        Expression oldChild = this.optionalInitializer;
        this.preReplaceChild(oldChild, initializer, INITIALIZER_PROPERTY);
        this.optionalInitializer = initializer;
        this.postReplaceChild(oldChild, initializer, INITIALIZER_PROPERTY);
    }

    @Override
    int memSize() {
        return 68;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.modifiers == null ? 0 : this.modifiers.listSize()) + (this.type == null ? 0 : this.getType().treeSize()) + (this.pattern == null ? 0 : this.getPattern().treeSize()) + (this.optionalInitializer == null ? 0 : this.getInitializer().treeSize());
    }
}

