/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.esprima;

import java.util.Map;
import java.util.Stack;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayName;
import org.eclipse.wst.jsdt.core.dom.ArrowFunctionExpression;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.AssignmentName;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DebuggerStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.ExportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForOfStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MetaProperty;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.ModuleSpecifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.ObjectName;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.ProgramElement;
import org.eclipse.wst.jsdt.core.dom.RestElementName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SpreadElement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TemplateElement;
import org.eclipse.wst.jsdt.core.dom.TemplateLiteral;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableKind;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.YieldExpression;
import org.eclipse.wst.jsdt.internal.esprima.ESTreeNodeTypes;
import org.eclipse.wst.jsdt.internal.esprima.EStreeVisitor;
import org.eclipse.wst.jsdt.internal.esprima.EsprimaParser;

public class DOMASTConverter
extends EStreeVisitor {
    private final AST ast;
    private Stack<ASTNode> nodes = new Stack();
    private final JavaScriptUnit root;
    private Stack<SwitchStatement> processingSwitchStatements = new Stack();

    public DOMASTConverter(JavaScriptUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        this.root = unit;
        this.ast = unit.getAST();
    }

    public JavaScriptUnit convert(ScriptObjectMirror jsobject) {
        this.traverse(jsobject);
        Assert.isTrue((boolean)this.nodes.empty(), (String)"Some nodes are not processed");
        return this.root;
    }

    @Override
    public EStreeVisitor.VisitOptions visit(ScriptObjectMirror object, ESTreeNodeTypes nodeType, String key) {
        switch (nodeType) {
            case Program: {
                return this.convertProgram(object);
            }
            case Identifier: {
                return this.convertIdentifier(object);
            }
            case Literal: {
                return this.convertLiteral(object);
            }
            case VariableDeclaration: {
                return this.convertVariableDeclaration(object);
            }
            case VariableDeclarator: {
                return this.convertVariableDeclarator(object);
            }
            case FunctionDeclaration: {
                return this.convertFunctionDeclaration(object);
            }
            case ExpressionStatement: {
                return this.convertExpressionStatement(object);
            }
            case BlockStatement: {
                return this.convertBlockStatement(object);
            }
            case EmptyStatement: {
                return this.convertEmptyStatement(object);
            }
            case DebuggerStatement: {
                return this.convertDebuggerStatememt(object);
            }
            case WithStatement: {
                return this.convertWithStatement(object);
            }
            case ReturnStatement: {
                return this.convertReturnStatement(object);
            }
            case LabeledStatement: {
                return this.converLabeledStatement(object);
            }
            case BreakStatement: {
                return this.convertBreakStatement(object);
            }
            case ContinueStatement: {
                return this.convertContinueStatement(object);
            }
            case IfStatement: {
                return this.convertIfStatement(object);
            }
            case SwitchStatement: {
                return this.convertSwitchStatement(object);
            }
            case SwitchCase: {
                return this.convertSwitchCaseStatement(object);
            }
            case ThrowStatement: {
                return this.convertThrowStatement(object);
            }
            case TryStatement: {
                return this.convertTryStatement(object);
            }
            case CatchClause: {
                return this.convertCatchClause(object);
            }
            case WhileStatement: {
                return this.convertWhileStatement(object);
            }
            case DoWhileStatement: {
                return this.convertDoWhileStatement(object);
            }
            case ForStatement: {
                return this.convertForStatement(object);
            }
            case ForInStatement: {
                return this.convertForInStatement(object);
            }
            case ForOfStatement: {
                return this.convertForOfStatement(object);
            }
            case ClassDeclaration: {
                return this.convertClassDeclaration(object);
            }
            case ClassExpression: {
                return this.convertClassExpression(object);
            }
            case ClassBody: {
                return EStreeVisitor.VisitOptions.CONTINUE;
            }
            case MethodDefinition: {
                return this.convertMethodDefinition(object);
            }
            case ThisExpression: {
                return this.convertThisExpression(object);
            }
            case ArrayExpression: {
                return this.convertArrayExpression(object);
            }
            case ObjectExpression: {
                return this.convertObjectExpression(object);
            }
            case Property: {
                return this.convertPropertyExpression(object);
            }
            case FunctionExpression: {
                return this.convertFunctionExpression(object);
            }
            case UnaryExpression: 
            case UpdateExpression: {
                return this.convertUnaryOperation(object);
            }
            case BinaryExpression: 
            case LogicalExpression: {
                return this.convertBinaryExpression(object);
            }
            case AssignmentExpression: {
                return this.convertAssignmentExpression(object);
            }
            case MemberExpression: {
                return this.convertMemberExpression(object);
            }
            case ConditionalExpression: {
                return this.convertConditionalExpression(object);
            }
            case CallExpression: {
                return this.convertCallExpression(object);
            }
            case SequenceExpression: {
                return this.convertSequenceExpression(object);
            }
            case YieldExpression: {
                return this.convertYieldExpression(object);
            }
            case NewExpression: {
                return this.convertNewExpression(object);
            }
            case ArrowFunctionExpression: {
                return this.convertArrowFunctionExpression(object);
            }
            case Super: {
                return EStreeVisitor.VisitOptions.CONTINUE;
            }
            case RestElement: {
                return this.convertRestElement(object);
            }
            case ArrayPattern: {
                return this.convertArrayPattern(object);
            }
            case ObjectPattern: {
                return this.convertObjectPattern(object);
            }
            case TaggedTemplateExpression: 
            case TemplateLiteral: {
                return this.convertTemplateLiteral(object, key);
            }
            case TemplateElement: {
                return this.convertTemplateElement(object);
            }
            case AssignmentPattern: {
                return this.convertAssignmentPattern(object);
            }
            case SpreadElement: {
                return this.convertSpreadElement(object);
            }
            case MetaProperty: {
                return this.convertMetaProperty(object);
            }
            case ImportDeclaration: {
                return this.convertImportDeclaration(object);
            }
            case ImportSpecifier: {
                return this.convertImportSpecifer(object, false, false);
            }
            case ImportDefaultSpecifier: {
                return this.convertImportSpecifer(object, true, false);
            }
            case ImportNamespaceSpecifier: {
                return this.convertImportSpecifer(object, false, true);
            }
            case ExportNamedDeclaration: {
                return this.convertExportDeclaration(object, false, false);
            }
            case ExportSpecifier: {
                return this.convertExportSpecifier(object);
            }
            case ExportAllDeclaration: {
                return this.convertExportDeclaration(object, false, true);
            }
            case ExportDefaultDeclaration: {
                return this.convertExportDeclaration(object, true, false);
            }
        }
        throw new UnimplementedException(String.valueOf(nodeType.getTypeString()) + " conversion is not implemented");
    }

    @Override
    public EStreeVisitor.VisitOptions endVisit(ScriptObjectMirror object, ESTreeNodeTypes nodeType, String key) {
        if (nodeType == ESTreeNodeTypes.Super) {
            return EStreeVisitor.VisitOptions.CONTINUE;
        }
        ASTNode current = this.nodes.pop();
        this.setRange(object, current);
        ASTNode parent = null;
        if (nodeType != ESTreeNodeTypes.Program) {
            Assert.isTrue((!this.nodes.empty() ? 1 : 0) != 0);
            parent = this.nodes.peek();
        }
        try {
            if (current.getNodeType() == 50) {
                this.processingSwitchStatements.pop();
            }
            if (current.getNodeType() == 106) {
                this.assignModuleSpecifier((ModuleSpecifier)current, parent);
            } else if (current instanceof Expression) {
                this.assignExpressionToParent((Expression)current, parent, key);
            } else if (current instanceof ProgramElement) {
                this.assignStatementToParent((ProgramElement)current, parent, key);
            } else if (current instanceof VariableDeclaration) {
                this.assignVariableDeclarationToParent((VariableDeclaration)current, parent);
            } else if (current.getNodeType() == 12) {
                this.assignCatchToTry(current, parent);
            } else if (current.getNodeType() == 101) {
                this.assingTemplateElement(current, parent);
            } else if (current.getNodeType() == 26) {
                this.root.imports().add(current);
            } else if (current.getNodeType() == 107) {
                this.root.exports().add(current);
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder(e.toString());
            sb.append(" assigning ");
            sb.append(current.getClass().getSimpleName());
            sb.append("[");
            sb.append(current);
            sb.append("]");
            if (parent != null) {
                sb.append(" to ");
                sb.append(parent.getClass().getSimpleName());
                sb.append("[");
                sb.append(parent);
                sb.append("]");
            }
            System.out.println(sb);
            throw e;
        }
        if (current.getStartPosition() < 0) {
            throw new IllegalStateException();
        }
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private void assignModuleSpecifier(ModuleSpecifier module, ASTNode parent) {
        switch (parent.getNodeType()) {
            case 26: {
                ImportDeclaration importDec = (ImportDeclaration)parent;
                importDec.specifiers().add(module);
                break;
            }
            case 107: {
                ExportDeclaration exportDec = (ExportDeclaration)parent;
                exportDec.specifiers().add(module);
                break;
            }
            default: {
                throw new UnimplementedException("Assigning " + module + " to " + parent + " is not handled");
            }
        }
    }

    private void assingTemplateElement(ASTNode current, ASTNode parent) {
        ((TemplateLiteral)parent).elements().add(current);
    }

    private void setRange(ScriptObjectMirror object, ASTNode node) {
        Object o = object.getMember("range");
        if (ScriptObjectMirror.isUndefined((Object)o)) {
            return;
        }
        ScriptObjectMirror range = (ScriptObjectMirror)o;
        Number x = (Number)range.getSlot(0);
        Number y = (Number)range.getSlot(1);
        int startPosition = x.intValue();
        int length = y.intValue() - x.intValue();
        node.setSourceRange(startPosition, length);
        switch (node.getNodeType()) {
            case 109: {
                FunctionDeclarationStatement fd = (FunctionDeclarationStatement)node;
                if (fd.getDeclaration().getJavadoc() == null) {
                    fd.getDeclaration().setSourceRange(startPosition, length);
                    break;
                }
                int jsdocStart = fd.getDeclaration().getJavadoc().getStartPosition();
                fd.getDeclaration().setSourceRange(jsdocStart, length + startPosition - jsdocStart);
                break;
            }
            case 84: {
                FunctionExpression fe = (FunctionExpression)node;
                if (fe.getMethod().getJavadoc() == null) {
                    fe.getMethod().setSourceRange(startPosition, length);
                    break;
                }
                int jsdocStart = fe.getMethod().getJavadoc().getStartPosition();
                fe.getMethod().setSourceRange(jsdocStart, length + startPosition - jsdocStart);
                break;
            }
            case 31: {
                FunctionDeclaration fdec = (FunctionDeclaration)node;
                if (fdec.getJavadoc() == null) break;
                int jsdocStart = fdec.getJavadoc().getStartPosition();
                fdec.setSourceRange(jsdocStart, length + startPosition - jsdocStart);
                break;
            }
            case 60: {
                VariableDeclarationStatement vds = (VariableDeclarationStatement)node;
                if (vds.getJavadoc() == null) break;
                int jsdocStart = vds.getJavadoc().getStartPosition();
                vds.setSourceRange(jsdocStart, length + startPosition - jsdocStart);
            }
        }
    }

    private void assignStatementToParent(ProgramElement statement, ASTNode parent, String key) {
        switch (parent.getNodeType()) {
            case 15: {
                JavaScriptUnit unit = (JavaScriptUnit)parent;
                unit.statements().add(statement);
                break;
            }
            case 84: {
                FunctionExpression fe = (FunctionExpression)parent;
                fe.getMethod().setBody((Block)statement);
                break;
            }
            case 31: {
                FunctionDeclaration fdec = (FunctionDeclaration)parent;
                fdec.setBody((Block)statement);
                break;
            }
            case 109: {
                FunctionDeclarationStatement fdecS = (FunctionDeclarationStatement)parent;
                fdecS.getDeclaration().setBody((Block)statement);
                break;
            }
            case 94: {
                ArrowFunctionExpression af = (ArrowFunctionExpression)parent;
                af.setBody((Block)statement);
                break;
            }
            case 8: {
                Block b = (Block)parent;
                b.statements().add(statement);
                break;
            }
            case 90: {
                WithStatement ws = (WithStatement)parent;
                ws.setBody((Statement)statement);
                break;
            }
            case 30: {
                LabeledStatement ls = (LabeledStatement)parent;
                ls.setBody((Statement)statement);
                break;
            }
            case 25: {
                IfStatement is = (IfStatement)parent;
                if ("alternate".equals(key)) {
                    is.setElseStatement((Statement)statement);
                    break;
                }
                if (!"consequent".equals(key)) break;
                is.setThenStatement((Statement)statement);
                break;
            }
            case 50: {
                SwitchStatement ss = (SwitchStatement)parent;
                if (statement.getNodeType() == 49) break;
                ss.statements().add(statement);
                break;
            }
            case 49: {
                this.processingSwitchStatements.peek().statements().add(statement);
                break;
            }
            case 12: {
                CatchClause cc = (CatchClause)parent;
                cc.setBody((Block)statement);
                break;
            }
            case 54: {
                TryStatement ts = (TryStatement)parent;
                if ("block".equals(key)) {
                    ts.setBody((Block)statement);
                    break;
                }
                ts.setFinally((Block)statement);
                break;
            }
            case 61: {
                WhileStatement whileS = (WhileStatement)parent;
                whileS.setBody((Statement)statement);
                break;
            }
            case 19: {
                DoStatement ds = (DoStatement)parent;
                ds.setBody((Statement)statement);
                break;
            }
            case 24: {
                ForStatement fs = (ForStatement)parent;
                fs.setBody((Statement)statement);
                break;
            }
            case 83: {
                ForInStatement fis = (ForInStatement)parent;
                if ("left".equals(key)) {
                    fis.setIterationVariable((Statement)statement);
                    break;
                }
                if (!"body".equals(key)) break;
                fis.setBody((Statement)statement);
                break;
            }
            case 96: {
                ForOfStatement fos = (ForOfStatement)parent;
                if ("left".equals(key)) {
                    fos.setIterationVariable((Statement)statement);
                    break;
                }
                if (!"body".equals(key)) break;
                fos.setBody((Statement)statement);
                break;
            }
            case 55: {
                TypeDeclaration typeDec = (TypeDeclaration)parent;
                typeDec.bodyDeclarations().add(statement);
                break;
            }
            case 56: 
            case 108: {
                break;
            }
            case 107: {
                ExportDeclaration edec = (ExportDeclaration)parent;
                if (!"declaration".equals(key)) break;
                edec.setDeclaration(statement);
                break;
            }
            default: {
                throw new UnimplementedException("Assigning " + statement + " to " + parent + " is not handled");
            }
        }
    }

    private void assignVariableDeclarationToParent(VariableDeclaration declaration, ASTNode parent) {
        switch (parent.getNodeType()) {
            case 60: {
                VariableDeclarationStatement vd = (VariableDeclarationStatement)parent;
                vd.fragments().add(declaration);
                break;
            }
            case 84: {
                FunctionExpression fe = (FunctionExpression)parent;
                fe.getMethod().parameters().add((SingleVariableDeclaration)declaration);
                break;
            }
            case 58: {
                VariableDeclarationExpression ve = (VariableDeclarationExpression)parent;
                ve.fragments().add(declaration);
                break;
            }
            case 31: {
                FunctionDeclaration fd = (FunctionDeclaration)parent;
                fd.parameters().add(declaration);
                break;
            }
            default: {
                throw new UnimplementedException("Assigning " + declaration + " to " + parent + " is not handled");
            }
        }
    }

    private void assignExpressionToParent(Expression expression, ASTNode parent, String key) {
        switch (parent.getNodeType()) {
            case 21: {
                ((ExpressionStatement)parent).setExpression(expression);
                break;
            }
            case 7: {
                if ("left".equals(key)) {
                    ((Assignment)parent).setLeftHandSide(expression);
                    break;
                }
                ((Assignment)parent).setRightHandSide(expression);
                break;
            }
            case 59: {
                if (expression.getNodeType() != 42) {
                    ((VariableDeclarationFragment)parent).setInitializer(expression);
                    break;
                }
                ((VariableDeclarationFragment)parent).setName((SimpleName)expression);
                break;
            }
            case 4: {
                ((ArrayInitializer)parent).expressions().add(expression);
                break;
            }
            case 85: {
                ((ObjectLiteral)parent).fields().add(expression);
                break;
            }
            case 86: {
                ObjectLiteralField olf = (ObjectLiteralField)parent;
                if ("key".equals(key)) {
                    olf.setFieldName(expression);
                    break;
                }
                if (!"value".equals(key)) break;
                olf.setInitializer(expression);
                break;
            }
            case 84: {
                FunctionExpression fe = (FunctionExpression)parent;
                if (!"params".equals(key)) {
                    fe.getMethod().setMethodName(expression);
                    break;
                }
                fe.getMethod().parameters().add(this.wrapWithSingleVariableDeclaration(expression));
                break;
            }
            case 109: {
                FunctionDeclarationStatement fdecS = (FunctionDeclarationStatement)parent;
                if ("params".equals(key)) {
                    fdecS.getDeclaration().parameters().add(this.wrapWithSingleVariableDeclaration(expression));
                }
                if ("value".equals(key)) {
                    FunctionExpression fex = (FunctionExpression)expression;
                    fdecS.getDeclaration().setBody((Block)ASTNode.copySubtree(this.ast, fex.getMethod().getBody()));
                }
                if ("key".equals(key)) {
                    fdecS.getDeclaration().setMethodName(expression);
                }
                if (!"id".equals(key)) break;
                fdecS.getDeclaration().setMethodName(expression);
                break;
            }
            case 31: {
                FunctionDeclaration fdec = (FunctionDeclaration)parent;
                if ("params".equals(key)) {
                    fdec.parameters().add(this.wrapWithSingleVariableDeclaration(expression));
                }
                if ("value".equals(key)) {
                    FunctionExpression fex = (FunctionExpression)expression;
                    fdec.setBody((Block)ASTNode.copySubtree(this.ast, fex.getMethod().getBody()));
                }
                if ("key".equals(key)) {
                    fdec.setMethodName(expression);
                }
                if (!"id".equals(key)) break;
                fdec.setMethodName(expression);
                break;
            }
            case 37: {
                ((PostfixExpression)parent).setOperand(expression);
                break;
            }
            case 38: {
                ((PrefixExpression)parent).setOperand(expression);
                break;
            }
            case 27: {
                if ("left".equals(key)) {
                    ((InfixExpression)parent).setLeftOperand(expression);
                    break;
                }
                ((InfixExpression)parent).setRightOperand(expression);
                break;
            }
            case 22: {
                if ("object".equals(key)) {
                    ((FieldAccess)parent).setExpression(expression);
                    break;
                }
                ((FieldAccess)parent).setName((SimpleName)expression);
                break;
            }
            case 2: {
                if ("object".equals(key)) {
                    ((ArrayAccess)parent).setArray(expression);
                    break;
                }
                ((ArrayAccess)parent).setIndex(expression);
                break;
            }
            case 16: {
                ConditionalExpression conditional = (ConditionalExpression)parent;
                if ("test".equals(key)) {
                    conditional.setExpression(expression);
                    break;
                }
                if ("consequent".equals(key)) {
                    conditional.setThenExpression(expression);
                    break;
                }
                conditional.setElseExpression(expression);
                break;
            }
            case 32: {
                FunctionInvocation fi = (FunctionInvocation)parent;
                if ("arguments".equals(key)) {
                    fi.arguments().add(expression);
                    break;
                }
                if (!"callee".equals(key)) break;
                if (expression.getNodeType() != 42) {
                    fi.setExpression(expression);
                    break;
                }
                fi.setName((SimpleName)expression);
                break;
            }
            case 48: {
                SuperMethodInvocation smi = (SuperMethodInvocation)parent;
                if (!"arguments".equals(key)) break;
                smi.arguments().add(expression);
                break;
            }
            case 91: {
                ((ListExpression)parent).expressions().add(expression);
                break;
            }
            case 93: {
                ((YieldExpression)parent).setArgument(expression);
                break;
            }
            case 14: {
                ClassInstanceCreation ci = (ClassInstanceCreation)parent;
                if ("callee".equals(key)) {
                    ci.setMember(expression);
                    break;
                }
                ci.arguments().add(expression);
                break;
            }
            case 94: {
                ArrowFunctionExpression af = (ArrowFunctionExpression)parent;
                if (!"params".equals(key)) {
                    af.setExpression(expression);
                    break;
                }
                af.parameters().add(this.wrapWithSingleVariableDeclaration(expression));
                break;
            }
            case 90: {
                WithStatement ws = (WithStatement)parent;
                ws.setExpression(expression);
                break;
            }
            case 41: {
                ReturnStatement rs = (ReturnStatement)parent;
                rs.setExpression(expression);
                break;
            }
            case 30: {
                LabeledStatement ls = (LabeledStatement)parent;
                ls.setLabel((SimpleName)expression);
                break;
            }
            case 10: {
                BreakStatement bs = (BreakStatement)parent;
                bs.setLabel((SimpleName)expression);
                break;
            }
            case 18: {
                ContinueStatement cs = (ContinueStatement)parent;
                cs.setLabel((SimpleName)expression);
                break;
            }
            case 25: {
                IfStatement is = (IfStatement)parent;
                is.setExpression(expression);
                break;
            }
            case 50: {
                SwitchStatement ss = (SwitchStatement)parent;
                ss.setExpression(expression);
                break;
            }
            case 49: {
                SwitchCase sc = (SwitchCase)parent;
                if (!"test".equals(key)) break;
                sc.setExpression(expression);
                break;
            }
            case 53: {
                ThrowStatement ts = (ThrowStatement)parent;
                ts.setExpression(expression);
                break;
            }
            case 12: {
                CatchClause c = (CatchClause)parent;
                SingleVariableDeclaration d = this.ast.newSingleVariableDeclaration();
                d.setSourceRange(expression.getStartPosition(), expression.getLength());
                d.setPattern((Name)expression);
                c.setException(d);
                break;
            }
            case 61: {
                WhileStatement whileS = (WhileStatement)parent;
                whileS.setExpression(expression);
                break;
            }
            case 19: {
                DoStatement ds = (DoStatement)parent;
                ds.setExpression(expression);
                break;
            }
            case 24: {
                ForStatement fs = (ForStatement)parent;
                if ("test".equals(key)) {
                    fs.setExpression(expression);
                    break;
                }
                if ("init".equals(key)) {
                    fs.initializers().add(expression);
                    break;
                }
                if (!"update".equals(key)) break;
                fs.updaters().add(expression);
                break;
            }
            case 83: {
                ForInStatement fis = (ForInStatement)parent;
                if ("left".equals(key)) {
                    fis.setIterationVariable(this.ast.newExpressionStatement(expression));
                    break;
                }
                if (!"right".equals(key)) break;
                fis.setCollection(expression);
                break;
            }
            case 96: {
                ForOfStatement fos = (ForOfStatement)parent;
                if ("left".equals(key)) {
                    fos.setIterationVariable(this.ast.newExpressionStatement(expression));
                    break;
                }
                if (!"right".equals(key)) break;
                fos.setCollection(expression);
                break;
            }
            case 55: {
                TypeDeclaration td = (TypeDeclaration)parent;
                if ("superClass".equals(key)) {
                    td.setSuperclassExpression(expression);
                    break;
                }
                if (!"id".equals(key)) break;
                td.setName((SimpleName)expression);
                break;
            }
            case 56: {
                break;
            }
            case 97: {
                ArrayName an = (ArrayName)parent;
                an.elements().add(expression);
                break;
            }
            case 98: {
                ObjectName on = (ObjectName)parent;
                on.objectProperties().add(expression);
                break;
            }
            case 99: {
                TemplateLiteral tl = (TemplateLiteral)parent;
                if ("expressions".equals(key)) {
                    tl.expressions().add(expression);
                    break;
                }
                if (!"tag".equals(key)) break;
                tl.setTag(expression);
                break;
            }
            case 102: {
                AssignmentName asn = (AssignmentName)parent;
                if ("right".equals(key)) {
                    asn.setRight(expression);
                    break;
                }
                if (!"left".equals(key)) break;
                asn.setLeft((Name)expression);
                break;
            }
            case 103: {
                RestElementName ren = (RestElementName)parent;
                if (!"argument".equals(key)) break;
                ren.setArgument(expression);
                break;
            }
            case 104: {
                SpreadElement sel = (SpreadElement)parent;
                if (!"argument".equals(key)) break;
                sel.setArgument(expression);
                break;
            }
            case 26: {
                ImportDeclaration idec = (ImportDeclaration)parent;
                idec.setSource((StringLiteral)expression);
                break;
            }
            case 106: {
                ModuleSpecifier specifier = (ModuleSpecifier)parent;
                if ("local".equals(key)) {
                    specifier.setLocal((SimpleName)expression);
                }
                if (!"imported".equals(key)) break;
                specifier.setDiscoverableName((SimpleName)expression);
                break;
            }
            case 107: {
                ExportDeclaration edec = (ExportDeclaration)parent;
                if (!"source".equals(key)) break;
                edec.setSource((StringLiteral)expression);
                break;
            }
            default: {
                throw new UnimplementedException("Assigning " + expression + " to " + parent + " is not handled");
            }
        }
    }

    private SingleVariableDeclaration wrapWithSingleVariableDeclaration(Expression expression) {
        SingleVariableDeclaration $ = this.ast.newSingleVariableDeclaration();
        $.setPattern((Name)expression);
        $.setSourceRange(expression.getStartPosition(), expression.getLength());
        return $;
    }

    private JSdoc buildJSDoc(ScriptObjectMirror object) {
        if (!object.hasMember("leadingComments")) {
            return null;
        }
        Object commentObj = object.getMember("leadingComments");
        if (ScriptObjectMirror.isUndefined((Object)commentObj)) {
            return null;
        }
        ScriptObjectMirror comments = (ScriptObjectMirror)commentObj;
        Object[] arrayElements = comments.entrySet().toArray();
        int i = 0;
        while (i < arrayElements.length) {
            Map.Entry entry = (Map.Entry)arrayElements[i];
            Comment comment = EsprimaParser.createComment((ScriptObjectMirror)entry.getValue(), this.ast);
            if (comment.isDocComment()) {
                return (JSdoc)comment;
            }
            ++i;
        }
        return null;
    }

    private void assignCatchToTry(ASTNode current, ASTNode parent) {
        ((TryStatement)parent).catchClauses().add(current);
    }

    private EStreeVisitor.VisitOptions convertLiteral(ScriptObjectMirror object) {
        Object value = object.getMember("value");
        String raw = (String)object.getMember("raw");
        Expression literal = null;
        if (value instanceof Number) {
            literal = this.ast.newNumberLiteral(raw);
        } else if (value instanceof Boolean) {
            literal = this.ast.newBooleanLiteral(raw);
        } else if (value instanceof String) {
            literal = this.ast.newStringLiteral();
            ((StringLiteral)literal).setEscapedValue(raw);
        } else if (object.hasMember("regex")) {
            literal = this.ast.newRegularExpressionLiteral(raw);
        } else if (value == null) {
            literal = this.ast.newNullLiteral();
        }
        if (literal == null) {
            throw new UnimplementedException("Failed to translate Literal " + value);
        }
        this.nodes.push(literal);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertProgram(ScriptObjectMirror object) {
        this.nodes.push(this.root);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertVariableDeclaration(ScriptObjectMirror object) {
        String kind = (String)object.getMember("kind");
        VariableKind variableKind = VariableKind.VAR;
        if (kind.equals("let")) {
            variableKind = VariableKind.LET;
        } else if (kind.equals("const")) {
            variableKind = VariableKind.CONST;
        }
        int parentType = this.nodes.peek().getNodeType();
        if (parentType == 24) {
            VariableDeclarationExpression e = this.ast.newVariableDeclarationExpression();
            e.setKind(variableKind);
            this.nodes.push(e);
        } else {
            VariableDeclarationStatement e = this.ast.newVariableDeclarationStatement();
            e.setJavadoc(this.buildJSDoc(object));
            e.setKind(variableKind);
            this.nodes.push(e);
        }
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertVariableDeclarator(ScriptObjectMirror object) {
        VariableDeclarationFragment f = this.ast.newVariableDeclarationFragment();
        this.nodes.push(f);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertIdentifier(ScriptObjectMirror object) {
        String s = (String)object.getMember("name");
        SimpleName name = this.ast.newSimpleName(s);
        this.nodes.push(name);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertExpressionStatement(ScriptObjectMirror object) {
        ExpressionStatement es = this.ast.newExpressionStatement();
        this.nodes.push(es);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertAssignmentExpression(ScriptObjectMirror object) {
        Assignment a = this.ast.newAssignment();
        String op = (String)object.getMember("operator");
        a.setOperator(Assignment.Operator.toOperator(op));
        this.nodes.push(a);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertThisExpression(ScriptObjectMirror object) {
        ThisExpression t = this.ast.newThisExpression();
        this.nodes.push(t);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertArrayExpression(ScriptObjectMirror object) {
        ArrayInitializer ai = this.ast.newArrayInitializer();
        this.nodes.push(ai);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertObjectExpression(ScriptObjectMirror object) {
        ObjectLiteral o = this.ast.newObjectLiteral();
        this.nodes.push(o);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertPropertyExpression(ScriptObjectMirror object) {
        ObjectLiteralField of = this.ast.newObjectLiteralField();
        String kind = (String)object.getMember("kind");
        ObjectLiteralField.FieldKind k = null;
        if ("init".equals(kind)) {
            k = ObjectLiteralField.FieldKind.INIT;
        } else if ("get".equals(kind)) {
            k = ObjectLiteralField.FieldKind.GET;
        } else if ("set".equals(kind)) {
            k = ObjectLiteralField.FieldKind.SET;
        }
        of.setKind(k);
        this.nodes.push(of);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertFunctionExpression(ScriptObjectMirror object) {
        FunctionExpression fe = this.ast.newFunctionExpression();
        FunctionDeclaration d = this.ast.newFunctionDeclaration();
        Boolean isGenerator = (Boolean)object.getMember("generator");
        d.setGenerator(isGenerator);
        fe.setMethod(d);
        this.nodes.add(fe);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertFunctionDeclaration(ScriptObjectMirror object) {
        FunctionDeclaration dec = this.ast.newFunctionDeclaration();
        Boolean isGenerator = (Boolean)object.getMember("generator");
        dec.setGenerator(isGenerator);
        dec.setJavadoc(this.buildJSDoc(object));
        int parentType = this.nodes.peek().getNodeType();
        this.nodes.push(parentType == 107 || parentType == 55 || parentType == 15 ? dec : this.ast.newFunctionDeclarationStatement(dec));
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertUnaryOperation(ScriptObjectMirror object) {
        Boolean isPrefix = (Boolean)object.getMember("prefix");
        String operator = (String)object.getMember("operator");
        if (isPrefix.booleanValue()) {
            PrefixExpression pe = this.ast.newPrefixExpression();
            pe.setOperator(PrefixExpression.Operator.toOperator(operator));
            this.nodes.push(pe);
        } else {
            PostfixExpression po = this.ast.newPostfixExpression();
            po.setOperator(PostfixExpression.Operator.toOperator(operator));
            this.nodes.push(po);
        }
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertBinaryExpression(ScriptObjectMirror object) {
        String operator = (String)object.getMember("operator");
        InfixExpression ie = this.ast.newInfixExpression();
        ie.setOperator(InfixExpression.Operator.toOperator(operator));
        this.nodes.push(ie);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertMemberExpression(ScriptObjectMirror object) {
        Boolean computed = (Boolean)object.getMember("computed");
        this.nodes.push(computed != false ? this.ast.newArrayAccess() : this.ast.newFieldAccess());
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertConditionalExpression(ScriptObjectMirror object) {
        ConditionalExpression ce = this.ast.newConditionalExpression();
        this.nodes.push(ce);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertCallExpression(ScriptObjectMirror object) {
        ScriptObjectMirror callee = (ScriptObjectMirror)object.getMember("callee");
        String type = (String)callee.getMember("type");
        if ("Super".equals(type)) {
            SuperMethodInvocation smi = this.ast.newSuperMethodInvocation();
            this.nodes.push(smi);
        } else {
            FunctionInvocation fi = this.ast.newFunctionInvocation();
            this.nodes.push(fi);
        }
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertSequenceExpression(ScriptObjectMirror object) {
        ListExpression le = this.ast.newListExpression();
        this.nodes.push(le);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertYieldExpression(ScriptObjectMirror object) {
        Boolean isDelegate = (Boolean)object.getMember("delegate");
        YieldExpression ye = this.ast.newYieldExpression();
        ye.setDelegate(isDelegate);
        this.nodes.push(ye);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertNewExpression(ScriptObjectMirror object) {
        ClassInstanceCreation ci = this.ast.newClassInstanceCreation();
        this.nodes.push(ci);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertArrowFunctionExpression(ScriptObjectMirror object) {
        ArrowFunctionExpression af = this.ast.newArrowFunctionExpression();
        this.nodes.push(af);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertBlockStatement(ScriptObjectMirror object) {
        Block b = this.ast.newBlock();
        this.nodes.push(b);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertEmptyStatement(ScriptObjectMirror object) {
        EmptyStatement es = this.ast.newEmptyStatement();
        this.nodes.push(es);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertDebuggerStatememt(ScriptObjectMirror object) {
        DebuggerStatement ds = this.ast.newDebuggerStatement();
        this.nodes.push(ds);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertWithStatement(ScriptObjectMirror object) {
        WithStatement ws = this.ast.newWithStatement();
        this.nodes.push(ws);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertReturnStatement(ScriptObjectMirror object) {
        ReturnStatement rs = this.ast.newReturnStatement();
        this.nodes.push(rs);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions converLabeledStatement(ScriptObjectMirror object) {
        LabeledStatement ls = this.ast.newLabeledStatement();
        this.nodes.push(ls);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertBreakStatement(ScriptObjectMirror object) {
        BreakStatement bs = this.ast.newBreakStatement();
        this.nodes.push(bs);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertContinueStatement(ScriptObjectMirror object) {
        ContinueStatement cs = this.ast.newContinueStatement();
        this.nodes.push(cs);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertIfStatement(ScriptObjectMirror object) {
        IfStatement is = this.ast.newIfStatement();
        this.nodes.push(is);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertSwitchStatement(ScriptObjectMirror object) {
        SwitchStatement ss = this.ast.newSwitchStatement();
        this.processingSwitchStatements.push(ss);
        this.nodes.push(ss);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertSwitchCaseStatement(ScriptObjectMirror object) {
        SwitchCase sc = this.ast.newSwitchCase();
        sc.setExpression(null);
        this.nodes.push(sc);
        if (this.processingSwitchStatements.empty()) {
            throw new IllegalStateException("Case statement without a switch");
        }
        this.processingSwitchStatements.peek().statements().add(sc);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertThrowStatement(ScriptObjectMirror object) {
        ThrowStatement ts = this.ast.newThrowStatement();
        this.nodes.push(ts);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertCatchClause(ScriptObjectMirror object) {
        CatchClause cc = this.ast.newCatchClause();
        this.nodes.push(cc);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertTryStatement(ScriptObjectMirror object) {
        TryStatement ts = this.ast.newTryStatement();
        this.nodes.push(ts);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertWhileStatement(ScriptObjectMirror object) {
        WhileStatement ws = this.ast.newWhileStatement();
        this.nodes.push(ws);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertDoWhileStatement(ScriptObjectMirror object) {
        DoStatement ds = this.ast.newDoStatement();
        this.nodes.push(ds);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertForStatement(ScriptObjectMirror object) {
        ForStatement fs = this.ast.newForStatement();
        this.nodes.push(fs);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertForInStatement(ScriptObjectMirror object) {
        ForInStatement fi = this.ast.newForInStatement();
        this.nodes.push(fi);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertForOfStatement(ScriptObjectMirror object) {
        ForOfStatement fo = this.ast.newForOfStatement();
        this.nodes.push(fo);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertClassDeclaration(ScriptObjectMirror object) {
        TypeDeclaration td = this.ast.newTypeDeclaration();
        TypeDeclarationStatement tds = this.ast.newTypeDeclarationStatement((AbstractTypeDeclaration)td);
        this.nodes.push(tds);
        this.nodes.push(td);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertClassExpression(ScriptObjectMirror object) {
        TypeDeclaration td = this.ast.newTypeDeclaration();
        TypeDeclarationExpression tde = this.ast.newTypeDeclarationExpression(td);
        this.nodes.push(tde);
        this.nodes.push(td);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertMethodDefinition(ScriptObjectMirror object) {
        String kind;
        FunctionDeclaration fd = this.ast.newFunctionDeclaration();
        Boolean isStatic = (Boolean)object.getMember("static");
        if (isStatic.booleanValue()) {
            Modifier staticModifier = this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
            fd.modifiers().add(staticModifier);
        }
        if (!"method".equals(kind = (String)object.getMember("kind"))) {
            if ("constructor".equals(kind)) {
                fd.setConstructor(true);
            } else if ("get".equals(kind)) {
                Modifier getModifier = this.ast.newModifier(Modifier.ModifierKeyword.GET_KEYWORD);
                fd.modifiers().add(getModifier);
            } else if ("set".equals(kind)) {
                Modifier setModifier = this.ast.newModifier(Modifier.ModifierKeyword.SET_KEYWORD);
                fd.modifiers().add(setModifier);
            }
        }
        this.nodes.push(fd);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertRestElement(ScriptObjectMirror object) {
        RestElementName ren = this.ast.newRestElementName();
        this.nodes.push(ren);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertArrayPattern(ScriptObjectMirror object) {
        ArrayName an = this.ast.newArrayName();
        this.nodes.push(an);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertObjectPattern(ScriptObjectMirror object) {
        ObjectName on = this.ast.newObjectName();
        this.nodes.push(on);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertTemplateLiteral(ScriptObjectMirror object, String key) {
        if ("quasi".equals(key)) {
            this.nodes.push(this.nodes.peek());
            return EStreeVisitor.VisitOptions.CONTINUE;
        }
        TemplateLiteral literal = this.ast.newTemplateLiteral();
        this.nodes.push(literal);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertTemplateElement(ScriptObjectMirror object) {
        TemplateElement te = this.ast.newTemplateElement();
        ScriptObjectMirror val = (ScriptObjectMirror)object.getMember("value");
        String value = (String)val.getMember("raw");
        Boolean isTail = (Boolean)object.getMember("tail");
        te.setRawValue(value);
        te.setTail(isTail);
        this.nodes.push(te);
        return EStreeVisitor.VisitOptions.SKIP;
    }

    private EStreeVisitor.VisitOptions convertAssignmentPattern(ScriptObjectMirror object) {
        AssignmentName an = this.ast.newAssignmentName();
        this.nodes.push(an);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertSpreadElement(ScriptObjectMirror object) {
        SpreadElement spread = this.ast.newSpreadElement();
        this.nodes.push(spread);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertMetaProperty(ScriptObjectMirror object) {
        MetaProperty mp = this.ast.newMetaProperty();
        String meta = (String)object.getMember("meta");
        String prop = (String)object.getMember("property");
        mp.setMeta(meta);
        mp.setPropertyName(prop);
        this.nodes.push(mp);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertImportDeclaration(ScriptObjectMirror object) {
        ImportDeclaration importDecl = this.ast.newImportDeclaration();
        this.nodes.push(importDecl);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertImportSpecifer(ScriptObjectMirror object, boolean isDefault, boolean isNamespace) {
        ModuleSpecifier specifier = this.ast.newModuleSpecifier();
        specifier.setDefault(isDefault);
        specifier.setNamespace(isNamespace);
        this.nodes.push(specifier);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertExportSpecifier(ScriptObjectMirror object) {
        ModuleSpecifier specifier = this.ast.newModuleSpecifier();
        this.nodes.push(specifier);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }

    private EStreeVisitor.VisitOptions convertExportDeclaration(ScriptObjectMirror object, boolean isDefault, boolean isAll) {
        ExportDeclaration declaration = this.ast.newExportDeclaration();
        declaration.setDefault(isDefault);
        declaration.setAll(isAll);
        this.nodes.push(declaration);
        return EStreeVisitor.VisitOptions.CONTINUE;
    }
}

