/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.epp.internal.mpc.core.util.TextUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalogSource;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.LinkListener;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.OverviewToolTip;
import org.eclipse.epp.internal.mpc.ui.wizards.StyledTextHelper;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ITag;
import org.eclipse.epp.mpc.core.model.ITags;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.AbstractDiscoveryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarketplaceDiscoveryItem<T extends CatalogItem>
extends AbstractDiscoveryItem<T> {
    private static final String FILE_EXTENSION_TAG_PREFIX = "fileExtension_";
    private static final String ELLIPSIS = new String("\u2026");
    private static final int MAX_SHOWN_TAGS = 5;
    private static final int MAX_TOTAL_TAGS = 30;
    protected static final String INFO_HREF = "info";
    private static final String PROVIDER_PLACEHOLDER = "@PROVIDER@";
    protected static final int DESCRIPTION_MARGIN_LEFT = 8;
    protected static final int DESCRIPTION_MARGIN_TOP = 8;
    protected static final int TAGS_MARGIN_TOP = 2;
    protected static final int SEPARATOR_MARGIN_TOP = 8;
    protected static final int MAX_IMAGE_HEIGHT = 86;
    protected static final int MIN_IMAGE_HEIGHT = 64;
    protected static final int MAX_IMAGE_WIDTH = 75;
    public static final String WIDGET_ID_KEY = String.valueOf(AbstractMarketplaceDiscoveryItem.class.getName()) + "::part";
    public static final String WIDGET_ID_NAME = "name";
    public static final String WIDGET_ID_DESCRIPTION = "description";
    public static final String WIDGET_ID_ICON = "description";
    public static final String WIDGET_ID_PROVIDER = "provider";
    public static final String WIDGET_ID_INSTALLS = "installs";
    public static final String WIDGET_ID_TAGS = "tags";
    public static final String WIDGET_ID_RATING = "rating";
    public static final String WIDGET_ID_SHARE = "share";
    public static final String WIDGET_ID_LEARNMORE = "learn more";
    public static final String WIDGET_ID_OVERVIEW = "overview";
    public static final String WIDGET_ID_ALREADY_INSTALLED = "already installed";
    public static final String WIDGET_ID_ACTION = "action";
    private Composite checkboxContainer;
    protected final CatalogItem connector;
    private StyledText description;
    private Label iconLabel;
    private Label nameLabel;
    private final CatalogViewer viewer;
    private StyledText installInfoLink;
    protected final IMarketplaceWebBrowser browser;
    private StyledText tagsLink;
    private static Boolean browserAvailable;

    public AbstractMarketplaceDiscoveryItem(Composite parent, int style, MarketplaceDiscoveryResources resources, IMarketplaceWebBrowser browser, T connector, CatalogViewer viewer) {
        super(parent, style, (DiscoveryResources)resources, connector);
        this.browser = browser;
        this.connector = connector;
        this.viewer = viewer;
        this.createContent();
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = AbstractMarketplaceDiscoveryItem.this.getNameLabelText();
            }
        });
    }

    protected void createContent() {
        this.createContent((Composite)this);
        this.createSeparator((Composite)this);
    }

    protected boolean alignIconWithName() {
        return false;
    }

    protected void createContent(Composite parent) {
        GridLayoutFactory.swtDefaults().numColumns(4).equalWidth(false).extendedMargins(0, 0, 2, 0).spacing(0, 0).applyTo((Composite)this);
        if (this.alignIconWithName()) {
            this.createIconContainer(parent);
        } else {
            new Label(parent, 0).setText(" ");
        }
        this.createNameLabel(parent);
        if (!this.alignIconWithName()) {
            this.createIconContainer(parent);
        }
        this.createIconControl(this.checkboxContainer);
        this.createDescription(parent);
        this.createProviderLabel(parent);
        this.createTagsLabel(parent);
        this.createSocialButtons(parent);
        this.createInstallInfo(parent);
        this.createInstallButtons(parent);
    }

    private void createIconContainer(Composite parent) {
        this.checkboxContainer = new Composite(parent, 0);
        GridDataFactory.swtDefaults().indent(0, 8).align(0x1000000, 1).hint(75, -1).grab(false, true).minSize(75, 64).span(1, this.alignIconWithName() ? 4 : 3).applyTo((Control)this.checkboxContainer);
    }

    protected void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridDataFactory.fillDefaults().indent(0, 8).grab(true, false).span(4, 1).align(4, 1).applyTo((Control)separator);
    }

    static void setWidgetId(Widget widget, String id) {
        widget.setData(WIDGET_ID_KEY, (Object)id);
    }

    protected void createDescription(Composite parent) {
        boolean truncated;
        this.description = StyledTextHelper.createStyledTextLabel(parent);
        AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)this.description, "description");
        GridDataFactory.fillDefaults().grab(true, false).indent(8, 8).span(3, 1).hint(100, -1).applyTo((Control)this.description);
        String descriptionText = this.connector.getDescription();
        int maxDescriptionLength = 162;
        descriptionText = descriptionText == null ? "" : TextUtil.stripHtmlMarkup((String)descriptionText).trim();
        descriptionText = descriptionText.replaceAll("(\\r\\n)|\\n|\\r|\\s{2,}", " ");
        String promotionLabel = null;
        if (descriptionText.startsWith(Messages.DiscoveryItem_Promotion_Marker)) {
            promotionLabel = Messages.DiscoveryItem_Promotion_Display;
            descriptionText = String.valueOf(promotionLabel) + "  - " + descriptionText.substring(Messages.DiscoveryItem_Promotion_Marker.length());
            maxDescriptionLength += promotionLabel.length() + 3;
        }
        if (truncated = descriptionText.endsWith("...")) {
            descriptionText = descriptionText.substring(0, descriptionText.length() - 3).trim();
        }
        if (descriptionText.length() > maxDescriptionLength) {
            int truncationIndex;
            int x = truncationIndex = maxDescriptionLength;
            while (x > 0) {
                if (Character.isWhitespace(descriptionText.charAt(x))) {
                    truncationIndex = x;
                    break;
                }
                --x;
            }
            descriptionText = String.valueOf(descriptionText.substring(0, truncationIndex)) + Messages.DiscoveryItem_truncatedTextSuffix;
            truncated = true;
        }
        if (truncated && !descriptionText.endsWith(Messages.DiscoveryItem_truncatedTextSuffix)) {
            descriptionText = String.valueOf(descriptionText) + Messages.DiscoveryItem_truncatedTextSuffix;
        }
        this.description.setText(String.valueOf(descriptionText) + "  ");
        if (promotionLabel != null) {
            StyleRange style = new StyleRange(0, promotionLabel.length(), null, null, 3);
            this.description.setStyleRange(style);
        }
        this.createInfoLink(this.description);
    }

    protected void createNameLabel(Composite parent) {
        this.nameLabel = new Label(parent, 64);
        AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)this.nameLabel, WIDGET_ID_NAME);
        GridDataFactory.fillDefaults().indent(8, 0).span(3, 1).grab(true, false).align(1, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.resources.getSmallHeaderFont());
        this.nameLabel.setText(this.getNameLabelText());
    }

    protected String getNameLabelText() {
        String name = this.connector.getName();
        if (name == null || "".equals(name.trim())) {
            name = NLS.bind((String)Messages.DiscoveryItem_UnnamedSolution, (Object)this.connector.getId());
        }
        return TextUtil.escapeText((String)name);
    }

    protected abstract void createInstallButtons(Composite var1);

    protected abstract void createInstallInfo(Composite var1);

    protected abstract void createSocialButtons(Composite var1);

    private INode getCatalogItemNode() {
        Object data = this.connector.getData();
        if (data instanceof INode) {
            INode node = (INode)data;
            return node;
        }
        return null;
    }

    private void createInfoLink(StyledText description) {
        boolean internalBrowserAvailable = this.computeBrowserAvailable((Composite)description);
        if (internalBrowserAvailable && (this.hasTooltip(this.connector) || this.connector.isInstalled())) {
            if (this.hasTooltip(this.connector)) {
                String descriptionLink = Messages.DiscoveryItem_More_Info;
                StyledTextHelper.appendLink(description, descriptionLink, INFO_HREF, 1);
                this.hookTooltip((Control)description.getParent(), (Widget)description, (Control)description, (Control)description, this.connector.getSource(), this.connector.getOverview(), null);
            }
        } else if (!internalBrowserAvailable && this.hasOverviewUrl(this.connector)) {
            String descriptionLink = Messages.DiscoveryItem_More_Info;
            StyledTextHelper.appendLink(description, descriptionLink, INFO_HREF, 1);
            new LinkListener(){

                protected void selected(Object href, TypedEvent e) {
                    if (AbstractMarketplaceDiscoveryItem.INFO_HREF.equals(href)) {
                        WorkbenchUtil.openUrl((String)AbstractMarketplaceDiscoveryItem.this.connector.getOverview().getUrl().trim(), (int)128);
                    }
                }
            }.register(description);
        }
    }

    protected void createIconControl(Composite checkboxContainer) {
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(checkboxContainer);
        this.iconLabel = new Label(checkboxContainer, 0);
        AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)this.iconLabel, "description");
        GridDataFactory.swtDefaults().align(0x1000000, 1).grab(true, true).applyTo((Control)this.iconLabel);
        if (this.connector.getIcon() != null) {
            this.provideIconImage(this.iconLabel, this.connector.getSource(), this.connector.getIcon(), 64, true);
        } else {
            this.iconLabel.setImage(MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NO_ICON_PROVIDED"));
        }
    }

    private void provideIconImage(final Label iconLabel, AbstractCatalogSource source, Icon icon, int size, boolean fallback) {
        if (iconLabel == null) {
            return;
        }
        String iconPath = this.getResources().getIconPath(icon, size, fallback);
        this.getResources().setImage(new MarketplaceDiscoveryResources.ImageReceiver(){

            public void setImage(Image image) {
                if (image == null || image.isDisposed() || iconLabel.isDisposed()) {
                    return;
                }
                try {
                    Rectangle bounds = image.getBounds();
                    if ((double)bounds.width < 60.0 || bounds.width > 75 || bounds.height > 86) {
                        Image scaledImage;
                        image = scaledImage = Util.scaleImage(image, 75, 86);
                        iconLabel.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                scaledImage.dispose();
                            }
                        });
                    }
                    iconLabel.setImage(image);
                }
                catch (SWTException sWTException) {}
            }
        }, source, iconPath, MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NO_ICON_PROVIDED"));
    }

    public MarketplaceDiscoveryResources getResources() {
        return (MarketplaceDiscoveryResources)this.resources;
    }

    private boolean hasOverviewUrl(CatalogItem connector) {
        return connector.getOverview() != null && connector.getOverview().getUrl() != null && connector.getOverview().getUrl().trim().length() > 0;
    }

    private synchronized boolean computeBrowserAvailable(Composite composite) {
        if (browserAvailable == null) {
            try {
                Browser browser = new Browser(composite, 0);
                browser.dispose();
                browserAvailable = true;
            }
            catch (SWTError sWTError) {
                browserAvailable = false;
            }
        }
        return browserAvailable;
    }

    protected void createProviderLabel(Composite parent) {
        StyledText providerLink = StyledTextHelper.createStyledTextLabel(parent);
        AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)providerLink, WIDGET_ID_PROVIDER);
        providerLink.setEditable(false);
        GridDataFactory.fillDefaults().indent(8, 8).span(3, 1).align(1, 0x1000000).grab(true, false).applyTo((Control)providerLink);
        providerLink.setForeground(this.resources.getColorDisabled());
        providerLink.setText(NLS.bind((String)Messages.DiscoveryItem_byProviderLicense, (Object)PROVIDER_PLACEHOLDER, (Object)this.connector.getLicense()));
        int providerPos = providerLink.getText().indexOf(PROVIDER_PLACEHOLDER);
        if (providerPos != -1) {
            String providerName = this.connector.getProvider();
            StyleRange range = new StyleRange(0, 0, providerLink.getForeground(), null, 0);
            if (providerName == null) {
                providerName = Messages.DiscoveryItem_UnknownProvider;
                range.fontStyle |= 2;
            } else {
                range.underline = true;
                range.underlineStyle = 4;
                LinkListener listener = new LinkListener(){

                    protected void selected(Object href, TypedEvent e) {
                        String searchTerm = href.toString();
                        if (searchTerm.contains(" ")) {
                            searchTerm = "\"" + searchTerm + "\"";
                        }
                        AbstractMarketplaceDiscoveryItem.this.searchForProvider(searchTerm);
                    }
                };
                listener.register(providerLink);
            }
            range.start = providerPos;
            range.length = providerName.length();
            range.data = providerName;
            providerLink.replaceTextRange(providerPos, PROVIDER_PLACEHOLDER.length(), providerName);
            providerLink.replaceStyleRanges(providerPos, range.length, new StyleRange[]{range});
        }
    }

    protected abstract void searchForProvider(String var1);

    protected void createTagsLabel(Composite parent) {
        this.tagsLink = StyledTextHelper.createStyledTextLabel(parent);
        AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)this.tagsLink, WIDGET_ID_TAGS);
        this.tagsLink.setEditable(false);
        GridDataFactory.fillDefaults().indent(8, 2).span(3, 1).align(1, 1).grab(true, false).applyTo((Control)this.tagsLink);
        ITags tagsObject = this.getCatalogItemNode().getTags();
        if (tagsObject == null) {
            return;
        }
        ArrayList tags = tagsObject.getTags();
        if (tags.isEmpty()) {
            return;
        }
        tags = new ArrayList(tags);
        Collections.sort(tags, new Comparator<ITag>(){

            @Override
            public int compare(ITag o1, ITag o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1.getName().startsWith(AbstractMarketplaceDiscoveryItem.FILE_EXTENSION_TAG_PREFIX)) {
                    if (o2.getName().startsWith(AbstractMarketplaceDiscoveryItem.FILE_EXTENSION_TAG_PREFIX)) {
                        return 0;
                    }
                    return 1;
                }
                if (o2.getName().startsWith(AbstractMarketplaceDiscoveryItem.FILE_EXTENSION_TAG_PREFIX)) {
                    return -1;
                }
                return 0;
            }
        });
        boolean needsEllipsis = tags.size() > 5;
        int i = 0;
        while (i < 5 && i < tags.size()) {
            if (i > 0) {
                this.tagsLink.append(" ");
            }
            ITag tag = (ITag)tags.get(i);
            String tagName = tag.getName();
            StyledTextHelper.appendLink(this.tagsLink, tagName, tagName, 0);
            ++i;
        }
        if (needsEllipsis) {
            this.tagsLink.append(" ");
            StyledTextHelper.appendLink(this.tagsLink, ELLIPSIS, ELLIPSIS, 0);
            this.createTagsTooltip(this.tagsLink, tags);
        }
        new LinkListener(){

            protected void selected(Object href, TypedEvent e) {
                if (href == ELLIPSIS) {
                    Object data = e.widget.getData();
                    if (data instanceof ToolTip) {
                        ToolTip tooltip = (ToolTip)data;
                        tooltip.show(new Point(0, 0));
                    }
                } else if (href != null) {
                    AbstractMarketplaceDiscoveryItem.this.searchForTag(href.toString());
                }
            }
        }.register(this.tagsLink);
    }

    private void createTagsTooltip(final StyledText tagsLink, final List<? extends ITag> tags) {
        ToolTip tooltip = new ToolTip((Control)tagsLink, 2, false){

            protected Composite createToolTipContentArea(Event event, Composite parent) {
                Composite result = new Composite(parent, 0);
                result.setBackground(parent.getDisplay().getSystemColor(29));
                result.setLayout((Layout)new GridLayout());
                StyledText fullTagLinks = StyledTextHelper.createStyledTextLabel(result);
                fullTagLinks.setBackground(parent.getDisplay().getSystemColor(29));
                fullTagLinks.setForeground(parent.getDisplay().getSystemColor(28));
                int i = 0;
                while (i < 30 && i < tags.size()) {
                    ITag tag = (ITag)tags.get(i);
                    String tagName = tag.getName();
                    StyledTextHelper.appendLink(fullTagLinks, tagName, tagName, 0);
                    fullTagLinks.append(" ");
                    ++i;
                }
                if (tags.size() > 30) {
                    fullTagLinks.append(ELLIPSIS);
                }
                new LinkListener(){

                    protected void selected(Object href, TypedEvent e) {
                        this.hide();
                        if (href != null) {
                            AbstractMarketplaceDiscoveryItem.this.searchForTag(href.toString());
                        }
                    }
                }.register(fullTagLinks);
                GridData gridData = new GridData();
                gridData.widthHint = tagsLink.getSize().x;
                fullTagLinks.setLayoutData((Object)gridData);
                Dialog.applyDialogFont((Control)result);
                return result;
            }

            public Point getLocation(Point tipSize, Event event) {
                Point size = tagsLink.getSize();
                return tagsLink.toDisplay(0, size.y);
            }
        };
        tagsLink.setData((Object)tooltip);
        tooltip.setHideOnMouseDown(false);
        tooltip.setPopupDelay(0);
        tooltip.activate();
    }

    protected abstract void searchForTag(String var1);

    protected boolean hasTooltip(CatalogItem connector) {
        return connector.getOverview() != null && connector.getOverview().getSummary() != null && connector.getOverview().getSummary().length() > 0;
    }

    public boolean isSelected() {
        return ((CatalogItem)this.getData()).isSelected();
    }

    protected void refresh() {
        Color foreground = this.getForeground();
        this.nameLabel.setForeground(foreground);
        this.description.setForeground(foreground);
        if (this.installInfoLink != null) {
            this.installInfoLink.setForeground(foreground);
        }
    }

    private void hookRecursively(Control control, Listener listener) {
        control.addListener(12, listener);
        control.addListener(32, listener);
        control.addListener(5, listener);
        control.addListener(7, listener);
        control.addListener(3, listener);
        control.addListener(37, listener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookRecursively(child, listener);
                ++n2;
            }
        }
    }

    protected void hookTooltip(Control parent, Widget tipActivator, Control exitControl, final Control titleControl, AbstractCatalogSource source, Overview overview, Image image) {
        final OverviewToolTip toolTip = new OverviewToolTip(parent, this.browser, (MarketplaceCatalogSource)source, overview, image);
        this.hookTooltip(toolTip, tipActivator, exitControl);
        if (image != null) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    toolTip.show(titleControl);
                }
            };
            tipActivator.addListener(32, listener);
        }
        if (tipActivator instanceof StyledText) {
            StyledText link = (StyledText)tipActivator;
            new LinkListener(){

                protected void selected(Object href, TypedEvent e) {
                    if (AbstractMarketplaceDiscoveryItem.INFO_HREF.equals(href)) {
                        toolTip.show(titleControl);
                    }
                }
            }.register(link);
        } else {
            Listener selectionListener = new Listener(){

                public void handleEvent(Event event) {
                    toolTip.show(titleControl);
                }
            };
            tipActivator.addListener(13, selectionListener);
        }
    }

    protected void hookTooltip(final ToolTip toolTip, Widget tipActivator, final Control exitControl) {
        if (toolTip == null) {
            return;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                toolTip.hide();
            }
        };
        tipActivator.addListener(12, listener);
        tipActivator.addListener(37, listener);
        Listener exitListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        toolTip.hide();
                        break;
                    }
                    case 7: {
                        Rectangle tipBounds;
                        Shell tipShell;
                        Rectangle containerBounds = exitControl.getBounds();
                        Point displayLocation = exitControl.getParent().toDisplay(containerBounds.x, containerBounds.y);
                        containerBounds.x = displayLocation.x;
                        containerBounds.y = displayLocation.y;
                        containerBounds.height += 3;
                        Point cursorLocation = Display.getCurrent().getCursorLocation();
                        if (containerBounds.contains(cursorLocation) || (tipShell = (Shell)toolTip.getData(Shell.class.getName())) != null && !tipShell.isDisposed() && (tipBounds = tipShell.getBounds()).contains(cursorLocation)) break;
                        toolTip.hide();
                    }
                }
            }
        };
        this.hookRecursively(exitControl, exitListener);
    }

    protected CatalogViewer getViewer() {
        return this.viewer;
    }
}

