/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.model.internal;

import com.liferay.ide.layouttpl.core.model.CanAddPortletLayouts;
import com.liferay.ide.layouttpl.core.model.LayoutTplElement;
import com.liferay.ide.layouttpl.core.model.PortletColumnElement;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;

public class PortletColumnsListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        LayoutTplElement layouttpl = (LayoutTplElement)event.property().element().nearest(LayoutTplElement.class);
        this.updateColumns(layouttpl, 1);
    }

    protected int updateColumns(CanAddPortletLayouts columnsParent, int numId) {
        for (PortletLayoutElement portletLayout : columnsParent.getPortletLayouts()) {
            ElementList<PortletColumnElement> columns = portletLayout.getPortletColumns();
            int size = columns.size();
            int i = 0;
            while (i < size) {
                PortletColumnElement column = (PortletColumnElement)columns.get(i);
                if (column.getPortletLayouts().size() == 0) {
                    column.setNumId(String.valueOf(numId++));
                } else if (column.getPortletLayouts().size() > 0) {
                    column.setNumId("N/A");
                    numId = this.updateColumns(column, numId++);
                }
                column.setOnly(false);
                column.setFirst(false);
                column.setLast(false);
                column.setColumnDescriptor("");
                column.setColumnContentDescriptor("");
                if (size == 1) {
                    column.setOnly(true);
                    column.setColumnDescriptor("portlet-column-only");
                    column.setColumnContentDescriptor("portlet-column-content-only");
                } else if (size > 1) {
                    if (i == 0) {
                        column.setFirst(true);
                        column.setColumnDescriptor("portlet-column-first");
                        column.setColumnContentDescriptor("portlet-column-content-first");
                    } else if (i == size - 1) {
                        column.setLast(true);
                        column.setColumnDescriptor("portlet-column-last");
                        column.setColumnContentDescriptor("portlet-column-content-last");
                    }
                }
                ++i;
            }
        }
        return numId;
    }
}

