/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.LaunchHelper;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.project.core.AbstractProjectBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.osgi.util.NLS;

public class MavenProjectBuilder
extends AbstractProjectBuilder {
    private final String ATTR_GOALS = "M2_GOALS";
    private final String ATTR_POM_DIR = IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY;
    private final String ATTR_PROFILES = "M2_PROFILES";
    private final String ATTR_SKIP_TESTS = "M2_SKIP_TESTS";
    private final String ATTR_WORKSPACE_RESOLUTION = "M2_WORKSPACE_RESOLUTION";
    private final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.m2e.Maven2LaunchConfigurationType";
    protected final IMaven maven = MavenPlugin.getMaven();
    protected final IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();

    public MavenProjectBuilder(IProject project) {
        super(project);
    }

    public IStatus buildLang(IFile langFile, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        sub.beginTask(Msgs.buildingLanguages, 100);
        final IMavenProjectFacade facade = MavenUtil.getProjectFacade(this.getProject(), (IProgressMonitor)sub);
        sub.worked(10);
        ICallable<IStatus> callable = new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return MavenUtil.executeMojoGoal(facade, context, "liferay:build-lang", monitor);
            }
        };
        IStatus retval = this.executeMaven(facade, callable, (IProgressMonitor)sub);
        sub.worked(80);
        this.getProject().refreshLocal(2, (IProgressMonitor)sub);
        sub.worked(10);
        sub.done();
        return retval;
    }

    public IStatus buildSB(IFile serviceXmlFile, String goal, IProgressMonitor monitor) throws CoreException {
        IProject serviceProject = serviceXmlFile.getProject();
        IMavenProjectFacade facade = MavenUtil.getProjectFacade(serviceProject, monitor);
        monitor.worked(10);
        Object retval = null;
        retval = this.runMavenGoal(serviceProject, goal, monitor) ? Status.OK_STATUS : LiferayMavenCore.createErrorStatus("run build-service error");
        this.refreshSiblingProject(facade, monitor);
        serviceProject.refreshLocal(2, monitor);
        monitor.worked(10);
        monitor.done();
        return retval;
    }

    public IStatus buildService(IProgressMonitor monitor) throws CoreException {
        IFile serviceFile = this.preBuildService(monitor);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        sub.beginTask(Msgs.buildingServices, 100);
        return this.buildSB(serviceFile, "liferay:build-service", (IProgressMonitor)sub);
    }

    public IStatus buildWSDD(IProgressMonitor monitor) throws CoreException {
        IFile serviceFile = this.preBuildService(monitor);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        sub.beginTask(Msgs.buildingServices, 100);
        return this.buildSB(serviceFile, "liferay:build-wsdd", (IProgressMonitor)sub);
    }

    public IStatus execGoals(final List<String> goals, IProgressMonitor monitor) throws CoreException {
        IStatus retval = null;
        final IMavenProjectFacade facade = MavenUtil.getProjectFacade(this.getProject(), monitor);
        ICallable<IStatus> callable = new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                IStatus execStatus = MavenUtil.executeGoals(facade, context, goals, monitor);
                List exceptions = context.getSession().getResult().getExceptions();
                return LiferayMavenCore.newMultiStatus().add(execStatus).addAll(exceptions).retval();
            }
        };
        retval = this.executeMaven(facade, callable, monitor);
        return retval;
    }

    public IStatus execJarMojo(final IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        IStatus retval = null;
        ICallable<IStatus> callable = new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                MavenProject mavenProject = projectFacade.getMavenProject();
                if (mavenProject == null) {
                    mavenProject = projectFacade.getMavenProject(monitor);
                }
                IMaven maven = MavenPlugin.getMaven();
                MavenExecutionPlan plan = maven.calculateExecutionPlan(mavenProject, Arrays.asList("jar:jar"), true, monitor);
                List mojoExecutions = plan.getMojoExecutions();
                if (mojoExecutions != null) {
                    for (MojoExecution mojoExecution : mojoExecutions) {
                        MavenPlugin.getMaven().execute(mavenProject, mojoExecution, monitor);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        retval = this.executeMaven(projectFacade, callable, monitor);
        return retval;
    }

    private boolean execMavenLaunch(IProject project, String goal, IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
        IPath basedirLocation = project.getLocation();
        String newName = launchManager.generateLaunchConfigurationName(basedirLocation.lastSegment());
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, newName);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-Dmaven.multiModuleProjectDirectory");
        workingCopy.setAttribute(this.ATTR_POM_DIR, basedirLocation.toString());
        workingCopy.setAttribute("M2_GOALS", goal);
        workingCopy.setAttribute("M2_WORKSPACE_RESOLUTION", true);
        workingCopy.setAttribute("M2_SKIP_TESTS", true);
        if (facade != null) {
            ResolverConfiguration configuration = facade.getResolverConfiguration();
            String selectedProfiles = configuration.getSelectedProfiles();
            if (selectedProfiles != null && selectedProfiles.length() > 0) {
                workingCopy.setAttribute("M2_PROFILES", selectedProfiles);
            }
            new LaunchHelper().launch((ILaunchConfiguration)workingCopy, "run", monitor);
            return true;
        }
        return false;
    }

    protected IStatus executeMaven(final IMavenProjectFacade projectFacade, final ICallable<IStatus> callable, IProgressMonitor monitor) throws CoreException {
        return (IStatus)this.maven.execute((ICallable)new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return (IStatus)MavenProjectBuilder.this.projectManager.execute(projectFacade, callable, monitor);
            }
        }, monitor);
    }

    public IProject getPortletProject(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        IProject retVal = null;
        try {
            Xpp3Dom config = MavenUtil.getLiferayMavenPluginConfig(projectFacade.getMavenProject());
            Xpp3Dom webAppDir = config.getChild("webappBaseDir");
            Xpp3Dom pluginName = config.getChild("pluginName");
            if (webAppDir != null) {
                String webAppDirValue = webAppDir.getValue();
                String projectPath = Path.fromOSString((String)webAppDirValue).lastSegment();
                retVal = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath);
            } else if (pluginName != null) {
                String pluginNameValue = pluginName.getValue();
                retVal = CoreUtil.getProject((String)pluginNameValue);
            }
        }
        catch (Exception e) {
            LiferayMavenCore.logError("Could not refresh sibling service project.", e);
        }
        return retVal;
    }

    public IFile preBuildService(IProgressMonitor monitor) throws CoreException {
        IProject portletProject;
        IMavenProjectFacade projectFacade;
        IProject project = this.getProject();
        IFile retval = this.getDocrootFile("WEB-INF/service.xml");
        if (retval == null && (projectFacade = MavenUtil.getProjectFacade(project)) != null && (portletProject = this.getPortletProject(projectFacade, monitor)) != null) {
            retval = new MavenProjectBuilder(portletProject).getDocrootFile("WEB-INF/service.xml");
        }
        if (retval == null) {
            retval = project.getFile("service.xml");
        }
        return retval;
    }

    public void refreshSiblingProject(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        try {
            Plugin plugin6x = MavenUtil.getPlugin(projectFacade, "com.liferay.maven.plugins:liferay-maven-plugin", monitor);
            if (plugin6x != null) {
                Xpp3Dom config = (Xpp3Dom)plugin6x.getConfiguration();
                Xpp3Dom apiBaseDir = config.getChild("apiBaseDir");
                String apiBaseDirValue = apiBaseDir.getValue();
                IFile apiBasePomFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(new Path(apiBaseDirValue).append("pom.xml"));
                IMavenProjectFacade apiBaseFacade = this.projectManager.create(apiBasePomFile, true, monitor);
                apiBaseFacade.getProject().refreshLocal(2, monitor);
            } else {
                int endIndex;
                int startIndex;
                Xpp3Dom config;
                Xpp3Dom apiDirName;
                String apiDirNameValue;
                String projectName;
                IProject project;
                Plugin plugin7x = MavenUtil.getPlugin(projectFacade, "com.liferay:com.liferay.portal.tools.service.builder", monitor);
                if (plugin7x != null && (project = CoreUtil.getProject((String)(projectName = (apiDirNameValue = (apiDirName = (config = (Xpp3Dom)plugin7x.getConfiguration()).getChild("apiDirName")).getValue()).substring((startIndex = apiDirNameValue.indexOf("../")) + 3, endIndex = apiDirNameValue.indexOf("/src/main/java"))))) != null) {
                    project.refreshLocal(2, monitor);
                }
            }
        }
        catch (Exception e) {
            LiferayMavenCore.logError("Could not refresh sibling service project.", e);
        }
    }

    public boolean runMavenGoal(IProject project, String goal, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = MavenUtil.getProjectFacade(project, monitor);
        return this.execMavenLaunch(project, goal, facade, monitor);
    }

    public IStatus execInitBundle(IProject project, String taskName, String bundleUrl, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = MavenUtil.getProjectFacade(project, monitor);
        if (this.execMavenLaunch(project, "liferay:init-bundle", facade, monitor)) {
            return Status.OK_STATUS;
        }
        return LiferayMavenCore.createErrorStatus("run init-bundle error");
    }

    /*
     * WARNING - void declaration
     */
    public IStatus updateProjectDependency(final IProject project, List<String[]> dependencies) throws CoreException {
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(project, (IProgressMonitor)new NullProgressMonitor());
        if (projectFacade != null) {
            MavenProject mavenProject = projectFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
            List existedDependencies = mavenProject.getDependencies();
            IMaven maven = MavenPlugin.getMaven();
            File pomFile = new File(project.getLocation().toOSString(), "pom.xml");
            Model model = maven.readModel(pomFile);
            for (String[] stringArray : dependencies) {
                Dependency de = new Dependency();
                de.setGroupId(stringArray[0]);
                de.setArtifactId(stringArray[1]);
                de.setVersion(stringArray[2]);
                String newKey = de.getManagementKey();
                boolean existed = false;
                for (Dependency existedDependency : existedDependencies) {
                    String existedKey = existedDependency.getManagementKey();
                    if (!existedKey.equals(newKey)) continue;
                    existed = true;
                    break;
                }
                if (existed || model == null) continue;
                model.addDependency(de);
            }
            try {
                Throwable throwable = null;
                Iterator<String[]> iterator = null;
                try (FileOutputStream out = new FileOutputStream(pomFile);){
                    maven.writeModel(model, (OutputStream)out);
                    out.flush();
                    out.close();
                    WorkspaceJob job = new WorkspaceJob("Updating project " + project.getName()){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            try {
                                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                MavenPlugin.getProjectConfigurationManager().updateProjectConfiguration(project, monitor);
                            }
                            catch (CoreException ex) {
                                return ex.getStatus();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                catch (Throwable throwable2) {
                    void var9_15;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw var9_15;
                }
            }
            catch (Exception exception) {
                return LiferayMavenCore.createErrorStatus("Error updating maven project dependency", exception);
            }
        }
        return Status.OK_STATUS;
    }

    protected static class Msgs
    extends NLS {
        public static String buildingLanguages;
        public static String buildingServices;
        public static String buildingWSDD;

        static {
            Msgs.initializeMessages((String)MavenProjectBuilder.class.getName(), Msgs.class);
        }

        protected Msgs() {
        }
    }
}

