/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProjectProvider;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import com.liferay.ide.project.core.modules.PropertyKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class NewMavenModuleProjectProvider
extends LiferayMavenProjectProvider
implements NewLiferayProjectProvider<NewLiferayModuleProjectOp> {
    public IStatus createNewProject(NewLiferayModuleProjectOp op, IProgressMonitor monitor) throws CoreException {
        Status retval = null;
        IProjectConfigurationManager projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        String groupId = (String)op.getGroupId().content();
        String artifactId = (String)op.getProjectName().content();
        String version = (String)op.getArtifactVersion().content();
        String javaPackage = (String)op.getPackageName().content();
        String className = (String)op.getComponentName().content();
        String serviceName = (String)op.getServiceName().content();
        String archetypeArtifactId = (String)op.getArchetype().content();
        Archetype archetype = new Archetype();
        String[] gav = archetypeArtifactId.split(":");
        String archetypeVersion = gav[gav.length - 1];
        archetype.setGroupId(gav[0]);
        archetype.setArtifactId(gav[1]);
        archetype.setVersion(archetypeVersion);
        Properties properties = new Properties();
        if (archetype.getArtifactId().endsWith("service.builder")) {
            String apiPath = ":" + artifactId + "-api";
            properties.put("apiPath", apiPath);
        }
        properties.put("buildType", "maven");
        properties.put("package", javaPackage);
        properties.put("className", className == null ? "" : className);
        properties.put("projectType", "standalone");
        properties.put("serviceClass", serviceName == null ? "" : serviceName);
        properties.put("serviceWrapperClass", serviceName == null ? "" : serviceName);
        properties.put("contributorType", artifactId);
        properties.put("author", "liferay");
        for (PropertyKey propertyKey : op.getPropertyKeys()) {
            String key = (String)propertyKey.getName().content();
            String value = (String)propertyKey.getValue().content();
            properties.put(key, value);
        }
        if (serviceName != null) {
            properties.put("service", serviceName);
        }
        ResolverConfiguration resolverConfig = new ResolverConfiguration();
        ProjectImportConfiguration configuration = new ProjectImportConfiguration(resolverConfig);
        List newProjects = projectConfigurationManager.createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, configuration, monitor);
        ElementList projectNames = op.getProjectNames();
        if (newProjects == null || newProjects.size() == 0) {
            retval = LiferayMavenCore.createErrorStatus("Unable to create project from archetype.");
        } else {
            for (IProject newProject : newProjects) {
                String[] gradleFiles;
                ((ProjectName)projectNames.insert()).setName(newProject.getName());
                String[] stringArray = gradleFiles = new String[]{"build.gradle", "settings.gradle"};
                int n = gradleFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    IFile gradleFile = newProject.getFile(path);
                    if (gradleFile.exists()) {
                        gradleFile.delete(true, monitor);
                    }
                    ++n2;
                }
            }
            retval = Status.OK_STATUS;
        }
        return retval;
    }

    @Override
    public <T> List<T> getData(String key, Class<T> type, Object ... params) {
        if ("archetypeGAV".equals(key) && type.equals(String.class) && params.length == 1) {
            ArrayList<T> retval = new ArrayList<T>();
            String templateName = params[0].toString();
            String gav = LiferayMavenCore.getPreferenceString("archetype-project-template-" + templateName, "");
            if (CoreUtil.empty((String)gav)) {
                gav = "com.liferay:com.liferay.project.templates." + templateName.replace("-", ".") + ":1.0.0";
            }
            retval.add(type.cast(gav));
            return retval;
        }
        return super.getData(key, type, params);
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        return Status.OK_STATUS;
    }
}

