/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.ui.editor.MessageKeyHyperlink;
import com.liferay.ide.portlet.ui.util.MessageKey;
import com.liferay.ide.portlet.ui.util.NodeUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.w3c.dom.Node;

public class MessageKeyHyperlinkDetector
extends AbstractHyperlinkDetector {
    private long lastModStamp;
    private IFile lastFile;
    private IRegion lastNodeRegion;
    private MessageKey[] lastMessageKeys;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int offset;
        IDocument document;
        IDOMNode currentNode;
        Node keyNode;
        IHyperlink[] retval = null;
        if (this.shouldDetectHyperlinks(textViewer, region) && (keyNode = NodeUtils.getMessageKey(currentNode = DOMUtils.getNodeByOffset((IDocument)(document = textViewer.getDocument()), (int)(offset = region.getOffset())))) != null) {
            Region nodeRegion = new Region(currentNode.getStartOffset(), currentNode.getEndOffset() - currentNode.getStartOffset());
            long modStamp = ((IDocumentExtension4)document).getModificationStamp();
            IFile file = DOMUtils.getFile((IDocument)document);
            Object[] messageKeys = null;
            if (file.equals((Object)this.lastFile) && modStamp == this.lastModStamp && nodeRegion.equals(this.lastNodeRegion)) {
                messageKeys = this.lastMessageKeys;
            } else {
                String key = keyNode.getNodeValue();
                messageKeys = NodeUtils.findMessageKeys(document, key, false);
                this.lastModStamp = modStamp;
                this.lastFile = file;
                this.lastNodeRegion = nodeRegion;
                this.lastMessageKeys = messageKeys;
            }
            if (!CoreUtil.isNullOrEmpty((Object[])messageKeys)) {
                ArrayList<MessageKeyHyperlink> links = new ArrayList<MessageKeyHyperlink>();
                Object[] objectArray = messageKeys;
                int n = messageKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object messageKey = objectArray[n2];
                    links.add(new MessageKeyHyperlink((IRegion)nodeRegion, ((MessageKey)messageKey).file, ((MessageKey)messageKey).key, ((MessageKey)messageKey).offset, ((MessageKey)messageKey).length));
                    ++n2;
                }
                if (links.size() != 0) {
                    retval = canShowMultipleHyperlinks ? links.toArray(new IHyperlink[0]) : new IHyperlink[]{(IHyperlink)links.get(0)};
                }
            }
        }
        return retval;
    }

    private boolean shouldDetectHyperlinks(ITextViewer textViewer, IRegion region) {
        return region != null && textViewer != null;
    }
}

