/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.sdk.core.ISDKListener;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.server.core.AbstractPluginPublisher;
import com.liferay.ide.server.core.AbstractRuntimeDelegateValidator;
import com.liferay.ide.server.core.ILiferayRuntimeStub;
import com.liferay.ide.server.core.IPluginPublisher;
import com.liferay.ide.server.core.IRuntimeDelegateValidator;
import com.liferay.ide.server.core.LiferayRuntimeStub;
import com.liferay.ide.server.core.PortalLaunchParticipant;
import com.liferay.ide.server.core.portal.AbstractPortalBundleFactory;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.core.portal.PortalBundleFactory;
import com.liferay.ide.server.remote.IRemoteServer;
import com.liferay.ide.server.remote.IServerManagerConnection;
import com.liferay.ide.server.remote.ServerManagerConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Base;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class LiferayServerCore
extends Plugin {
    public static final String BUNDLE_OUTPUT_ERROR_MARKER_TYPE = "com.liferay.ide.server.core.BundleOutputErrorMarker";
    private static Map<String, IServerManagerConnection> connections = null;
    private static LiferayServerCore plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.server.core";
    private static IPluginPublisher[] pluginPublishers;
    private static PortalBundleFactory[] portalBundleFactories;
    private static IRuntimeDelegateValidator[] runtimeDelegateValidators;
    private static ILiferayRuntimeStub[] runtimeStubs;
    private IRuntimeLifecycleListener runtimeLifecycleListener;
    private ISDKListener sdkListener;
    private IServerLifecycleListener serverLifecycleListener;

    static {
        pluginPublishers = null;
    }

    public static IStatus createErrorStatus(Exception e) {
        return LiferayServerCore.error(e.getMessage(), e);
    }

    public static IStatus createErrorStatus(String pluginId, String msg) {
        return new Status(4, pluginId, msg);
    }

    public static IStatus createErrorStatus(String pluginId, String msg, Throwable e) {
        return new Status(4, pluginId, msg, e);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, message);
    }

    public static IStatus createWarningStatus(String message, String id) {
        return new Status(2, id, message);
    }

    public static IStatus createWarningStatus(String message, String id, Exception e) {
        return new Status(2, id, message, (Throwable)e);
    }

    public static IStatus error(String msg) {
        return LiferayServerCore.createErrorStatus(PLUGIN_ID, msg);
    }

    public static IStatus error(String msg, Throwable t) {
        return new Status(4, PLUGIN_ID, msg, t);
    }

    public static LiferayServerCore getDefault() {
        return plugin;
    }

    public static URL getPluginEntry(String path) {
        return LiferayServerCore.getDefault().getBundle().getEntry(path);
    }

    public static IPluginPublisher getPluginPublisher(String facetId, String runtimeTypeId) {
        if (CoreUtil.isNullOrEmpty((String)facetId) || CoreUtil.isNullOrEmpty((String)runtimeTypeId)) {
            return null;
        }
        IPluginPublisher retval = null;
        IPluginPublisher[] publishers = LiferayServerCore.getPluginPublishers();
        if (publishers != null && publishers.length > 0) {
            IPluginPublisher[] iPluginPublisherArray = publishers;
            int n = publishers.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginPublisher publisher = iPluginPublisherArray[n2];
                if (publisher != null && facetId.equals(publisher.getFacetId()) && runtimeTypeId.equals(publisher.getRuntimeTypeId())) {
                    retval = publisher;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public static IPluginPublisher[] getPluginPublishers() {
        if (pluginPublishers == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.server.core.pluginPublishers");
            try {
                ArrayList<AbstractPluginPublisher> deployers = new ArrayList<AbstractPluginPublisher>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    if (o instanceof AbstractPluginPublisher) {
                        AbstractPluginPublisher pluginDeployer = (AbstractPluginPublisher)o;
                        pluginDeployer.setFacetId(element.getAttribute("facetId"));
                        pluginDeployer.setRuntimeTypeId(element.getAttribute("runtimeTypeId"));
                        deployers.add(pluginDeployer);
                    }
                    ++n2;
                }
                pluginPublishers = deployers.toArray(new IPluginPublisher[0]);
            }
            catch (Exception e) {
                LiferayServerCore.logError("Unable to get plugin deployer extensions", e);
            }
        }
        return pluginPublishers;
    }

    public static PortalBundle newPortalBundle(IPath bundlePath) {
        PortalBundleFactory[] factories = LiferayServerCore.getPortalBundleFactories();
        if (factories != null) {
            PortalBundleFactory[] portalBundleFactoryArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                PortalBundleFactory portalBundleFactory = portalBundleFactoryArray[n2];
                IPath path = portalBundleFactory.canCreateFromPath(bundlePath);
                if (path != null) {
                    return portalBundleFactory.create(path);
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isPortalBundlePath(IPath bundlePath) {
        PortalBundleFactory[] factories = LiferayServerCore.getPortalBundleFactories();
        if (factories != null) {
            PortalBundleFactory[] portalBundleFactoryArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                PortalBundleFactory portalBundleFactory = portalBundleFactoryArray[n2];
                IPath path = portalBundleFactory.canCreateFromPath(bundlePath);
                if (path != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static PortalBundleFactory[] getPortalBundleFactories() {
        if (portalBundleFactories == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.server.core.portalBundles");
            try {
                ArrayList<AbstractPortalBundleFactory> bundleFactories = new ArrayList<AbstractPortalBundleFactory>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    if (o instanceof PortalBundleFactory) {
                        AbstractPortalBundleFactory portalBundleFactory = (AbstractPortalBundleFactory)o;
                        portalBundleFactory.setBundleFactoryType(element.getAttribute("type"));
                        bundleFactories.add(portalBundleFactory);
                    }
                    ++n2;
                }
                portalBundleFactories = bundleFactories.toArray(new PortalBundleFactory[0]);
            }
            catch (Exception e) {
                LiferayServerCore.logError("Unable to get PortalBundleFactory extensions", e);
            }
        }
        return portalBundleFactories;
    }

    public static PortalBundleFactory getPortalBundleFactories(String type) {
        PortalBundleFactory[] factories = LiferayServerCore.getPortalBundleFactories();
        if (factories != null) {
            PortalBundleFactory[] portalBundleFactoryArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                PortalBundleFactory portalBundleFactory = portalBundleFactoryArray[n2];
                if (portalBundleFactory.getType().equals(type)) {
                    return portalBundleFactory;
                }
                ++n2;
            }
        }
        return null;
    }

    public static PortalLaunchParticipant[] getPortalLaunchParticipants() {
        PortalLaunchParticipant[] retval = null;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.server.core.portalLaunchParticipants");
        try {
            ArrayList<PortalLaunchParticipant> participants = new ArrayList<PortalLaunchParticipant>();
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object o = element.createExecutableExtension("class");
                if (o instanceof PortalLaunchParticipant) {
                    PortalLaunchParticipant participant = (PortalLaunchParticipant)o;
                    participants.add(participant);
                }
                ++n2;
            }
            retval = participants.toArray(new PortalLaunchParticipant[0]);
        }
        catch (Exception e) {
            LiferayServerCore.logError("Unable to get portal launch participants", e);
        }
        return retval;
    }

    public static URL getPortalSupportLibURL() {
        try {
            return FileLocator.toFileURL((URL)LiferayServerCore.getPluginEntry("/portal-support/portal-support.jar"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getPreference(String key) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).get(key, "");
    }

    public static IServerManagerConnection getRemoteConnection(IRemoteServer server) {
        IServerManagerConnection retval = null;
        if (connections == null) {
            connections = new HashMap<String, IServerManagerConnection>();
        }
        if (server != null) {
            IServerManagerConnection service = connections.get(server.getId());
            if (service == null) {
                service = new ServerManagerConnection();
                LiferayServerCore.updateConnectionSettings(server, service);
                connections.put(server.getId(), service);
            } else {
                LiferayServerCore.updateConnectionSettings(server, service);
            }
            retval = service;
        }
        return retval;
    }

    public static IRuntimeDelegateValidator[] getRuntimeDelegateValidators() {
        if (runtimeDelegateValidators == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.server.core.runtimeDelegateValidators");
            try {
                ArrayList<AbstractRuntimeDelegateValidator> validators = new ArrayList<AbstractRuntimeDelegateValidator>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    String runtimeTypeId = element.getAttribute("runtimeTypeId");
                    if (o instanceof AbstractRuntimeDelegateValidator) {
                        AbstractRuntimeDelegateValidator validator = (AbstractRuntimeDelegateValidator)o;
                        validator.setRuntimeTypeId(runtimeTypeId);
                        validators.add(validator);
                    }
                    ++n2;
                }
                runtimeDelegateValidators = validators.toArray(new IRuntimeDelegateValidator[0]);
            }
            catch (Exception e) {
                LiferayServerCore.logError("Unable to get IRuntimeDelegateValidator extensions", e);
            }
        }
        return runtimeDelegateValidators;
    }

    public static ILiferayRuntimeStub getRuntimeStub(String stubTypeId) {
        Object retval = null;
        Object[] stubs = LiferayServerCore.getRuntimeStubs();
        if (!CoreUtil.isNullOrEmpty((Object[])stubs)) {
            Object[] objectArray = stubs;
            int n = stubs.length;
            int n2 = 0;
            while (n2 < n) {
                Object stub = objectArray[n2];
                if (stub.getRuntimeStubTypeId().equals(stubTypeId)) {
                    retval = stub;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public static ILiferayRuntimeStub[] getRuntimeStubs() {
        Object[] elements;
        if (runtimeStubs == null && !CoreUtil.isNullOrEmpty((Object[])(elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.server.core.runtimeStubs")))) {
            ArrayList<LiferayRuntimeStub> stubs = new ArrayList<LiferayRuntimeStub>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String runtimeTypeId = element.getAttribute("runtimeTypeId");
                String name = element.getAttribute("name");
                boolean isDefault = Boolean.parseBoolean(element.getAttribute("default"));
                try {
                    LiferayRuntimeStub stub = new LiferayRuntimeStub();
                    stub.setRuntimeTypeId(runtimeTypeId);
                    stub.setName(name);
                    stub.setDefault(isDefault);
                    stubs.add(stub);
                }
                catch (Exception e) {
                    LiferayServerCore.logError("Could not create liferay runtime stub.", e);
                }
                ++n2;
            }
            runtimeStubs = stubs.toArray(new ILiferayRuntimeStub[0]);
        }
        return runtimeStubs;
    }

    public static IPath getTempLocation(String prefix, String fileName) {
        return LiferayServerCore.getDefault().getStateLocation().append("tmp").append(String.valueOf(prefix) + "/" + System.currentTimeMillis() + (CoreUtil.isNullOrEmpty((String)fileName) ? "" : "/" + fileName));
    }

    public static IStatus info(String msg) {
        return new Status(1, PLUGIN_ID, msg);
    }

    public static void logError(Exception e) {
        LiferayServerCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public static void logError(IStatus status) {
        LiferayServerCore.getDefault().getLog().log(status);
    }

    public static void logError(String msg) {
        LiferayServerCore.logError(LiferayServerCore.error(msg));
    }

    public static void logError(String msg, Throwable e) {
        LiferayServerCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, e));
    }

    public static void logError(Throwable t) {
        LiferayServerCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void logInfo(IStatus status) {
        LiferayServerCore.getDefault().getLog().log(status);
    }

    public static void logInfo(String msg) {
        LiferayServerCore.logInfo(LiferayServerCore.info(msg));
    }

    public static void setPreference(String key, String value) {
        try {
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).put(key, value);
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).flush();
        }
        catch (BackingStoreException e) {
            LiferayServerCore.logError("Unable to save preference", e);
        }
    }

    public static void updateConnectionSettings(IRemoteServer server) {
        LiferayServerCore.updateConnectionSettings(server, LiferayServerCore.getRemoteConnection(server));
    }

    public static void updateConnectionSettings(IRemoteServer server, IServerManagerConnection remoteConnection) {
        remoteConnection.setHost(server.getHost());
        remoteConnection.setHttpPort(server.getHTTPPort());
        remoteConnection.setManagerContextPath(server.getServerManagerContextPath());
        remoteConnection.setUsername(server.getUsername());
        remoteConnection.setPassword(server.getPassword());
    }

    public static IStatus validateRuntimeDelegate(RuntimeDelegate runtimeDelegate) {
        if (runtimeDelegate.getRuntime().isStub()) {
            return Status.OK_STATUS;
        }
        String runtimeTypeId = runtimeDelegate.getRuntime().getRuntimeType().getId();
        Object[] validators = LiferayServerCore.getRuntimeDelegateValidators();
        if (!CoreUtil.isNullOrEmpty((Object[])validators)) {
            Object[] objectArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status;
                Object validator = objectArray[n2];
                if (runtimeTypeId.equals(validator.getRuntimeTypeId()) && !(status = validator.validateRuntimeDelegate(runtimeDelegate)).isOK()) {
                    return status;
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    private boolean addRuntimeToMemento(IRuntime runtime, IMemento memento) {
        if (runtime instanceof Base) {
            Base base = (Base)runtime;
            try {
                Method save = Base.class.getDeclaredMethod("save", IMemento.class);
                if (save != null) {
                    save.setAccessible(true);
                    save.invoke((Object)base, memento);
                }
                return true;
            }
            catch (Exception e) {
                LiferayServerCore.logError("Unable to add runtime to memento", e);
            }
        }
        return false;
    }

    private boolean addServerToMemento(IServer server, IMemento memento) {
        if (server instanceof Base) {
            Base base = (Base)server;
            try {
                Method save = Base.class.getDeclaredMethod("save", IMemento.class);
                if (save != null) {
                    save.setAccessible(true);
                    save.invoke((Object)base, memento);
                }
                return true;
            }
            catch (Exception e) {
                LiferayServerCore.logError("Unable to add server to memento", e);
            }
        }
        return false;
    }

    private void copyMemento(IMemento from, IMemento to) {
        for (String name : from.getNames()) {
            to.putString(name, from.getString(name));
        }
    }

    private synchronized void saveGlobalRuntimeSettings(IRuntime runtime) {
        IRuntimeType runtimeType = runtime.getRuntimeType();
        if (runtimeType != null && runtimeType.getId().startsWith("com.liferay")) {
            try {
                int n;
                Object[] objectArray;
                LiferayCore.GLOBAL_SETTINGS_PATH.toFile().mkdirs();
                File runtimesGlobalFile = LiferayCore.GLOBAL_SETTINGS_PATH.append("runtimes.xml").toFile();
                HashSet<IRuntime> existing = new HashSet<IRuntime>();
                if (runtimesGlobalFile.exists()) {
                    try {
                        Object[] children;
                        IMemento existingMemento = XMLMemento.loadMemento((InputStream)new FileInputStream(runtimesGlobalFile));
                        if (existingMemento != null && !CoreUtil.isNullOrEmpty((Object[])(children = existingMemento.getChildren("runtime")))) {
                            objectArray = children;
                            n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IRuntime iRuntime = objectArray[n2];
                                IPath loc = Path.fromPortableString((String)iRuntime.getString("location"));
                                if (loc != null && loc.toFile().exists()) {
                                    boolean duplicate;
                                    boolean bl = duplicate = ServerCore.findRuntime((String)iRuntime.getString("id")) != null;
                                    if (!duplicate) {
                                        existing.add(iRuntime);
                                    }
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (Exception existingMemento) {
                        // empty catch block
                    }
                }
                HashMap<String, IMemento> mementos = new HashMap<String, IMemento>();
                XMLMemento runtimeMementos = XMLMemento.createWriteRoot((String)"runtimes");
                for (IMemento iMemento : existing) {
                    IMemento copy = runtimeMementos.createChild("runtime");
                    this.copyMemento(iMemento, copy);
                    mementos.put(copy.getString("id"), copy);
                }
                objectArray = ServerCore.getRuntimes();
                n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IMemento rMemento;
                    IRuntime iRuntime = objectArray[n3];
                    if (mementos.get(iRuntime.getId()) == null && iRuntime.getRuntimeType() != null && this.addRuntimeToMemento(iRuntime, rMemento = runtimeMementos.createChild("runtime"))) {
                        mementos.put(iRuntime.getId(), rMemento);
                    }
                    ++n3;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(runtimesGlobalFile);
                runtimeMementos.save((OutputStream)fileOutputStream);
            }
            catch (Exception e) {
                LiferayServerCore.logError("Unable to save global runtime settings", e);
            }
        }
    }

    private synchronized void saveGlobalServerSettings(IServer server) {
        IServerType serverType = server.getServerType();
        if (serverType != null && serverType.getId().startsWith("com.liferay")) {
            try {
                int n;
                Object[] objectArray;
                LiferayCore.GLOBAL_SETTINGS_PATH.toFile().mkdirs();
                File globalServersFile = LiferayCore.GLOBAL_SETTINGS_PATH.append("servers.xml").toFile();
                HashSet<IServer> existing = new HashSet<IServer>();
                if (globalServersFile.exists()) {
                    try {
                        Object[] children;
                        IMemento existingMemento = XMLMemento.loadMemento((InputStream)new FileInputStream(globalServersFile));
                        if (existingMemento != null && !CoreUtil.isNullOrEmpty((Object[])(children = existingMemento.getChildren("server")))) {
                            objectArray = children;
                            n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                boolean duplicate;
                                IServer iServer = objectArray[n2];
                                boolean bl = duplicate = ServerCore.findServer((String)iServer.getString("id")) != null;
                                if (!duplicate) {
                                    existing.add(iServer);
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (Exception existingMemento) {
                        // empty catch block
                    }
                }
                HashMap<String, IMemento> mementos = new HashMap<String, IMemento>();
                XMLMemento serverMementos = XMLMemento.createWriteRoot((String)"servers");
                for (IMemento iMemento : existing) {
                    IMemento copy = serverMementos.createChild("server");
                    this.copyMemento(iMemento, copy);
                    mementos.put(copy.getString("id"), copy);
                }
                objectArray = ServerCore.getServers();
                n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IMemento sMemento;
                    IServer iServer = objectArray[n3];
                    if (mementos.get(iServer.getId()) == null && iServer.getServerType() != null && this.addServerToMemento(iServer, sMemento = serverMementos.createChild("server"))) {
                        mementos.put(iServer.getId(), sMemento);
                    }
                    ++n3;
                }
                if (mementos.size() > 0) {
                    FileOutputStream fileOutputStream = new FileOutputStream(globalServersFile);
                    serverMementos.save((OutputStream)fileOutputStream);
                }
            }
            catch (Exception e) {
                LiferayServerCore.logError("Unable to save global server settings", e);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.runtimeLifecycleListener = new IRuntimeLifecycleListener(){

            public void runtimeAdded(IRuntime runtime) {
                LiferayServerCore.this.saveGlobalRuntimeSettings(runtime);
            }

            public void runtimeChanged(IRuntime runtime) {
                LiferayServerCore.this.saveGlobalRuntimeSettings(runtime);
            }

            public void runtimeRemoved(IRuntime runtime) {
                LiferayServerCore.this.saveGlobalRuntimeSettings(runtime);
            }
        };
        this.serverLifecycleListener = new IServerLifecycleListener(){

            public void serverAdded(IServer server) {
                LiferayServerCore.this.saveGlobalServerSettings(server);
            }

            public void serverChanged(IServer server) {
                LiferayServerCore.this.saveGlobalServerSettings(server);
            }

            public void serverRemoved(IServer server) {
                LiferayServerCore.this.saveGlobalServerSettings(server);
                if (connections.get(server.getId()) != null) {
                    connections.put(server.getId(), null);
                }
            }
        };
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeLifecycleListener);
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        SDKManager.getInstance().removeSDKListener(this.sdkListener);
        ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeLifecycleListener);
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
    }
}

