/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.BundlePublishOperation;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class BundlePublishFullRemove
extends BundlePublishOperation {
    public BundlePublishFullRemove(IServer server, IModule[] modules) {
        super(server, modules);
    }

    @Override
    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        for (IModule module : this.modules) {
            IProject project = module.getProject();
            if (project == null) continue;
            IStatus status = Status.OK_STATUS;
            IBundleProject bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)project);
            if (bundleProject != null) {
                String symbolicName = bundleProject.getSymbolicName();
                if (this.server.getServerState() == 2) {
                    monitor.subTask("Remotely undeploying " + module.getName() + " from Liferay module framework...");
                    status = this.remoteUninstall(bundleProject, symbolicName, monitor);
                }
                if (status != null && status.isOK()) {
                    this.portalServerBehavior.setModulePublishState2(new IModule[]{module}, 1);
                    project.deleteMarkers("com.liferay.ide.server.core.BundleOutputErrorMarker", false, 0);
                }
            } else {
                status = LiferayServerCore.error("Could not get module publisher for project " + module.getProject().getName());
            }
            if (status.isOK()) continue;
            throw new CoreException(status);
        }
    }

    private IStatus remoteUninstall(IBundleProject bundleProject, String symbolicName, IProgressMonitor monitor) throws CoreException {
        IStatus retval;
        block15: {
            retval = null;
            IPath outputJar = bundleProject.getOutputBundle(false, monitor);
            BundleSupervisor bundleSupervisor = null;
            try {
                try {
                    bundleSupervisor = this.createBundleSupervisor();
                    String error = bundleSupervisor.uninstall(bundleProject, outputJar);
                    retval = error == null ? Status.OK_STATUS : LiferayServerCore.error("Unable to uninstall bundle " + error);
                }
                catch (Exception e) {
                    retval = LiferayServerCore.error("Unable to uninstall bundle " + symbolicName, e);
                    if (bundleSupervisor != null) {
                        try {
                            bundleSupervisor.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (bundleSupervisor != null) {
                    try {
                        bundleSupervisor.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (bundleSupervisor != null) {
                try {
                    bundleSupervisor.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (retval == null) {
            retval = Status.OK_STATUS;
        }
        return retval;
    }
}

