/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.BundlePublishFullAdd;
import com.liferay.ide.server.core.portal.BundlePublishFullAddCleanBuild;
import com.liferay.ide.server.core.portal.BundlePublishFullRemove;
import com.liferay.ide.server.core.portal.BundlePublishOperation;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import com.liferay.ide.server.core.portal.PortalServerBehavior;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class PortalPublishTask
extends PublishTaskDelegate {
    private void addOperation(Class<? extends BundlePublishOperation> opClass, List<BundlePublishOperation> tasks, IServer server, IModule[] module) {
        for (BundlePublishOperation task : tasks) {
            if (!((Object)((Object)task)).getClass().equals(opClass)) continue;
            task.addModule(module);
            return;
        }
        try {
            BundlePublishOperation op = opClass.getConstructor(IServer.class, IModule[].class).newInstance(server, module);
            tasks.add(op);
        }
        catch (Exception e) {
            LiferayServerCore.logError("Unable to add bundle operation", e);
        }
    }

    public PublishOperation[] getTasks(IServer server, int kind, List modules, List kindList) {
        ArrayList<BundlePublishOperation> tasks = new ArrayList<BundlePublishOperation>();
        PortalServerBehavior serverBehavior = (PortalServerBehavior)server.loadAdapter(PortalServerBehavior.class, null);
        if (!CoreUtil.isNullOrEmpty((List)modules)) {
            int size = modules.size();
            int i = 0;
            while (i < size) {
                IModuleResourceDelta[] deltas;
                IModule[] module = (IModule[])modules.get(i);
                Integer deltaKind = (Integer)kindList.get(i);
                boolean needClean = false;
                IModuleResourceDelta[] iModuleResourceDeltaArray = deltas = ((Server)server).getPublishedResourceDelta(module);
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
                    IModuleResource resource = delta.getModuleResource();
                    IFile resourceFile = (IFile)resource.getAdapter(IFile.class);
                    if (resourceFile != null && resourceFile.getName().equals("bnd.bnd")) {
                        needClean = true;
                        break;
                    }
                    ++n2;
                }
                block1 : switch (kind) {
                    case 1: 
                    case 2: 
                    case 3: {
                        IProject project = module[0].getProject();
                        switch (deltaKind) {
                            case 1: {
                                this.addOperation(BundlePublishFullAddCleanBuild.class, tasks, server, module);
                                break block1;
                            }
                            case 2: {
                                if (needClean) {
                                    this.addOperation(BundlePublishFullAddCleanBuild.class, tasks, server, module);
                                    break block1;
                                }
                                this.addOperation(BundlePublishFullAdd.class, tasks, server, module);
                                break block1;
                            }
                            case 3: {
                                this.addOperation(BundlePublishFullRemove.class, tasks, server, module);
                                break block1;
                            }
                            case 0: {
                                IBundleProject bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)project);
                                if (bundleProject == null) break block1;
                                try {
                                    if (!this.isUserRedeploy(serverBehavior, module[0]) && this.isDeployed(server, serverBehavior, bundleProject.getSymbolicName())) break block1;
                                    this.addOperation(BundlePublishFullAddCleanBuild.class, tasks, server, module);
                                }
                                catch (CoreException e) {
                                    LiferayServerCore.logError("Unable to get bsn for project " + project.getName(), e);
                                }
                                break block1;
                            }
                        }
                        break;
                    }
                }
                ++i;
            }
        }
        return tasks.toArray(new PublishOperation[0]);
    }

    public PublishOperation[] getTasks(IServer server, List modules) {
        return super.getTasks(server, modules);
    }

    private boolean isDeployed(IServer server, PortalServerBehavior serverBehavior, String bsn) {
        boolean isDeployed;
        block13: {
            BundleSupervisor supervisor = null;
            isDeployed = false;
            if (server.getServerState() == 2) {
                try {
                    try {
                        supervisor = serverBehavior.createBundleSupervisor();
                        isDeployed = supervisor.getBundleId(bsn) > 0L;
                    }
                    catch (Exception exception) {
                        if (supervisor == null) break block13;
                        try {
                            supervisor.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (supervisor != null) {
                        try {
                            supervisor.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return isDeployed;
    }

    private boolean isUserRedeploy(PortalServerBehavior serverBehavior, IModule module) {
        if (serverBehavior.getInfo() != null) {
            Object moduleInfo = serverBehavior.getInfo().getAdapter(IModule.class);
            return module.equals(moduleInfo);
        }
        return false;
    }
}

