/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.core.portal.PortalBundleFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class PortalRuntime
extends RuntimeDelegate
implements ILiferayRuntime,
PropertyChangeListener {
    static final String PROP_VM_INSTALL_ID = "vm-install-id";
    static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    public static final String ID = "com.liferay.ide.server.portal.runtime";
    private PortalBundle portalBundle;

    public void dispose() {
        super.dispose();
        if (this.getRuntimeWorkingCopy() != null) {
            this.getRuntimeWorkingCopy().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public IPath getAppServerDeployDir() {
        return this.getPortalBundle().getAppServerDeployDir();
    }

    @Override
    public IPath getAppServerDir() {
        return this.getPortalBundle().getAppServerDir();
    }

    @Override
    public IPath getAppServerLibGlobalDir() {
        return this.getPortalBundle().getAppServerLibGlobalDir();
    }

    @Override
    public IPath getAppServerPortalDir() {
        return this.getPortalBundle().getAppServerPortalDir();
    }

    @Override
    public String getAppServerType() {
        return this.getPortalBundle().getType();
    }

    @Override
    public String[] getHookSupportedProperties() {
        return null;
    }

    @Override
    public String getJavadocURL() {
        return null;
    }

    @Override
    public IPath getLiferayHome() {
        PortalBundle portalBundle = this.getPortalBundle();
        if (portalBundle != null) {
            return portalBundle.getLiferayHome();
        }
        return null;
    }

    public PortalBundle getPortalBundle() {
        if (this.portalBundle == null) {
            this.initPortalBundle();
        }
        return this.portalBundle;
    }

    @Override
    public String getPortalVersion() {
        PortalBundle tempPortalBundle = this.getPortalBundle();
        if (tempPortalBundle != null) {
            return tempPortalBundle.getVersion();
        }
        return null;
    }

    @Override
    public Properties getPortletCategories() {
        return null;
    }

    @Override
    public Properties getPortletEntryCategories() {
        return null;
    }

    public List<IRuntimeClasspathEntry> getRuntimeClasspathEntries() {
        IPath[] paths;
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>();
        IPath[] iPathArray = paths = this.getPortalBundle().getRuntimeClasspath();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path.toFile().exists()) {
                entries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
            }
            ++n2;
        }
        return entries;
    }

    @Override
    public IPath getRuntimeLocation() {
        return this.getRuntime().getLocation();
    }

    @Override
    public IPath getSourceLocation() {
        return null;
    }

    @Override
    public IPath[] getUserLibs() {
        return this.portalBundle.getUserLibs();
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected void initialize() {
        super.initialize();
        if (this.getRuntimeWorkingCopy() != null) {
            this.getRuntimeWorkingCopy().addPropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.portalBundle == null) {
            this.initPortalBundle();
        }
    }

    private void initPortalBundle() {
        if (this.getRuntime().getLocation() != null) {
            PortalBundleFactory[] factories;
            PortalBundleFactory[] portalBundleFactoryArray = factories = LiferayServerCore.getPortalBundleFactories();
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                PortalBundleFactory factory = portalBundleFactoryArray[n2];
                IPath path = factory.canCreateFromPath(this.getRuntime().getLocation());
                if (path != null) {
                    this.portalBundle = factory.create(path);
                    return;
                }
                ++n2;
            }
        }
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    private boolean isVMMinimumVersion(String javaVersion, int minimumVersion) {
        Integer version = null;
        int index = javaVersion.indexOf(46);
        if (index > 0) {
            try {
                int major = Integer.parseInt(javaVersion.substring(0, index)) * 100;
                int index2 = javaVersion.indexOf(46, ++index);
                if (index2 > 0) {
                    int minor = Integer.parseInt(javaVersion.substring(index, index2));
                    version = new Integer(major + minor);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return version == null || version >= minimumVersion;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("location".equals(evt.getPropertyName())) {
            this.portalBundle = null;
            if (evt.getNewValue() != null) {
                this.initPortalBundle();
            }
        }
    }

    public void setDefaults(IProgressMonitor monitor) {
        IRuntimeType type = this.getRuntimeWorkingCopy().getRuntimeType();
        if (type != null) {
            this.getRuntimeWorkingCopy().setLocation((IPath)new Path(LiferayServerCore.getPreference("location." + type.getId())));
        }
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }

    public IStatus validate() {
        String javaVersion;
        IVMInstall vmInstall;
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        if (this.portalBundle == null) {
            return new Status(4, "com.liferay.ide.server.core", 0, Msgs.errorPortalNotExisted, null);
        }
        if (!this.portalBundle.getVersion().startsWith("7")) {
            return new Status(4, "com.liferay.ide.server.core", 0, Msgs.errorPortalVersion70, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "com.liferay.ide.server.core", 0, Msgs.errorJRE, null);
        }
        if (this.portalBundle.getVersion().startsWith("7") && (vmInstall = this.getVMInstall()) instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)vmInstall).getJavaVersion()) != null && !this.isVMMinimumVersion(javaVersion, 107)) {
            return new Status(4, "com.liferay.ide.server.core", 0, Msgs.errorJRE70, null);
        }
        return Status.OK_STATUS;
    }

    private static class Msgs
    extends NLS {
        public static String errorJRE;
        public static String errorJRE70;
        public static String errorPortalVersion70;
        public static String errorPortalNotExisted;

        static {
            Msgs.initializeMessages((String)PortalRuntime.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

