/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Version;

public class LiferayPortalValueLoader {
    private IPath[] userLibs;
    private IPath portalDir;

    public LiferayPortalValueLoader(IPath[] extraLibs) {
        this.userLibs = extraLibs;
    }

    public LiferayPortalValueLoader(IPath appServerPortalDir, IPath[] extraLibs) {
        this.portalDir = appServerPortalDir;
        this.userLibs = extraLibs;
    }

    private void addLibs(File libDir, List<URL> libUrlList) throws MalformedURLException {
        Object[] libs;
        if (libDir.exists() && !CoreUtil.isNullOrEmpty((Object[])(libs = libDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.toLowerCase().endsWith(".jar");
            }
        })))) {
            Object[] objectArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                Object portaLib = objectArray[n2];
                libUrlList.add(((File)portaLib).toURI().toURL());
                ++n2;
            }
        }
    }

    private Object[] getFieldValuesFromClass(String loadClassName, String fieldName) {
        Object[] retval = null;
        try {
            Class<?> classRef = this.loadClass(loadClassName);
            Field propertiesField = classRef.getDeclaredField(fieldName);
            retval = (Object[])propertiesField.get(propertiesField);
        }
        catch (Exception e) {
            retval = new Object[]{};
            LiferayServerCore.logError("Error unable to find " + loadClassName, e);
        }
        return retval;
    }

    private Object getMethodValueFromClass(String loadClassName, String methodName) {
        Object retval = null;
        try {
            Class<?> classRef = this.loadClass(loadClassName);
            Method method = classRef.getMethod(methodName, new Class[0]);
            retval = method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LiferayServerCore.logError("Error unable to find " + loadClassName, e);
        }
        return retval;
    }

    private Class<?> loadClass(String className) throws Exception {
        ArrayList<URL> libUrlList = new ArrayList<URL>();
        if (this.portalDir != null) {
            File libDir = this.portalDir.append("WEB-INF/lib").toFile();
            this.addLibs(libDir, libUrlList);
        }
        if (!CoreUtil.isNullOrEmpty((Object[])this.userLibs)) {
            IPath[] iPathArray = this.userLibs;
            int n = this.userLibs.length;
            int n2 = 0;
            while (n2 < n) {
                IPath url = iPathArray[n2];
                libUrlList.add(new File(url.toOSString()).toURI().toURL());
                ++n2;
            }
        }
        URL[] urls = libUrlList.toArray(new URL[libUrlList.size()]);
        return new URLClassLoader(urls).loadClass(className);
    }

    public String[] loadHookPropertiesFromClass() {
        String loadClassName = "com.liferay.portal.deploy.hot.HookHotDeployListener";
        String fieldName = "SUPPORTED_PROPERTIES";
        return (String[])this.getFieldValuesFromClass("com.liferay.portal.deploy.hot.HookHotDeployListener", "SUPPORTED_PROPERTIES");
    }

    public String loadServerInfoFromClass() {
        String loadClassName = "com.liferay.portal.kernel.util.ReleaseInfo";
        String methodName = "getServerInfo";
        return (String)this.getMethodValueFromClass("com.liferay.portal.kernel.util.ReleaseInfo", "getServerInfo");
    }

    public Version loadVersionFromClass() {
        String loadClassName = "com.liferay.portal.kernel.util.ReleaseInfo";
        String methodName = "getVersion";
        Version retval = null;
        try {
            String versionString = (String)this.getMethodValueFromClass("com.liferay.portal.kernel.util.ReleaseInfo", "getVersion");
            retval = Version.parseVersion((String)versionString);
        }
        catch (Exception e) {
            retval = Version.emptyVersion;
            LiferayServerCore.logError("Error unable to find com.liferay.portal.kernel.util.ReleaseInfo", e);
        }
        return retval;
    }
}

