/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.viewers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.ide.ui.viewers.TernModuleLabelProvider;
import tern.repository.ITernRepository;
import tern.server.ITernModule;

public class TernRepositoryLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final ITableLabelProvider INSTANCE = new TernRepositoryLabelProvider();

    public static ITableLabelProvider getInstance() {
        return INSTANCE;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ITernRepository) {
            ITernRepository repository = (ITernRepository)element;
            switch (columnIndex) {
                case 0: {
                    return repository.getName();
                }
                case 1: {
                    return repository.getTernBaseDirAsString();
                }
            }
        } else if (element instanceof ITernModule) {
            ITernModule module = (ITernModule)element;
            switch (columnIndex) {
                case 0: {
                    return module.getName();
                }
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ITernModule) {
            ITernModule module = (ITernModule)element;
            switch (columnIndex) {
                case 0: {
                    return TernModuleLabelProvider.getImageModule(module);
                }
            }
        }
        return null;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }
}

