/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.validators;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.ValidationPreferences;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.properties.IPropertiesRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.XMLQuerySpecificationManager;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToJava;
import org.eclipse.wst.xml.search.editor.references.validators.IXMLReferenceValidator;
import org.eclipse.wst.xml.search.editor.references.validators.IXMLReferenceValidator2;
import org.eclipse.wst.xml.search.editor.validation.IValidationResult;
import org.eclipse.wst.xml.search.editor.validation.LocalizedMessage;
import org.eclipse.wst.xml.search.editor.validation.ValidatorUtils;
import org.w3c.dom.Node;

public class LiferayBaseValidator
implements IXMLReferenceValidator,
IXMLReferenceValidator2 {
    public static final String MARKER_QUERY_ID = "querySpecificationId";
    public static final String MESSAGE_METHOD_NOT_FOUND = Msgs.methodNotFound;
    public static final String MESSAGE_PROPERTY_NOT_FOUND = Msgs.propertyNotFound;
    public static final String MESSAGE_REFERENCE_NOT_FOUND = Msgs.referenceNotFound;
    public static final String MESSAGE_RESOURCE_NOT_FOUND = Msgs.resourceNotFound;
    public static final String MESSAGE_STATIC_VALUE_UNDEFINED = Msgs.staticValueUndefined;
    public static final String MESSAGE_SYNTAX_INVALID = Msgs.syntaxInvalid;
    public static final String MESSAGE_TYPE_HIERARCHY_INCORRECT = Msgs.typeHierarchyIncorrect;
    public static final String MESSAGE_TYPE_NOT_FOUND = Msgs.typeNotFound;
    protected static final String PREFERENCE_NODE_QUALIFIER = ProjectCore.getDefault().getBundle().getSymbolicName();
    private static final String[] oldMarkerTypes = new String[]{"liferayPortletDescriptorMarker", "liferayLayoutTplDescriptorMarker", "liferayDisplayDescriptorMarker", "liferayHookDescriptorMarker", "portletDescriptorMarker"};

    protected void addMessage(IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode, String messageText, int severity, String liferayPluginValidationType) {
        this.addMessage(node, file, validator, reporter, batchMode, messageText, severity, liferayPluginValidationType, null);
    }

    protected void addMessage(IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode, String messageText, int severity, String liferayPluginValidationType, String querySpecificationId) {
        int length;
        int startOffset = this.getStartOffset(node);
        LocalizedMessage message = this.createMessage(startOffset, length = node.getEndOffset() - startOffset, messageText, severity, node.getStructuredDocument());
        if (message != null && batchMode) {
            message.setTargetObject((Object)file);
            message.setAttribute(MARKER_QUERY_ID, (Object)querySpecificationId);
            message.setAttribute("liferayPluginValidationType", (Object)liferayPluginValidationType);
            reporter.addMessage(validator, (IMessage)message);
        }
    }

    protected LocalizedMessage createMessage(int start, int length, String messageText, int severity, IStructuredDocument structuredDocument) {
        return ValidatorUtils.createMessage((int)start, (int)length, (String)messageText, (int)severity, (IStructuredDocument)structuredDocument);
    }

    protected void doValidate(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        if (reference.isExpression()) {
            return;
        }
        if (!this.validateSyntax(reference, node, file, validator, reporter, batchMode)) {
            return;
        }
        List refTos = reference.getTo();
        if (refTos == null || refTos.size() != 1) {
            return;
        }
        IXMLReferenceTo referenceTo = (IXMLReferenceTo)refTos.get(0);
        switch (referenceTo.getType()) {
            case XML: {
                this.validateReferenceToXML(referenceTo, node, file, validator, reporter, batchMode);
                break;
            }
            case JAVA: {
                this.validateReferenceToJava(referenceTo, node, file, validator, reporter, batchMode);
                break;
            }
            case JAVA_METHOD: {
                this.validateReferenceToJavaMethod(referenceTo, node, file, validator, reporter, batchMode);
                break;
            }
            case RESOURCE: {
                this.validateReferenceToResource(referenceTo, node, file, validator, reporter, batchMode);
                break;
            }
            case PROPERTY: {
                this.validateReferenceToProperty(referenceTo, node, file, validator, reporter, batchMode);
                break;
            }
            case STATIC: {
                this.validateReferenceToStatic(referenceTo, node, file, validator, reporter, batchMode);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected String getMessageText(ValidationPreferences.ValidationType validationType, IXMLReferenceTo referenceTo, Node node, IFile file) {
        String nodeValue = DOMUtils.getNodeValue((Node)node);
        String textContent = nodeValue == null ? "" : nodeValue;
        switch (validationType) {
            case SYNTAX_INVALID: {
                return NLS.bind((String)MESSAGE_SYNTAX_INVALID, (Object)textContent);
            }
            case TYPE_NOT_FOUND: {
                return NLS.bind((String)MESSAGE_TYPE_NOT_FOUND, (Object)textContent);
            }
            case METHOD_NOT_FOUND: {
                return NLS.bind((String)MESSAGE_METHOD_NOT_FOUND, (Object)textContent);
            }
            case TYPE_HIERARCHY_INCORRECT: {
                IType[] superTypes;
                if (referenceTo != null && referenceTo.getType() == IXMLReferenceTo.ToType.JAVA && file != null && (superTypes = ((IXMLReferenceToJava)referenceTo).getExtends((Object)node, file)) != null && superTypes.length > 0) {
                    StringBuilder sb = new StringBuilder();
                    IType[] iTypeArray = superTypes;
                    int n = superTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        sb.append(type.getFullyQualifiedName());
                        sb.append(", ");
                        ++n2;
                    }
                    String superTypeNames = sb.toString().replaceAll(", $", "");
                    return NLS.bind((String)MESSAGE_TYPE_HIERARCHY_INCORRECT, (Object)textContent, (Object)superTypeNames);
                }
            }
            case RESOURCE_NOT_FOUND: {
                return NLS.bind((String)MESSAGE_RESOURCE_NOT_FOUND, (Object)textContent);
            }
            case REFERENCE_NOT_FOUND: {
                IFile referencedFile = this.getReferencedFile(referenceTo, node, file);
                return NLS.bind((String)MESSAGE_REFERENCE_NOT_FOUND, (Object)textContent, (Object)(referencedFile != null ? referencedFile.getName() : ""));
            }
            case PROPERTY_NOT_FOUND: {
                IFile languagePropertiesFile = this.getReferencedFile(referenceTo, node, file);
                return NLS.bind((String)MESSAGE_PROPERTY_NOT_FOUND, (Object)textContent, (Object)(languagePropertiesFile != null ? languagePropertiesFile.getName() : "any resource files"));
            }
            case STATIC_VALUE_UNDEFINED: {
                return NLS.bind((String)MESSAGE_STATIC_VALUE_UNDEFINED, (Object)textContent);
            }
        }
        return null;
    }

    protected String getMessageText(ValidationPreferences.ValidationType validationType, Node node) {
        return this.getMessageText(validationType, null, node, null);
    }

    protected IFile getReferencedFile(IXMLReferenceTo referenceTo, Node node, IFile file) {
        IXMLQuerySpecification querySpecification = XMLQuerySpecificationManager.getDefault().getQuerySpecification(referenceTo.getQuerySpecificationId());
        if (!querySpecification.isMultiResource()) {
            IResource resource = querySpecification.getResource((Object)node, (IResource)file);
            IXMLSearchRequestor requestor = querySpecification.getRequestor();
            return new ReferencedFileVisitor().getReferencedFile(requestor, resource);
        }
        return null;
    }

    protected IScopeContext[] getScopeContexts(IProject project) {
        IScopeContext[] iScopeContextArray;
        ProjectScope projectScope = new ProjectScope(project);
        if (projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false)) {
            IScopeContext[] iScopeContextArray2 = new IScopeContext[3];
            iScopeContextArray2[0] = projectScope;
            iScopeContextArray2[1] = InstanceScope.INSTANCE;
            iScopeContextArray = iScopeContextArray2;
            iScopeContextArray2[2] = DefaultScope.INSTANCE;
        } else {
            IScopeContext[] iScopeContextArray3 = new IScopeContext[2];
            iScopeContextArray3[0] = InstanceScope.INSTANCE;
            iScopeContextArray = iScopeContextArray3;
            iScopeContextArray3[1] = DefaultScope.INSTANCE;
        }
        return iScopeContextArray;
    }

    protected int getServerity(ValidationPreferences.ValidationType validationType, IFile file) {
        String liferayPluginValidationType = this.getLiferayPluginValidationType(validationType, file);
        return Platform.getPreferencesService().getInt(PREFERENCE_NODE_QUALIFIER, liferayPluginValidationType, 2, this.getScopeContexts(file.getProject()));
    }

    protected int getStartOffset(IDOMNode node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((IDOMAttr)node).getValueRegionStartOffset();
            }
        }
        return node.getStartOffset();
    }

    protected String getLiferayPluginValidationType(ValidationPreferences.ValidationType validationType, IFile file) {
        return ValidationPreferences.getValidationPreferenceKey((String)file.getName(), (ValidationPreferences.ValidationType)validationType);
    }

    protected ValidationPreferences.ValidationType getValidationType(IXMLReferenceTo referenceTo, int nbElements) {
        switch (referenceTo.getType()) {
            case XML: {
                return ValidationPreferences.ValidationType.REFERENCE_NOT_FOUND;
            }
            case JAVA: {
                if (nbElements == -1) {
                    return ValidationPreferences.ValidationType.TYPE_HIERARCHY_INCORRECT;
                }
                return ValidationPreferences.ValidationType.TYPE_NOT_FOUND;
            }
            case JAVA_METHOD: {
                return ValidationPreferences.ValidationType.METHOD_NOT_FOUND;
            }
            case RESOURCE: {
                return ValidationPreferences.ValidationType.RESOURCE_NOT_FOUND;
            }
            case PROPERTY: {
                return ValidationPreferences.ValidationType.PROPERTY_NOT_FOUND;
            }
            case STATIC: {
                return ValidationPreferences.ValidationType.STATIC_VALUE_UNDEFINED;
            }
        }
        return null;
    }

    protected boolean isMultipleElementsAllowed(IDOMNode node, int nbElements) {
        return true;
    }

    public boolean isValidTarget(IProject project) {
        String[] ignoreList;
        String[] stringArray = ignoreList = LiferayXMLSearchUI.getDefault().getPreferenceStore().getString("ignore-projects-list").split(",");
        int n = ignoreList.length;
        int n2 = 0;
        while (n2 < n) {
            String ignore = stringArray[n2];
            if (ignore.trim().equals(project.getName())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void setMarker(IValidator validator, IFile file) {
    }

    public void validate(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        if (reference != null) {
            this.setMarker(validator, file);
            this.doValidate(reference, node, file, validator, reporter, batchMode);
        }
        String[] stringArray = oldMarkerTypes;
        int n = oldMarkerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = file.findMarkers("com.liferay.ide.xml.search.ui." + type, false, 1);
                int n3 = markers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker marker = iMarkerArray[n4];
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++n4;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }

    protected void validateReferenceToAllType(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        String nodeValue = DOMUtils.getNodeValue((Node)node);
        IValidationResult result = referenceTo.getSearcher().searchForValidation((Object)node, nodeValue, -1, -1, file, referenceTo);
        if (result != null) {
            boolean addMessage = false;
            int nbElements = result.getNbElements();
            if (nbElements > 0) {
                if (nbElements > 1 && !this.isMultipleElementsAllowed(node, nbElements)) {
                    addMessage = true;
                }
            } else {
                addMessage = true;
            }
            if (addMessage) {
                ValidationPreferences.ValidationType validationType = this.getValidationType(referenceTo, nbElements);
                int severity = this.getServerity(validationType, file);
                String liferayPluginValidationType = this.getLiferayPluginValidationType(validationType, file);
                if (severity != -1) {
                    String messageText = this.getMessageText(validationType, referenceTo, (Node)node, file);
                    this.addMessage(node, file, validator, reporter, batchMode, messageText, severity, liferayPluginValidationType, referenceTo.getQuerySpecificationId());
                }
            }
        }
    }

    protected void validateReferenceToJava(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        this.validateReferenceToAllType(referenceTo, node, file, validator, reporter, batchMode);
    }

    protected void validateReferenceToJavaMethod(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        this.validateReferenceToAllType(referenceTo, node, file, validator, reporter, batchMode);
    }

    protected void validateReferenceToProperty(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        this.validateReferenceToAllType(referenceTo, node, file, validator, reporter, batchMode);
    }

    protected void validateReferenceToResource(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        this.validateReferenceToAllType(referenceTo, node, file, validator, reporter, batchMode);
    }

    protected void validateReferenceToStatic(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        this.validateReferenceToAllType(referenceTo, node, file, validator, reporter, batchMode);
    }

    protected void validateReferenceToXML(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        this.validateReferenceToAllType(referenceTo, node, file, validator, reporter, batchMode);
    }

    protected boolean validateSyntax(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        return true;
    }

    protected static class Msgs
    extends NLS {
        public static String propertyNotFound;
        public static String referenceNotFound;
        public static String resourceNotFound;
        public static String staticValueUndefined;
        public static String syntaxInvalid;
        public static String typeHierarchyIncorrect;
        public static String typeNotFound;
        public static String methodNotFound;

        static {
            Msgs.initializeMessages((String)LiferayBaseValidator.class.getName(), Msgs.class);
        }

        protected Msgs() {
        }
    }

    private class ReferencedFileVisitor
    implements IResourceProxyVisitor {
        IFile retval = null;
        IResource rootResource;
        IXMLSearchRequestor searchRequestor;

        private ReferencedFileVisitor() {
        }

        public IFile getReferencedFile(IXMLSearchRequestor requestor, IResource rootResource) {
            this.searchRequestor = requestor;
            this.rootResource = rootResource;
            try {
                rootResource.accept((IResourceProxyVisitor)this, 4);
            }
            catch (CoreException e) {
                LiferayXMLSearchUI.logError(e);
            }
            return this.retval;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean visit(IResourceProxy proxy) {
            try {
                if (proxy.getType() != 1) return true;
                IFile file = (IFile)proxy.requestResource();
                if (!this.searchRequestor.accept((IResource)file, this.rootResource)) return true;
                IStructuredModel model = null;
                try {
                    model = StructuredModelManager.getModelManager().getModelForRead(file);
                    if (!this.searchRequestor.accept(model)) return true;
                    this.retval = file;
                    return false;
                }
                finally {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
            }
            catch (Exception e) {
                return true;
            }
        }
    }

    class ReferencedPropertiesVisitor
    implements IResourceProxyVisitor {
        IPropertiesRequestor propertiesRequestor;
        IFile retval = null;
        IResource rootResource;

        ReferencedPropertiesVisitor() {
        }

        public IFile getReferencedFile(IPropertiesRequestor requestor, IResource rootResource) {
            this.propertiesRequestor = requestor;
            this.rootResource = rootResource;
            try {
                rootResource.accept((IResourceProxyVisitor)this, 4);
            }
            catch (CoreException e) {
                LiferayXMLSearchUI.logError(e);
            }
            return this.retval;
        }

        public boolean visit(IResourceProxy proxy) {
            try {
                IFile file;
                if (proxy.getType() == 1 && this.propertiesRequestor.accept((IResource)(file = (IFile)proxy.requestResource()), this.rootResource)) {
                    this.retval = file;
                    return false;
                }
            }
            catch (Exception e) {
                return true;
            }
            return true;
        }
    }
}

