/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.validators;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.project.core.ValidationPreferences;
import com.liferay.ide.xml.search.ui.PortalLanguagePropertiesCacheUtil;
import com.liferay.ide.xml.search.ui.validators.LiferayBaseValidator;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.properties.IPropertiesQuerySpecification;
import org.eclipse.wst.xml.search.core.properties.IPropertiesRequestor;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToProperty;
import org.eclipse.wst.xml.search.editor.util.PropertiesQuerySpecificationUtil;
import org.eclipse.wst.xml.search.editor.validation.IValidationResult;
import org.eclipse.wst.xml.search.editor.validation.LocalizedMessage;
import org.eclipse.wst.xml.search.editor.validation.XMLReferencesBatchValidator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LiferayJspValidator
extends LiferayBaseValidator {
    private final String ACTION_REQUEST_ACTION_NAME = "ActionRequest.ACTION_NAME";
    private final String AUI_PREFIX = "aui";
    private final String JAVAX_PORTLET_ACTION = "javax.portlet.action";
    private final String JSP_TAG_START = "<%";
    private final String JSP_TAG_END = "%>";
    private final String[] SUPPORTED_TAGS = new String[]{"liferay-portlet:param", "portlet:param"};
    public static final String MESSAGE_CLASS_ATTRIBUTE_NOT_WORK = Msgs.classAttributeNotWork;

    @Override
    protected void addMessage(IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode, String messageText, int severity, String liferayPluginValidationType, String querySpecificationId) {
        int length;
        LocalizedMessage message;
        String textContent = DOMUtils.getNodeValue((Node)node);
        int startOffset = this.getStartOffset(node);
        if (textContent != null && (message = this.createMessage(startOffset, length = textContent.trim().length() + 2, messageText, severity, node.getStructuredDocument())) != null) {
            message.setAttribute("querySpecificationId", (Object)querySpecificationId);
            message.setAttribute("textContent", (Object)textContent);
            message.setAttribute("fullPath", (Object)file.getFullPath().toPortableString());
            message.setAttribute("markerType", (Object)"org.eclipse.jst.jsp.core.validationMarker");
            message.setAttribute("liferayPluginValidationType", (Object)liferayPluginValidationType);
            message.setTargetObject((Object)file);
            reporter.addMessage(validator, (IMessage)message);
        }
    }

    @Override
    protected String getMessageText(ValidationPreferences.ValidationType validationType, IXMLReferenceTo referenceTo, Node node, IFile file) {
        if (node.toString().equals("class") && validationType.equals((Object)ValidationPreferences.ValidationType.STATIC_VALUE_UNDEFINED)) {
            return NLS.bind((String)MESSAGE_CLASS_ATTRIBUTE_NOT_WORK, null);
        }
        return super.getMessageText(validationType, referenceTo, node, file);
    }

    @Override
    protected IFile getReferencedFile(IXMLReferenceTo referenceTo, Node node, IFile file) {
        if (referenceTo instanceof IXMLReferenceToProperty) {
            IXMLReferenceToProperty referenceToProperty = (IXMLReferenceToProperty)referenceTo;
            IPropertiesQuerySpecification[] querySpecifications = PropertiesQuerySpecificationUtil.getQuerySpecifications((IXMLReferenceToProperty)referenceToProperty);
            if (querySpecifications == null || querySpecifications.length < 1) {
                return null;
            }
            IPropertiesQuerySpecification querySpecification = null;
            querySpecification = querySpecifications[0];
            IPropertiesRequestor requestor = querySpecification.getRequestor();
            IResource resource = querySpecification.getResource((Object)node, (IResource)file);
            return new LiferayBaseValidator.ReferencedPropertiesVisitor(this).getReferencedFile(requestor, resource);
        }
        return null;
    }

    @Override
    protected int getServerity(ValidationPreferences.ValidationType validationType, IFile file) {
        int retval = -1;
        String liferayPluginValidationType = this.getLiferayPluginValidationType(validationType, file);
        retval = liferayPluginValidationType != null ? Platform.getPreferencesService().getInt(PREFERENCE_NODE_QUALIFIER, liferayPluginValidationType, 2, this.getScopeContexts(file.getProject())) : super.getServerity(validationType, file);
        return retval;
    }

    @Override
    protected String getLiferayPluginValidationType(ValidationPreferences.ValidationType validationType, IFile file) {
        String retval = null;
        if (ValidationPreferences.ValidationType.PROPERTY_NOT_FOUND.equals((Object)validationType)) {
            retval = "liferay-jsp--property-not-found";
        } else if (ValidationPreferences.ValidationType.METHOD_NOT_FOUND.equals((Object)validationType)) {
            retval = "liferay-jsp-method-not-found";
        } else if (ValidationPreferences.ValidationType.REFERENCE_NOT_FOUND.equals((Object)validationType)) {
            retval = "liferay-jsp-reference-not-found";
        } else if (ValidationPreferences.ValidationType.RESOURCE_NOT_FOUND.equals((Object)validationType)) {
            retval = "liferya-jsp-resource-not-found";
        } else if (ValidationPreferences.ValidationType.STATIC_VALUE_UNDEFINED.equals((Object)validationType)) {
            retval = "liferay-jsp-static-value-undefined";
        } else if (ValidationPreferences.ValidationType.TYPE_HIERARCHY_INCORRECT.equals((Object)validationType)) {
            retval = "liferay-jsp-hierarchy-incorrect";
        } else if (ValidationPreferences.ValidationType.TYPE_NOT_FOUND.equals((Object)validationType)) {
            retval = "liferay-jsp-type-not-found";
        }
        return retval;
    }

    private boolean isSupportedTag(String tagName) {
        String[] stringArray = this.SUPPORTED_TAGS;
        int n = this.SUPPORTED_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            String supportTag = stringArray[n2];
            if (supportTag.equals(tagName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void setMarker(IValidator validator, IFile file) {
        if (validator instanceof XMLReferencesBatchValidator && file.getFileExtension().equals("jsp")) {
            ((XMLReferencesBatchValidator)validator).getParent().setMarkerId("org.eclipse.jst.jsp.core.validationMarker");
        }
    }

    @Override
    protected void validateReferenceToJava(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        IDOMAttr nameAttr;
        AttrImpl attrNode;
        Element parentNode;
        if (node instanceof AttrImpl && this.isSupportedTag((parentNode = (attrNode = (AttrImpl)node).getOwnerElement()).getNodeName()) && (nameAttr = DOMUtils.getAttr((IDOMElement)((IDOMElement)parentNode), (String)"name")) != null && (nameAttr.getNodeValue().contains("ActionRequest.ACTION_NAME") || nameAttr.getNodeValue().contains("javax.portlet.action"))) {
            super.validateReferenceToJava(referenceTo, (IDOMNode)attrNode, file, validator, reporter, batchMode);
        }
    }

    @Override
    protected void validateReferenceToProperty(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        IValidationResult result;
        String languageKey = DOMUtils.getNodeValue((Node)node);
        if (!languageKey.contains("<%") && !languageKey.contains("%>") && (result = referenceTo.getSearcher().searchForValidation((Object)node, languageKey, -1, -1, file, referenceTo)) != null) {
            boolean addMessage = false;
            int nbElements = result.getNbElements();
            if (nbElements > 0) {
                if (nbElements > 1 && !this.isMultipleElementsAllowed(node, nbElements)) {
                    addMessage = true;
                }
            } else {
                addMessage = true;
            }
            if (addMessage) {
                ValidationPreferences.ValidationType validationType;
                int severity;
                Properties properties = PortalLanguagePropertiesCacheUtil.getPortalLanguageProperties(LiferayCore.create((Object)file.getProject()));
                if (properties != null) {
                    try {
                        String languageValue = (String)properties.get(languageKey);
                        if (!languageValue.equals("")) {
                            addMessage = false;
                        }
                    }
                    catch (Exception languageValue) {
                        // empty catch block
                    }
                }
                if (addMessage && (severity = this.getServerity(validationType = this.getValidationType(referenceTo, nbElements), file)) != -1) {
                    String liferayPluginValidationType = this.getLiferayPluginValidationType(validationType, file);
                    String querySpecificationId = referenceTo.getQuerySpecificationId();
                    String messageText = this.getMessageText(validationType, referenceTo, (Node)node, file);
                    this.addMessage(node, file, validator, reporter, batchMode, messageText, severity, liferayPluginValidationType, querySpecificationId);
                }
            }
        }
    }

    @Override
    protected void validateReferenceToStatic(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        if (node instanceof AttrImpl) {
            AttrImpl attrNode = (AttrImpl)node;
            if (attrNode.getOwnerElement().getNodeName().startsWith("aui")) {
                ValidationPreferences.ValidationType validationType;
                int severity;
                String nodeValue = node.toString();
                boolean addMessage = false;
                if (nodeValue.equals("class")) {
                    addMessage = true;
                }
                if (addMessage && (severity = this.getServerity(validationType = this.getValidationType(referenceTo, 0), file)) != -1) {
                    String liferayPluginValidationType = this.getLiferayPluginValidationType(validationType, file);
                    String querySpecificationId = referenceTo.getQuerySpecificationId();
                    String messageText = this.getMessageText(validationType, referenceTo, (Node)node, file);
                    this.addMessage(node, file, validator, reporter, batchMode, messageText, severity, liferayPluginValidationType, querySpecificationId);
                }
            } else {
                super.validateReferenceToStatic(referenceTo, (IDOMNode)attrNode, file, validator, reporter, batchMode);
            }
        }
    }

    protected static class Msgs
    extends NLS {
        public static String classAttributeNotWork;

        static {
            Msgs.initializeMessages((String)LiferayJspValidator.class.getName(), Msgs.class);
        }

        protected Msgs() {
        }
    }
}

