/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.INodejsInstallManager;
import tern.eclipse.ide.server.nodejs.internal.core.NodejsInstall;
import tern.eclipse.ide.server.nodejs.internal.core.Trace;

public class NodejsInstallManager
implements INodejsInstallManager,
IRegistryChangeListener {
    private static final String EXTENSION_NODEJS_INSTALLS = "nodeJSInstalls";
    private static final NodejsInstallManager INSTANCE = new NodejsInstallManager();
    private List<INodejsInstall> nodeJSInstalls;
    private boolean registryListenerIntialized = false;

    public static NodejsInstallManager getManager() {
        return INSTANCE;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.server.nodejs.core", EXTENSION_NODEJS_INSTALLS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleNodejsInstallDelta(delta);
                ++n2;
            }
        }
    }

    @Override
    public INodejsInstall[] getNodejsInstalls() {
        if (this.nodeJSInstalls == null) {
            this.loadNodejsInstalls();
        }
        INodejsInstall[] st = new INodejsInstall[this.nodeJSInstalls.size()];
        this.nodeJSInstalls.toArray(st);
        return st;
    }

    @Override
    public INodejsInstall findNodejsInstall(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (this.nodeJSInstalls == null) {
            this.loadNodejsInstalls();
        }
        for (INodejsInstall nodeJSInstall : this.nodeJSInstalls) {
            if (!id.equals(nodeJSInstall.getId())) continue;
            return nodeJSInstall;
        }
        return null;
    }

    private synchronized void loadNodejsInstalls() {
        if (this.nodeJSInstalls != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .nodeJSInstalls extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.server.nodejs.core", EXTENSION_NODEJS_INSTALLS);
        ArrayList<INodejsInstall> list = new ArrayList<INodejsInstall>(cf.length);
        this.addNodejsInstalls(cf, list);
        this.addRegistryListenerIfNeeded();
        this.nodeJSInstalls = list;
        Trace.trace((byte)7, "-<- Done loading .nodeJSInstalls extension point -<-");
    }

    private synchronized void addNodejsInstalls(IConfigurationElement[] cf, List<INodejsInstall> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                list.add(new NodejsInstall(ce));
                Trace.trace((byte)7, "  Loaded nodeJSInstall: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load nodeJSInstall: " + ce.getAttribute("id"), t);
            }
            ++n2;
        }
    }

    protected void handleNodejsInstallDelta(IExtensionDelta delta) {
        if (this.nodeJSInstalls == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList<INodejsInstall> list = new ArrayList<INodejsInstall>(this.nodeJSInstalls);
        if (delta.getKind() == 1) {
            this.addNodejsInstalls(cf, list);
        } else {
            int size = list.size();
            NodejsInstall[] st = new NodejsInstall[size];
            list.toArray(st);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (st[i].getId().equals(cf[j].getAttribute("id"))) {
                        st[i].dispose();
                        list.remove(st[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.nodeJSInstalls = list;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.server.nodejs.core");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }
}

