/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.core.debugger;

import java.io.File;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import tern.TernException;
import tern.eclipse.ide.server.nodejs.core.debugger.AbstractNodejsDebugProcess;
import tern.eclipse.ide.server.nodejs.core.debugger.launchConfigurations.NodejsCliFileHelper;
import tern.server.nodejs.process.NodejsProcessException;

public class ProgramNodejsDebugProcess
extends AbstractNodejsDebugProcess {
    public ProgramNodejsDebugProcess(IFile jsFile, File workingDir, File nodejsInstallPath, String launchConfigId) throws TernException {
        super(jsFile, workingDir, nodejsInstallPath, launchConfigId);
    }

    @Override
    protected void start(ILaunchConfigurationWorkingCopy workingCopy) throws Exception {
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", this.getNodeInstallPath());
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", this.getWorkingDir());
        String args = this.getArgs();
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        this.notifyCreateProcess(Collections.emptyList(), this.projectDir);
        final ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

            public void launchesRemoved(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesTerminated(ILaunch[] launches) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch lc = iLaunchArray[n2];
                    if (lc.equals(ProgramNodejsDebugProcess.this.launch)) {
                        manager.removeLaunchListener((ILaunchesListener)this);
                        ProgramNodejsDebugProcess.this.notifyStopProcess();
                    }
                    ++n2;
                }
            }
        });
        this.launch = workingCopy.launch("run", null);
        IProcess[] iProcessArray = this.launch.getProcesses();
        int n = iProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            if (process instanceof RuntimeProcess) {
                new AbstractNodejsDebugProcess.StdOut(process.getStreamsProxy().getOutputStreamMonitor());
                new AbstractNodejsDebugProcess.StdErr(process.getStreamsProxy().getErrorStreamMonitor());
            }
            ++n2;
        }
    }

    private String getArgs() throws NodejsProcessException {
        StringBuilder args = new StringBuilder();
        args.append(NodejsCliFileHelper.getWorkspaceLoc((IResource)this.getJsFile()));
        for (String arg : this.createNodejsArgs()) {
            args.append(" ");
            args.append(arg);
        }
        return args.toString();
    }
}

