/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.BaseLiferayProject;
import com.liferay.ide.core.IResourceBundleProject;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.project.core.ProjectCore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class FlexibleProject
extends BaseLiferayProject
implements IWebProject,
IResourceBundleProject {
    private static IFolder getDefaultDocroot(IProject project) {
        IFolder folder = null;
        IVirtualFolder webappRoot = FlexibleProject.getVirtualDocroot(project);
        if (webappRoot != null) {
            try {
                IFolder f;
                IPath defaultFolder = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)webappRoot);
                if (defaultFolder != null && (f = project.getFolder(defaultFolder)).exists()) {
                    folder = f;
                }
            }
            catch (Exception e) {
                ProjectCore.logError("Could not determine default docroot", e);
            }
        }
        return folder;
    }

    private static IVirtualFolder getVirtualDocroot(IProject project) {
        IVirtualComponent comp;
        IVirtualFolder retval = null;
        if (project != null && (comp = ComponentCore.createComponent((IProject)project)) != null) {
            retval = comp.getRootFolder();
        }
        return retval;
    }

    public FlexibleProject(IProject project) {
        super(project);
    }

    public IResource findDocrootResource(IPath path) {
        IVirtualResource virtualResource;
        IFile retval = null;
        IVirtualFolder docroot = FlexibleProject.getVirtualDocroot(this.getProject());
        if (docroot != null && (virtualResource = docroot.findMember(path)) != null && virtualResource.exists()) {
            IResource[] iResourceArray = virtualResource.getUnderlyingResources();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r.exists() && r instanceof IFile) {
                    retval = (IFile)r;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public IFolder getDefaultDocrootFolder() {
        return FlexibleProject.getDefaultDocroot(this.getProject());
    }

    public List<IFile> getDefaultLanguageProperties() {
        return PropertiesUtil.getDefaultLanguagePropertiesFromPortletXml((IFile)this.getDescriptorFile("portlet.xml"));
    }

    public IFile getDescriptorFile(String name) {
        IVirtualFolder webappRoot;
        IFile retval = null;
        IFolder defaultDocrootFolder = this.getDefaultDocrootFolder();
        if (defaultDocrootFolder != null && defaultDocrootFolder.exists()) {
            retval = defaultDocrootFolder.getFile(new Path("WEB-INF").append(name));
        }
        if (retval == null && (webappRoot = FlexibleProject.getVirtualDocroot(this.getProject())) != null) {
            IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile descriptorFile;
                IContainer container = iContainerArray[n2];
                if (container != null && container.exists() && (descriptorFile = container.getFile(new Path("WEB-INF").append(name))).exists()) {
                    retval = descriptorFile;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public IFolder[] getSourceFolders() {
        ArrayList<IFolder> retval = new ArrayList<IFolder>();
        List sourceFolders = JavaLiteUtilities.getJavaSourceContainers((IJavaProjectLite)JavaCoreLite.create((IProject)this.getProject()));
        if (sourceFolders != null && sourceFolders.size() > 0) {
            for (IContainer sourceFolder : sourceFolders) {
                if (!(sourceFolder instanceof IFolder)) continue;
                retval.add((IFolder)sourceFolder);
            }
        }
        return retval.toArray(new IFolder[retval.size()]);
    }

    public boolean pathInDocroot(IPath path) {
        IVirtualFolder webappRoot;
        if (path != null && (webappRoot = FlexibleProject.getVirtualDocroot(this.getProject())) != null) {
            IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isDocrootResource;
                IContainer container = iContainerArray[n2];
                boolean bl = isDocrootResource = container != null && container.exists() && container.getFullPath().isPrefixOf(path);
                if (isDocrootResource) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

