/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.AbstractLiferayProjectProvider;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.FlexibleProject;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.PluginsSDKBundleProject;
import com.liferay.ide.project.core.PluginsSDKRuntimeProject;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.project.core.util.ClasspathUtil;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.WizardUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.util.ServerUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Version;

public class PluginsSDKProjectProvider
extends AbstractLiferayProjectProvider
implements NewLiferayProjectProvider<NewLiferayPluginProjectOp> {
    public PluginsSDKProjectProvider() {
        super(new Class[]{IProject.class, IRuntime.class});
    }

    private void portletProjectCreated(NewLiferayPluginProjectOp op, IProject newProject, IProgressMonitor monitor) throws CoreException {
        IPortletFramework portletFramework = (IPortletFramework)op.getPortletFramework().content();
        String portletName = (String)op.getPortletName().content(false);
        String frameworkName = NewLiferayPluginProjectOpMethods.getFrameworkName(op);
        IStatus status = portletFramework.postProjectCreated(newProject, frameworkName, portletName, monitor);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private void projectCreated(IProject project) {
        IFile ivyFile = project.getFile("ivy.xml");
        if (ivyFile.exists()) {
            try {
                String contents = CoreUtil.readStreamToString((InputStream)ivyFile.getContents());
                contents = contents.replace("${sdk.dir}/ivy.xml", "../../ivy.xml");
                ivyFile.setContents((InputStream)new ByteArrayInputStream(contents.toString().getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                ProjectCore.logError(e);
            }
        }
    }

    public ILiferayProject provide(Object type) {
        FlexibleProject retval;
        block12: {
            retval = null;
            if (type instanceof IProject) {
                IProject project = (IProject)type;
                try {
                    if (!SDKUtil.isSDKProject((IProject)project)) break block12;
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    boolean hasNewSdk = ClasspathUtil.hasNewLiferaySDKContainer(javaProject.getRawClasspath());
                    if (hasNewSdk) {
                        PortalBundle portalBundle = ServerUtil.getPortalBundle((IProject)project);
                        if (portalBundle != null) {
                            retval = new PluginsSDKBundleProject(project, portalBundle);
                        }
                    } else {
                        ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IProject)project);
                        if (liferayRuntime != null) {
                            retval = new PluginsSDKRuntimeProject(project, liferayRuntime);
                        }
                    }
                }
                catch (CoreException javaProject) {}
            } else if (type instanceof IRuntime) {
                try {
                    IRuntime runtime = (IRuntime)type;
                    ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IRuntime)runtime);
                    if (liferayRuntime != null) {
                        retval = new PluginsSDKRuntimeProject(null, liferayRuntime);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return retval;
    }

    private void serviceBuilderProjectCreated(NewLiferayPluginProjectOp op, String version, IProject newProject, IProgressMonitor monitor) throws CoreException {
        IFile serviceXmlFile = newProject.getFile("docroot/WEB-INF/service.xml");
        String descriptorVersion = null;
        try {
            Version portalVersion = new Version(version);
            descriptorVersion = String.valueOf(portalVersion.getMajor()) + "." + portalVersion.getMinor() + ".0";
        }
        catch (Exception e) {
            ProjectCore.logError("Could not determine liferay runtime version", e);
            descriptorVersion = "6.0.0";
        }
        WizardUtil.createDefaultServiceBuilderFile(serviceXmlFile, descriptorVersion, true, "com.liferay.sample", "SAMPLE", System.getProperty("user.name"), monitor);
    }

    private void themeProjectCreated(IProject newProject) throws CoreException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("force", "true");
        newProject.build(6, "com.liferay.ide.eclipse.theme.core.cssBuilder", args, null);
    }

    @Override
    public IStatus validateProjectLocation(String name, IPath path) {
        IStatus retval = Status.OK_STATUS;
        if (path.append(".project").toFile().exists()) {
            retval = ProjectCore.createErrorStatus("\"" + path + "\" is not valid because a project already exists at that location.");
        } else {
            File pathFile = path.toFile();
            if (pathFile.exists() && pathFile.isDirectory() && pathFile.listFiles().length > 0) {
                retval = ProjectCore.createErrorStatus("\"" + path + "\" is not valid because it already contains files.");
            }
        }
        return retval;
    }

    private static SDK getSDK(NewLiferayPluginProjectOp op) throws CoreException {
        IStatus sdkStatus;
        Path sdkLocation;
        IStatus sdkStatus2;
        boolean validateSDK = false;
        SDK sdk = SDKUtil.getWorkspaceSDK();
        if (sdk != null && (sdkStatus2 = sdk.validate()).isOK()) {
            validateSDK = true;
        }
        if (!validateSDK && (sdkLocation = (Path)op.getSdkLocation().content(true)) != null && (sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)sdkLocation))) != null && (sdkStatus = sdk.validate()).isOK()) {
            validateSDK = true;
        }
        if (sdk == null || !validateSDK) {
            throw new CoreException(ProjectCore.createErrorStatus("Can't get correct sdk."));
        }
        return sdk;
    }

    @Override
    public IStatus createNewProject(NewLiferayPluginProjectOp op, IProgressMonitor monitor) throws CoreException {
        ElementList<ProjectName> projectNames = op.getProjectNames();
        PluginType pluginType = (PluginType)((Object)op.getPluginType().content(true));
        String originalProjectName = (String)op.getProjectName().content();
        String pluginTypeSuffix = NewLiferayPluginProjectOpMethods.getPluginTypeSuffix(pluginType);
        String fixedProjectName = originalProjectName;
        if (originalProjectName.endsWith(pluginTypeSuffix)) {
            fixedProjectName = originalProjectName.substring(0, originalProjectName.length() - pluginTypeSuffix.length());
        }
        String projectName = fixedProjectName;
        String displayName = (String)op.getDisplayName().content(true);
        boolean separateJRE = true;
        SDK sdk = PluginsSDKProjectProvider.getSDK(op);
        String workingDir = null;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(projectName);
        arguments.add(displayName);
        boolean hasGradleTools = SDKUtil.hasGradleTools((IPath)sdk.getLocation());
        IPath newSDKProjectPath = null;
        switch (pluginType) {
            case servicebuilder: {
                op.setPortletFramework("mvc");
            }
            case portlet: {
                String frameworkName = NewLiferayPluginProjectOpMethods.getFrameworkName(op);
                workingDir = sdk.getLocation().append("portlets").toOSString();
                if (hasGradleTools) {
                    arguments.add(frameworkName);
                    sdk.createNewProject(projectName, arguments, "portlet", workingDir, monitor);
                    break;
                }
                newSDKProjectPath = sdk.createNewPortletProject(projectName, displayName, frameworkName, true, workingDir, null, monitor);
                break;
            }
            case hook: {
                workingDir = sdk.getLocation().append("hooks").toOSString();
                if (hasGradleTools) {
                    sdk.createNewProject(projectName, arguments, "hook", workingDir, monitor);
                    break;
                }
                newSDKProjectPath = sdk.createNewHookProject(projectName, displayName, true, workingDir, null, monitor);
                break;
            }
            case ext: {
                workingDir = sdk.getLocation().append("ext").toOSString();
                if (hasGradleTools) {
                    sdk.createNewProject(projectName, arguments, "ext", workingDir, monitor);
                    break;
                }
                newSDKProjectPath = sdk.createNewExtProject(projectName, displayName, true, workingDir, null, monitor);
                break;
            }
            case layouttpl: {
                workingDir = sdk.getLocation().append("layouttpl").toOSString();
                if (hasGradleTools) {
                    sdk.createNewProject(projectName, arguments, "layouttpl", workingDir, monitor);
                    break;
                }
                newSDKProjectPath = sdk.createNewLayoutTplProject(projectName, displayName, true, workingDir, null, monitor);
                break;
            }
            case theme: {
                workingDir = sdk.getLocation().append("themes").toOSString();
                if (hasGradleTools) {
                    sdk.createNewProject(projectName, arguments, "theme", workingDir, monitor);
                    break;
                }
                newSDKProjectPath = sdk.createNewThemeProject(projectName, displayName, true, workingDir, null, monitor);
                break;
            }
            case web: {
                workingDir = sdk.getLocation().append("webs").toOSString();
                if (hasGradleTools) {
                    sdk.createNewProject(projectName, arguments, "web", workingDir, monitor);
                    break;
                }
                newSDKProjectPath = sdk.createNewWebProject(projectName, displayName, true, workingDir, null, monitor);
            }
        }
        NewLiferayPluginProjectOpMethods.updateLocation(op);
        Path projectLocation = (Path)op.getLocation().content();
        if (!hasGradleTools) {
            File projectDir = projectLocation.toFile();
            File projectParent = projectDir.getParentFile();
            projectParent.mkdirs();
            File newSDKProjectDir = newSDKProjectPath.toFile();
            try {
                FileUtils.copyDirectory((File)newSDKProjectDir, (File)projectParent);
                FileUtils.deleteDirectory((File)newSDKProjectDir);
            }
            catch (IOException e) {
                throw new CoreException(ProjectCore.createErrorStatus(e));
            }
        }
        ProjectRecord projectRecord = ProjectUtil.getProjectRecordForDir(projectLocation.toOSString());
        IProject newProject = ProjectImportUtil.importProject(projectRecord.getProjectLocation(), monitor, op);
        newProject.open(monitor);
        op.setFinalProjectName(newProject.getName());
        ((ProjectName)projectNames.insert()).setName((String)op.getFinalProjectName().content());
        this.projectCreated(newProject);
        switch ((PluginType)((Object)op.getPluginType().content())) {
            case portlet: {
                this.portletProjectCreated(op, newProject, monitor);
                break;
            }
            case servicebuilder: {
                PortalBundle bundle = ServerUtil.getPortalBundle((IProject)newProject);
                this.serviceBuilderProjectCreated(op, bundle.getVersion(), newProject, monitor);
                break;
            }
            case theme: {
                this.themeProjectCreated(newProject);
                break;
            }
        }
        return Status.OK_STATUS;
    }
}

