/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.AbstractProjectBuilder;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.sdk.core.SDK;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.osgi.util.NLS;

public class SDKProjectBuilder
extends AbstractProjectBuilder {
    private SDK sdk;

    public SDKProjectBuilder(IProject project, SDK sdk) {
        super(project);
        this.sdk = sdk;
    }

    @Override
    public IStatus buildLang(IFile langFile, IProgressMonitor monitor) throws CoreException {
        IStatus status = this.sdk.validate();
        if (!status.isOK()) {
            return status;
        }
        return this.sdk.buildLanguage(this.getProject(), langFile, null, monitor);
    }

    @Override
    public IStatus buildService(IProgressMonitor monitor) throws CoreException {
        IFile servicesFile = this.getDocrootFile("WEB-INF/service.xml");
        if (servicesFile != null && servicesFile.exists()) {
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
            sub.beginTask(Msgs.buildingServices, 100);
            return this.buildService(servicesFile, (IProgressMonitor)sub);
        }
        return Status.OK_STATUS;
    }

    private IStatus buildService(IFile serviceXmlFile, IProgressMonitor monitor) throws CoreException {
        IStatus status = this.sdk.validate();
        if (!status.isOK()) {
            return status;
        }
        IStatus retval = this.sdk.buildService(this.getProject(), serviceXmlFile, null);
        try {
            this.getProject().refreshLocal(2, monitor);
        }
        catch (Exception e) {
            retval = ProjectCore.createErrorStatus(e);
        }
        ResourcesPlugin.getWorkspace().build(10, monitor);
        this.updateClasspath(this.getProject());
        this.getProject().refreshLocal(2, monitor);
        return retval;
    }

    @Override
    public IStatus buildWSDD(IProgressMonitor monitor) throws CoreException {
        IFile servicesFile = this.getDocrootFile("WEB-INF/service.xml");
        if (servicesFile != null && servicesFile.exists()) {
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
            sub.beginTask(Msgs.buildingServices, 100);
            return this.buildWSDD(servicesFile, (IProgressMonitor)sub);
        }
        return Status.OK_STATUS;
    }

    private IStatus buildWSDD(IFile serviceXmlFile, IProgressMonitor monitor) throws CoreException {
        IStatus status = this.sdk.validate();
        if (!status.isOK()) {
            return status;
        }
        IStatus retval = this.sdk.buildWSDD(this.getProject(), serviceXmlFile, null);
        try {
            this.getProject().refreshLocal(2, monitor);
        }
        catch (Exception e) {
            retval = ProjectCore.createErrorStatus(e);
        }
        this.getProject().build(10, monitor);
        try {
            this.getProject().refreshLocal(2, monitor);
        }
        catch (Exception e) {
            ProjectCore.logError(e);
        }
        return retval;
    }

    protected IStatus updateClasspath(IProject project) throws CoreException {
        IClasspathEntry[] webappEntries;
        FlexibleProjectContainer container = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer((IProject)project);
        if (container == null) {
            return Status.OK_STATUS;
        }
        container.refresh();
        container = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer((IProject)project);
        IClasspathEntry[] iClasspathEntryArray = webappEntries = container.getClasspathEntries();
        int n = webappEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry2 = iClasspathEntryArray[n2];
            if (entry2.getPath().lastSegment().equals(String.valueOf(this.getProject().getName()) + "-service.jar")) {
                ((ClasspathEntry)entry2).sourceAttachmentPath = this.getProject().getFolder("docroot/WEB-INF/service").getFullPath();
                break;
            }
            ++n2;
        }
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jst.j2ee.internal.web.container");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        initializer.requestClasspathContainerUpdate(container.getPath(), javaProject, (IClasspathContainer)container);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus execInitBundle(IProject project, String taskName, String bundleUrl, IProgressMonitor monitor) throws CoreException {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus updateProjectDependency(IProject project, List<String[]> dependency) throws CoreException {
        throw new CoreException(ProjectCore.createErrorStatus("Not implemented"));
    }

    protected static class Msgs
    extends NLS {
        public static String buildingServices;
        public static String buildingWSDD;

        static {
            Msgs.initializeMessages((String)SDKProjectBuilder.class.getName(), Msgs.class);
        }

        protected Msgs() {
        }
    }
}

