/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.ResourceFilterUtil;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;

public class SDKProjectDeleteListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() == 4) {
                IProject project = (IProject)event.getResource();
                if (SDKUtil.isSDKProject((IProject)project)) {
                    String parentName = project.getLocation().toFile().getParentFile().getName();
                    IProject sdkProject = SDKUtil.getWorkspaceSDKProject();
                    if (sdkProject != null && sdkProject.exists()) {
                        IFolder parentFolder = sdkProject.getFolder(parentName);
                        ResourceFilterUtil.deleteResourceFilter(parentFolder, project.getName());
                    }
                }
                return;
            }
        }
        catch (Exception e) {
            ProjectCore.logError("delete project resource filter error", e);
        }
    }
}

