/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ValidationPreferences {
    public static final String LIFERAY_DISPLAY_XML_TYPE_HIERARCHY_INCORRECT = "liferay-display-xml-type-hierarchy-incorrect";
    public static final String LIFERAY_DISPLAY_XML_TYPE_NOT_FOUND = "liferay-display-xml-type-not-found";
    public static final String LIFERAY_DISPLAY_XML_REFERENCE_NOT_FOUND = "liferay-display-xml-reference-not-found";
    public static final String LIFERAY_DISPLAY_XML_RESOURCE_NOT_FOUND = "liferay-display-xml-resource-not-found";
    public static final String LIFERAY_DISPLAY_XML_SYNTAX_INVALID = "liferay-display-xml-syntax-invalid";
    public static final String LIFERAY_HOOK_XML_TYPE_HIERARCHY_INCORRECT = "liferay-hook-xml-type-hierarchy-incorrect";
    public static final String LIFERAY_HOOK_XML_TYPE_NOT_FOUND = "liferay-hook-xml-type-not-found";
    public static final String LIFERAY_HOOK_XML_REFERENCE_NOT_FOUND = "liferay-hook-xml-reference-not-found";
    public static final String LIFERAY_HOOK_XML_RESOURCE_NOT_FOUND = "liferay-hook-xml-resource-not-found";
    public static final String LIFERAY_HOOK_XML_SYNTAX_INVALID = "liferay-hook-xml-syntax-invalid";
    public static final String LIFERAY_LAYOUTTPL_XML_TYPE_HIERARCHY_INCORRECT = "liferay-layout-templates-xml-type-hierarchy-incorrect";
    public static final String LIFERAY_LAYOUTTPL_XML_TYPE_NOT_FOUND = "liferay-layout-templates-xml-type-not-found";
    public static final String LIFERAY_LAYOUTTPL_XML_REFERENCE_NOT_FOUND = "liferay-layout-templates-xml-reference-not-found";
    public static final String LIFERAY_LAYOUTTPL_XML_RESOURCE_NOT_FOUND = "liferay-layout-templates-xml-resource-not-found";
    public static final String LIFERAY_LAYOUTTPL_XML_SYNTAX_INVALID = "liferay-layout-templates-xml-syntax-invalid";
    public static final String LIFERAY_PORTLET_XML_TYPE_HIERARCHY_INCORRECT = "liferay-portlet-xml-type-hierarchy-incorrect";
    public static final String LIFERAY_PORTLET_XML_TYPE_NOT_FOUND = "liferay-portlet-xml-type-not-found";
    public static final String LIFERAY_PORTLET_XML_REFERENCE_NOT_FOUND = "liferay-portlet-xml-reference-not-found";
    public static final String LIFERAY_PORTLET_XML_RESOURCE_NOT_FOUND = "liferay-portlet-xml-resource-not-found";
    public static final String LIFERAY_PORTLET_XML_SYNTAX_INVALID = "liferay-portlet-xml-syntax-invalid";
    public static final String PORTLET_XML_TYPE_HIERARCHY_INCORRECT = "portlet-xml-type-hierarchy-incorrect";
    public static final String PORTLET_XML_TYPE_NOT_FOUND = "portlet-xml-type-not-found";
    public static final String PORTLET_XML_REFERENCE_NOT_FOUND = "portlet-xml-reference-not-found";
    public static final String PORTLET_XML_RESOURCE_NOT_FOUND = "portlet-xml-resource-not-found";
    public static final String PORTLET_XML_SYNTAX_INVALID = "portlet-xml-syntax-invalid";
    public static final String SERVICE_XML_TYPE_HIERARCHY_INCORRECT = "service-xml-type-hierarchy-incorrect";
    public static final String SERVICE_XML_TYPE_NOT_FOUND = "service-xml-type-not-found";
    public static final String SERVICE_XML_REFERENCE_NOT_FOUND = "service-xml-reference-not-found";
    public static final String SERVICE_XML_RESOURCE_NOT_FOUND = "service-xml-resource-not-found";
    public static final String SERVICE_XML_SYNTAX_INVALID = "service-xml-syntax-invalid";
    public static final String LIFERAY_JSP_METHOD_NOT_FOUND = "liferay-jsp-method-not-found";
    public static final String LIFERAY_JSP_PROPERTY_NOT_FOUND = "liferay-jsp--property-not-found";
    public static final String LIFERAY_JSP_REFERENCE_NOT_FOUND = "liferay-jsp-reference-not-found";
    public static final String LIFERAY_JSP_RESOURCE_NOT_FOUND = "liferya-jsp-resource-not-found";
    public static final String LIFERAY_JSP_STATIC_VALUE_UNDEFINED = "liferay-jsp-static-value-undefined";
    public static final String LIFERAY_JSP_SYNTAX_INVALID = "liferay-jsp-syntax-value_invalid";
    public static final String LIFERAY_JSP_TYPE_NOT_FOUND = "liferay-jsp-type-not-found";
    public static final String LIFERAY_JSP_TYPE_HIERARCHY_INCORRECT = "liferay-jsp-hierarchy-incorrect";
    private static Set<String> preferenceKeys = new HashSet<String>();

    static {
        preferenceKeys.add(LIFERAY_DISPLAY_XML_TYPE_HIERARCHY_INCORRECT);
        preferenceKeys.add(LIFERAY_DISPLAY_XML_TYPE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_DISPLAY_XML_REFERENCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_DISPLAY_XML_RESOURCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_DISPLAY_XML_SYNTAX_INVALID);
        preferenceKeys.add(LIFERAY_HOOK_XML_TYPE_HIERARCHY_INCORRECT);
        preferenceKeys.add(LIFERAY_HOOK_XML_TYPE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_HOOK_XML_REFERENCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_HOOK_XML_RESOURCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_HOOK_XML_SYNTAX_INVALID);
        preferenceKeys.add(LIFERAY_LAYOUTTPL_XML_TYPE_HIERARCHY_INCORRECT);
        preferenceKeys.add(LIFERAY_LAYOUTTPL_XML_TYPE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_LAYOUTTPL_XML_REFERENCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_LAYOUTTPL_XML_RESOURCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_LAYOUTTPL_XML_SYNTAX_INVALID);
        preferenceKeys.add(LIFERAY_PORTLET_XML_TYPE_HIERARCHY_INCORRECT);
        preferenceKeys.add(LIFERAY_PORTLET_XML_TYPE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_PORTLET_XML_REFERENCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_PORTLET_XML_RESOURCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_PORTLET_XML_SYNTAX_INVALID);
        preferenceKeys.add(PORTLET_XML_TYPE_HIERARCHY_INCORRECT);
        preferenceKeys.add(PORTLET_XML_TYPE_NOT_FOUND);
        preferenceKeys.add(PORTLET_XML_REFERENCE_NOT_FOUND);
        preferenceKeys.add(PORTLET_XML_RESOURCE_NOT_FOUND);
        preferenceKeys.add(PORTLET_XML_SYNTAX_INVALID);
        preferenceKeys.add(SERVICE_XML_TYPE_HIERARCHY_INCORRECT);
        preferenceKeys.add(SERVICE_XML_TYPE_NOT_FOUND);
        preferenceKeys.add(SERVICE_XML_REFERENCE_NOT_FOUND);
        preferenceKeys.add(SERVICE_XML_RESOURCE_NOT_FOUND);
        preferenceKeys.add(SERVICE_XML_SYNTAX_INVALID);
        preferenceKeys.add(LIFERAY_JSP_METHOD_NOT_FOUND);
        preferenceKeys.add(LIFERAY_JSP_PROPERTY_NOT_FOUND);
        preferenceKeys.add(LIFERAY_JSP_REFERENCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_JSP_RESOURCE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_JSP_STATIC_VALUE_UNDEFINED);
        preferenceKeys.add(LIFERAY_JSP_SYNTAX_INVALID);
        preferenceKeys.add(LIFERAY_JSP_TYPE_NOT_FOUND);
        preferenceKeys.add(LIFERAY_JSP_TYPE_HIERARCHY_INCORRECT);
    }

    public static boolean containsKey(String liferayPluginValidationType) {
        return preferenceKeys.contains(liferayPluginValidationType);
    }

    public static String getValidationPreferenceKey(String descriptorFileName, ValidationType type) {
        StringBuilder retval = new StringBuilder();
        if (!CoreUtil.isNullOrEmpty((String)descriptorFileName)) {
            retval.append(descriptorFileName.replace(".", "-").toLowerCase());
            retval.append("-");
        }
        if (type != null) {
            retval.append(type.toString().toLowerCase().replace("_", "-"));
        }
        return retval.toString();
    }

    public static void setInstanceScopeValidationLevel(String liferayPluginValidationType, int validationLevel) {
        if (preferenceKeys.contains(liferayPluginValidationType) && (validationLevel == -1 || validationLevel == 1 || validationLevel == 2)) {
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("com.liferay.ide.project.core");
            node.putInt(liferayPluginValidationType, validationLevel);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ProjectCore.logError("Error setting validation preferences", (Exception)((Object)e));
            }
        }
    }

    public static void setProjectScopeValidationLevel(IProject project, String liferayPluginValidationType, int validationLevel) {
        IEclipsePreferences node = new ProjectScope(project).getNode("com.liferay.ide.project.core");
        if (preferenceKeys.contains(liferayPluginValidationType) && (validationLevel == -1 || validationLevel == 1 || validationLevel == 2)) {
            node.putBoolean("use-project-settings", true);
            node.putInt(liferayPluginValidationType, validationLevel);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ProjectCore.logError("Error setting validation preferences", (Exception)((Object)e));
            }
        }
    }

    public static enum ValidationType {
        METHOD_NOT_FOUND,
        PROPERTY_NOT_FOUND,
        REFERENCE_NOT_FOUND,
        RESOURCE_NOT_FOUND,
        STATIC_VALUE_UNDEFINED,
        SYNTAX_INVALID,
        TYPE_NOT_FOUND,
        TYPE_HIERARCHY_INCORRECT;

    }
}

