/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import java.util.Set;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class NewLiferayProfileIdValidationService
extends ValidationService {
    private Set<String> existingValues;

    protected void initValidationService() {
        super.initValidationService();
        this.existingValues = NewLiferayPluginProjectOpMethods.getPossibleProfileIds((NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class), false);
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        NewLiferayProfile newLiferayProfile = this.profile();
        String profileId = (String)newLiferayProfile.getId().content(true);
        if (profileId == null || profileId.isEmpty()) {
            retval = Status.createErrorStatus((String)"Profile id can not be empty.");
        } else if (profileId.contains(" ")) {
            retval = Status.createErrorStatus((String)"No spaces are allowed in profile id.");
        }
        if (!this.existingValues.isEmpty()) {
            for (String val : this.existingValues) {
                if (val == null || !val.equals(profileId)) continue;
                retval = Status.createErrorStatus((String)"Profile already exists.");
                break;
            }
        }
        return retval;
    }

    private NewLiferayProfile profile() {
        return (NewLiferayProfile)this.context(NewLiferayProfile.class);
    }
}

