/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.modules.BaseModuleOp;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.ExecutableElement;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public abstract class AbstractProjectLocationValidationService<T extends ExecutableElement>
extends ValidationService {
    private Listener listener;

    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        String currentProjectName = (String)this.op().getProjectName().content();
        org.eclipse.sapphire.modeling.Path currentProjectLocation = (org.eclipse.sapphire.modeling.Path)this.op().getLocation().content();
        Boolean userDefaultLocation = (Boolean)this.op().getUseDefaultLocation().content();
        if (!userDefaultLocation.booleanValue() && currentProjectName != null) {
            if (currentProjectLocation != null) {
                String currentPath = currentProjectLocation.toOSString();
                if (!Path.EMPTY.isValidPath(currentPath)) {
                    retval = Status.createErrorStatus((String)("\"" + currentPath + "\" is not a valid path."));
                } else {
                    IPath osPath = Path.fromOSString((String)currentPath);
                    if (!osPath.toFile().isAbsolute()) {
                        retval = Status.createErrorStatus((String)("\"" + currentPath + "\" is not an absolute path."));
                    } else {
                        IStatus locationStatus;
                        if (!osPath.toFile().exists() && !this.canCreate(osPath.toFile())) {
                            retval = Status.createErrorStatus((String)("Cannot create project content at \"" + currentPath + "\""));
                        }
                        if (!(locationStatus = ((NewLiferayProjectProvider)this.op().getProjectProvider().content()).validateProjectLocation(currentProjectName, osPath)).isOK()) {
                            retval = Status.createErrorStatus((String)locationStatus.getMessage());
                        }
                    }
                }
            } else {
                retval = Status.createErrorStatus((String)"Location must be specified.");
            }
        }
        return retval;
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.op().detach(this.listener);
            this.listener = null;
        }
    }

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                AbstractProjectLocationValidationService.this.refresh();
            }
        };
        this.op().getProjectName().attach(this.listener);
        this.op().getProjectProvider().attach(this.listener);
    }

    protected abstract BaseModuleOp op();
}

