/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.IComponentTemplate;
import com.liferay.ide.project.core.modules.NewLiferayComponentOp;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;

public class NewLiferayComponentOpMethods {
    public static void createNewComponent(NewLiferayComponentOp op, IProgressMonitor monitor) throws CoreException {
        IComponentTemplate componentOp = (IComponentTemplate)op.getComponentClassTemplateName().content(true);
        if (componentOp != null) {
            componentOp.doExecute(op, monitor);
        }
    }

    public static final Status execute(NewLiferayComponentOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating new Liferay component", 100);
        Status retval = Status.createOkStatus();
        try {
            String projectName = (String)op.getProjectName().content(true);
            IProject project = CoreUtil.getProject((String)projectName);
            if (project == null) {
                return Status.createErrorStatus((String)" Can't find valid project.");
            }
            NewLiferayComponentOpMethods.createNewComponent(op, monitor);
        }
        catch (Exception e) {
            String msg = "Error creating Liferay component.";
            ProjectCore.logError("Error creating Liferay component.", e);
            return Status.createErrorStatus((String)"Error creating Liferay component. Please see Eclipse error log for more details.", (Throwable)e);
        }
        return retval;
    }
}

