/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import aQute.remote.api.Agent;
import com.liferay.ide.project.core.modules.ServiceContainer;
import com.liferay.ide.project.core.util.TargetPlatformUtil;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import com.liferay.ide.server.core.portal.PortalServerBehavior;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wst.server.core.IServer;

public class ServiceCommand {
    private final IServer _server;
    private String _serviceName;
    private static final String[] _portalImplExpPackage = new String[]{"com.liferay.portal.bean", "com.liferay.portal.cache.thread.local", "com.liferay.portal.cluster", "com.liferay.portal.convert.database", "com.liferay.portal.convert.util", "com.liferay.portal.dao.jdbc.aop", "com.liferay.portal.dao.orm.hibernate", "com.liferay.portal.deploy.hot", "com.liferay.portal.events", "com.liferay.portal.freemarker", "com.liferay.portal.increment", "com.liferay.portal.messaging.async", "com.liferay.portal.monitoring.statistics.service", "com.liferay.portal.plugin", "com.liferay.portal.resiliency.service", "com.liferay.portal.search", "com.liferay.portal.security.access.control", "com.liferay.portal.security.auth", "com.liferay.portal.security.lang", "com.liferay.portal.service.http", "com.liferay.portal.service.permission", "com.liferay.portal.servlet", "com.liferay.portal.spring.aop", "com.liferay.portal.spring.bean", "com.liferay.portal.spring.context", "com.liferay.portal.spring.hibernate", "com.liferay.portal.spring.transaction", "com.liferay.portal.systemevent", "com.liferay.portal.template", "com.liferay.portal.tools", "com.liferay.portal.upgrade.util", "com.liferay.portal.upgrade.v7_0_0", "com.liferay.portal.upload", "com.liferay.portal.util", "com.liferay.portal.xml", "com.liferay.portlet.asset", "com.liferay.portlet.documentlibrary", "com.liferay.portlet.expando.model", "com.liferay.portlet.expando.service", "com.liferay.portlet.expando.util", "com.liferay.portlet.layoutsadmin.display.context", "com.liferay.portlet.messageboards.model", "com.liferay.portlet.messageboards.service", "com.liferay.portlet.social.model", "com.liferay.portlet.social.service", "com.liferay.portlet.trash", "com.liferay.portlet.usersadmin.search"};

    public ServiceCommand(IServer server) {
        this._server = server;
    }

    public ServiceCommand(IServer server, String serviceName) {
        this._serviceName = serviceName;
        this._server = server;
    }

    public ServiceContainer execute() throws Exception {
        ServiceContainer result;
        BundleSupervisor supervisor = null;
        if (this._server == null) {
            return this.getServiceFromTargetPlatform();
        }
        try {
            PortalServerBehavior serverBehavior = (PortalServerBehavior)this._server.loadAdapter(PortalServerBehavior.class, null);
            supervisor = serverBehavior.createBundleSupervisor();
            if (supervisor == null) {
                ServiceContainer serviceContainer = this.getServiceFromTargetPlatform();
                return serviceContainer;
            }
            if (!((Agent)supervisor.getAgent()).redirect(-1)) {
                ServiceContainer serviceContainer = this.getServiceFromTargetPlatform();
                return serviceContainer;
            }
            if (this._serviceName == null) {
                String[] services = this.getServices(supervisor);
                result = new ServiceContainer(Arrays.asList(services));
            } else {
                String[] serviceBundle = this.getServiceBundle(this._serviceName, supervisor);
                result = new ServiceContainer(serviceBundle[0], serviceBundle[1], serviceBundle[2]);
            }
        }
        finally {
            if (supervisor != null) {
                ((Agent)supervisor.getAgent()).redirect(0);
                supervisor.close();
            }
        }
        return result;
    }

    private ServiceContainer getServiceFromTargetPlatform() throws Exception {
        ServiceContainer result = this._serviceName == null ? TargetPlatformUtil.getServicesList() : TargetPlatformUtil.getServiceBundle(this._serviceName);
        return result;
    }

    private String[] getServiceBundle(String serviceName, BundleSupervisor supervisor) throws Exception {
        String[] serviceBundleInfo;
        String bundleGroup = "";
        ((Agent)supervisor.getAgent()).stdin("packages " + serviceName.substring(0, serviceName.lastIndexOf(".")));
        if (supervisor.getOutInfo().startsWith("No exported packages")) {
            ((Agent)supervisor.getAgent()).stdin("services (objectClass=" + serviceName + ")" + " | grep \"Registered by bundle:\" ");
            serviceBundleInfo = this.parseRegisteredBundle(supervisor.getOutInfo());
        } else {
            serviceBundleInfo = this.parseSymbolicName(supervisor.getOutInfo());
        }
        String bundleName = serviceBundleInfo[0];
        String bundleVersion = serviceBundleInfo[1];
        if (bundleName.equals("org.eclipse.osgi,system.bundle")) {
            bundleGroup = "com.liferay.portal";
        } else if (bundleName.startsWith("com.liferay")) {
            bundleGroup = "com.liferay";
        } else {
            int ordinalIndexOf = StringUtils.ordinalIndexOf((String)bundleName, (String)".", (int)3);
            if (ordinalIndexOf != -1) {
                bundleGroup = bundleName.substring(0, ordinalIndexOf);
            } else {
                ordinalIndexOf = StringUtils.ordinalIndexOf((String)bundleName, (String)".", (int)2);
                if (ordinalIndexOf != -1) {
                    bundleGroup = bundleName.substring(0, ordinalIndexOf);
                }
            }
        }
        return new String[]{bundleGroup, bundleName, bundleVersion};
    }

    private String[] getServices(BundleSupervisor supervisor) throws Exception {
        ((Agent)supervisor.getAgent()).stdin("services");
        return this.parseService(supervisor.getOutInfo());
    }

    private String[] parseRegisteredBundle(String serviceName) {
        if (serviceName.startsWith("false")) {
            return null;
        }
        String str = serviceName.substring(0, serviceName.indexOf("["));
        String[] result = (str = str.replaceAll("\"Registered by bundle:\"", "").trim()).split("_");
        if (result.length == 2) {
            return result;
        }
        return null;
    }

    private String[] parseService(String outinfo) {
        Pattern pattern = Pattern.compile("(?<=\\{)(.+?)(?=\\})");
        Matcher matcher = pattern.matcher(outinfo);
        ArrayList<String> ls = new ArrayList<String>();
        while (matcher.find()) {
            ls.add(matcher.group());
        }
        Iterator iterator = ls.iterator();
        while (iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            if (!serviceName.contains("bundle.id=") && !serviceName.contains("service.id=") && !serviceName.contains("=")) continue;
            iterator.remove();
        }
        ArrayList<String> listservice = new ArrayList<String>();
        for (String bs : ls) {
            if (bs.split(",").length > 1) {
                String[] stringArray = bs.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String bbs = stringArray[n2];
                    listservice.add(bbs.trim());
                    ++n2;
                }
                continue;
            }
            listservice.add(bs);
        }
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> newList = new ArrayList<String>();
        for (String element : listservice) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        Collections.sort(newList);
        Iterator newListIterator = newList.iterator();
        block5: while (newListIterator.hasNext()) {
            String serviceName = (String)newListIterator.next();
            String[] stringArray = _portalImplExpPackage;
            int n = _portalImplExpPackage.length;
            int n3 = 0;
            while (n3 < n) {
                String packageName = stringArray[n3];
                if (serviceName.startsWith(packageName)) {
                    newListIterator.remove();
                    continue block5;
                }
                ++n3;
            }
        }
        return newList.toArray(new String[0]);
    }

    private String[] parseSymbolicName(String info) {
        int symbolicIndex = info.indexOf("bundle-symbolic-name");
        int versionIndex = info.indexOf("version:Version");
        if (symbolicIndex != -1 && versionIndex != -1) {
            String symbolicName = info.substring(symbolicIndex, info.indexOf(";", symbolicIndex));
            String version = info.substring(versionIndex, info.indexOf(";", versionIndex));
            Pattern p = Pattern.compile("\"([^\"]*)\"");
            Matcher m = p.matcher(symbolicName);
            while (m.find()) {
                symbolicName = m.group(1);
            }
            m = p.matcher(version);
            while (m.find()) {
                version = m.group(1);
            }
            return new String[]{symbolicName, version};
        }
        return null;
    }
}

