/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.ServiceContainer;
import com.liferay.ide.project.core.util.TargetPlatformUtil;
import com.liferay.ide.server.core.portal.PortalRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;

public class ServiceWrapperCommand {
    private final IServer _server;
    private String _serviceWrapperName;

    public ServiceWrapperCommand(IServer server) {
        this._server = server;
    }

    public ServiceWrapperCommand(IServer _server, String _serviceWrapperName) {
        this._server = _server;
        this._serviceWrapperName = _serviceWrapperName;
    }

    public ServiceContainer execute() throws Exception {
        ServiceContainer result;
        if (this._server == null) {
            return this.getServiceWrapperFromTargetPlatform();
        }
        Map<String, String[]> dynamicServiceWrappers = this.getDynamicServiceWrapper();
        if (this._serviceWrapperName == null) {
            result = new ServiceContainer(Arrays.asList(dynamicServiceWrappers.keySet().toArray(new String[0])));
        } else {
            String[] wrapperBundle = dynamicServiceWrappers.get(this._serviceWrapperName);
            result = new ServiceContainer(wrapperBundle[0], wrapperBundle[1], wrapperBundle[2]);
        }
        return result;
    }

    private File checkStaticWrapperFile() throws IOException {
        URL url = FileLocator.toFileURL((URL)ProjectCore.getDefault().getBundle().getEntry("OSGI-INF/wrappers-static.json"));
        File servicesFile = new File(url.getFile());
        if (servicesFile.exists()) {
            return servicesFile;
        }
        throw new FileNotFoundException("can't find static services file wrappers-static.json");
    }

    private Map<String, String[]> getDynamicServiceWrapper() throws IOException {
        LinkedHashMap<String, String[]> map;
        block37: {
            IPath bundleLibPath = ((PortalRuntime)this._server.getRuntime().loadAdapter(PortalRuntime.class, null)).getAppServerLibGlobalDir();
            IPath bundleServerPath = ((PortalRuntime)this._server.getRuntime().loadAdapter(PortalRuntime.class, null)).getAppServerDir();
            map = new LinkedHashMap<String, String[]>();
            File portalkernelJar = null;
            try {
                List libFiles = FileListing.getFileListing((File)new File(bundleLibPath.toOSString()));
                for (File lib : libFiles) {
                    if (!lib.exists() || !lib.getName().endsWith("portal-kernel.jar")) continue;
                    portalkernelJar = lib;
                    break;
                }
                libFiles = FileListing.getFileListing((File)new File(bundleServerPath.append("../osgi").toOSString()));
                libFiles.add(portalkernelJar);
                if (libFiles.isEmpty()) break block37;
                for (File lib : libFiles) {
                    String name;
                    JarEntry entry2;
                    Throwable throwable;
                    if (lib.getName().endsWith(".lpkg")) {
                        Throwable throwable2 = null;
                        throwable = null;
                        try (JarFile jar = new JarFile(lib);){
                            Enumeration<JarEntry> enu = jar.entries();
                            while (enu.hasMoreElements()) {
                                ZipInputStream jarInputStream = null;
                                try {
                                    try {
                                        entry2 = enu.nextElement();
                                        name = entry2.getName();
                                        if (name.contains(".api-")) {
                                            JarEntry nextJarEntry;
                                            JarEntry jarentry = jar.getJarEntry(name);
                                            InputStream inputStream = jar.getInputStream(jarentry);
                                            jarInputStream = new JarInputStream(inputStream);
                                            while ((nextJarEntry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                                                String entryName = nextJarEntry.getName();
                                                this.getServiceWrapperList(map, entryName, (JarInputStream)jarInputStream);
                                            }
                                        }
                                    }
                                    catch (Exception entry2) {
                                        if (jarInputStream == null) continue;
                                        jarInputStream.close();
                                        continue;
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (jarInputStream != null) {
                                        jarInputStream.close();
                                    }
                                    throw throwable3;
                                }
                                if (jarInputStream == null) continue;
                                jarInputStream.close();
                            }
                            continue;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                    if (!lib.getName().endsWith("api.jar") && !lib.getName().equals("portal-kernel.jar")) continue;
                    ZipInputStream jarinput = null;
                    try {
                        try {
                            throwable = null;
                            Object var10_15 = null;
                            try (JarFile jar = new JarFile(lib);){
                                jarinput = new JarInputStream(new FileInputStream(lib));
                                Enumeration<JarEntry> enu = jar.entries();
                                while (enu.hasMoreElements()) {
                                    entry2 = enu.nextElement();
                                    name = entry2.getName();
                                    this.getServiceWrapperList(map, name, (JarInputStream)jarinput);
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                } else if (throwable != throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException iOException) {
                            if (jarinput == null) continue;
                            jarinput.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (jarinput != null) {
                            jarinput.close();
                        }
                        throw throwable6;
                    }
                    if (jarinput == null) continue;
                    jarinput.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return map;
    }

    private void getServiceWrapperList(Map<String, String[]> wrapperMap, String name, JarInputStream jarInputStream) {
        if (name.endsWith("ServiceWrapper.class") && !name.contains("$")) {
            name = name.replaceAll("\\\\", ".").replaceAll("/", ".");
            name = name.substring(0, name.lastIndexOf("."));
            Attributes mainAttributes = jarInputStream.getManifest().getMainAttributes();
            String bundleName = mainAttributes.getValue("Bundle-SymbolicName");
            String version = mainAttributes.getValue("Bundle-Version");
            String group = "";
            if (bundleName.equals("com.liferay.portal.kernel")) {
                group = "com.liferay.portal";
            } else {
                int ordinalIndexOf = StringUtils.ordinalIndexOf((String)bundleName, (String)".", (int)2);
                if (ordinalIndexOf != -1) {
                    group = bundleName.substring(0, ordinalIndexOf);
                }
            }
            wrapperMap.put(name, new String[]{group, bundleName, version});
        }
    }

    private ServiceContainer getServiceWrapperFromTargetPlatform() throws Exception {
        ServiceContainer result = this._serviceWrapperName == null ? TargetPlatformUtil.getServiceWrapperList() : TargetPlatformUtil.getServiceWrapperBundle(this._serviceWrapperName);
        return result;
    }

    private void updateServiceWrapperStaticFile(final Map<String, String[]> wrappers) throws Exception {
        final File wrappersFile = this.checkStaticWrapperFile();
        final ObjectMapper mapper = new ObjectMapper();
        WorkspaceJob job = new WorkspaceJob("Update ServiceWrapper static file..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    mapper.writeValue(wrappersFile, (Object)wrappers);
                }
                catch (IOException e) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

