/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.fragment;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.core.util.ZipUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.fragment.NewModuleFragmentFilesOp;
import com.liferay.ide.project.core.modules.fragment.OverrideFilePath;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.wst.server.core.IRuntime;

public class NewModuleFragmentFilesOpMethods {
    public static final Status execute(NewModuleFragmentFilesOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Copy files (this process may take several minutes)", 100);
        String projectName = (String)op.getProjectName().content();
        IProject project = CoreUtil.getProject((String)projectName);
        Status retval = null;
        try {
            String hostBundleName = (String)op.getHostOsgiBundle().content();
            IPath temp = ProjectCore.getDefault().getStateLocation().append(hostBundleName);
            if (!temp.toFile().exists()) {
                IRuntime runtime = ServerUtil.getRuntime((String)((String)op.getLiferayRuntimeName().content()));
                PortalBundle portalBundle = LiferayServerCore.newPortalBundle((IPath)runtime.getLocation());
                File hostBundle = portalBundle.getOSGiBundlesDir().append("modules").append(String.valueOf(hostBundleName) + ".jar").toFile();
                if (!hostBundle.exists()) {
                    hostBundle = ProjectCore.getDefault().getStateLocation().append(String.valueOf(hostBundleName) + ".jar").toFile();
                }
                try {
                    ZipUtil.unzip((File)hostBundle, (File)temp.toFile());
                }
                catch (IOException e) {
                    throw new CoreException(ProjectCore.createErrorStatus(e));
                }
            }
            ElementList<OverrideFilePath> files = op.getOverrideFiles();
            for (OverrideFilePath file : files) {
                IPath resources;
                String metaInfResources;
                String parent;
                File fragmentFile = temp.append((String)file.getValue().content()).toFile();
                if (!fragmentFile.exists()) continue;
                File folder = null;
                if (fragmentFile.getName().equals("portlet.properties")) {
                    folder = project.getLocation().append("src/main/java").toFile();
                    FileUtil.copyFileToDir((File)fragmentFile, (String)"portlet-ext.properties", (File)folder);
                    continue;
                }
                if (fragmentFile.getName().contains("default.xml")) {
                    parent = fragmentFile.getPath();
                    parent = parent.replaceAll("\\\\", "/");
                    metaInfResources = "resource-actions";
                    parent = parent.substring(parent.indexOf(metaInfResources) + metaInfResources.length());
                    resources = project.getLocation().append("src/main/resources/resource-actions");
                    folder = resources.toFile();
                    folder.mkdirs();
                    FileUtil.copyFileToDir((File)fragmentFile, (String)"default-ext.xml", (File)folder);
                    try {
                        File ext = new File(project.getLocation().append("src/main/resources") + "/portlet-ext.properties");
                        ext.createNewFile();
                        String extFileContent = "resource.actions.configs=resource-actions/default.xml,resource-actions/default-ext.xml";
                        FileUtil.writeFile((File)ext, (String)extFileContent, null);
                        continue;
                    }
                    catch (Exception e) {
                        throw new CoreException(ProjectCore.createErrorStatus(e));
                    }
                }
                parent = fragmentFile.getParentFile().getPath();
                parent = parent.replaceAll("\\\\", "/");
                metaInfResources = "META-INF/resources";
                parent = parent.substring(parent.indexOf(metaInfResources) + metaInfResources.length());
                resources = project.getLocation().append("src/main/resources/META-INF/resources");
                folder = resources.toFile();
                folder.mkdirs();
                if (!parent.equals("resources") && !parent.equals("")) {
                    folder = resources.append(parent).toFile();
                    folder.mkdirs();
                }
                FileUtil.copyFileToDir((File)fragmentFile, (File)folder);
            }
            project.refreshLocal(2, null);
            retval = Status.createOkStatus();
        }
        catch (Exception e) {
            String msg = "Error copy files.";
            ProjectCore.logError("Error copy files.", e);
            return Status.createErrorStatus((String)"Error copy files. Please see Eclipse error log for more details.", (Throwable)e);
        }
        return retval;
    }
}

