/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.templates.mvcportlet;

import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.templates.AbstractLiferayComponentTemplate;
import com.liferay.ide.project.core.modules.templates.BndProperties;
import com.liferay.ide.project.core.modules.templates.BndPropertiesValue;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class NewLiferayComponentMVCPortletOperation
extends AbstractLiferayComponentTemplate {
    private static final String TEMPLATE_FILE = "mvcportlet/mvcportlet.ftl";
    private static final String SUPER_CLASS = "MVCPortlet";
    private static final String EXTENSION_CLASS = "Portlet.class";
    private static final String[] PROPERTIES_LIST = new String[]{"com.liferay.portlet.display-category=category.sample", "com.liferay.portlet.instanceable=true", "javax.portlet.init-param.template-path=/", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user"};

    @Override
    protected void doMergeResourcesOperation() throws CoreException {
        try {
            IFile viewJsp;
            IFolder resourceFolder = this.liferayProject.getSourceFolder("resources");
            IFolder contentFolder = resourceFolder.getFolder("content");
            IFile languageProperties = contentFolder.getFile((IPath)new Path("Language.properties"));
            File languagePropertiesFile = languageProperties.getLocation().toFile();
            if (languagePropertiesFile.exists()) {
                String originContent = FileUtil.readContents((File)languagePropertiesFile, (boolean)true);
                URL sampleFileURL = this.getClass().getClassLoader().getResource("com/liferay/ide/project/core/modules/templates/mvcportlet/mvc-language.properties");
                String addContent = FileUtil.readContents((File)new File(FileLocator.toFileURL((URL)sampleFileURL).getFile()), (boolean)true);
                String totalContent = String.valueOf(originContent) + System.getProperty("line.separator") + addContent;
                FileUtil.writeFile((File)languagePropertiesFile, (byte[])totalContent.getBytes(), (String)this.projectName);
            } else {
                this.createSampleFile(languageProperties, "mvcportlet/mvc-language.properties");
            }
            IFolder metaFolder = resourceFolder.getFolder("META-INF/resources");
            IFile initJsp = metaFolder.getFile((IPath)new Path(String.valueOf(this.componentClassName.toLowerCase()) + "/init.jsp"));
            if (!initJsp.getLocation().toFile().exists()) {
                this.createSampleFile(initJsp, "mvcportlet/mvc-init.jsp");
            }
            if (!(viewJsp = metaFolder.getFile((IPath)new Path(String.valueOf(this.componentClassName.toLowerCase()) + "/view.jsp"))).getLocation().toFile().exists()) {
                this.createSampleFile(viewJsp, "mvcportlet/mvc-view.jsp", "/init.jsp", "/" + this.componentClassName.toLowerCase() + "/init.jsp");
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    @Override
    protected List<String[]> getComponentDependency() throws CoreException {
        List<String[]> componentDependency = super.getComponentDependency();
        componentDependency.add(new String[]{"javax.portlet", "portlet-api", "2.0"});
        return componentDependency;
    }

    @Override
    protected void setBndProperties(BndProperties bndProperty) {
        bndProperty.addValue("-jsp", new BndPropertiesValue("*.jsp,*.jspf"));
        bndProperty.addValue("-plugin.bundle", new BndPropertiesValue("com.liferay.ant.bnd.resource.bundle.ResourceBundleLoaderAnalyzerPlugin"));
        bndProperty.addValue("-plugin.jsp", new BndPropertiesValue("com.liferay.ant.bnd.jsp.JspAnalyzerPlugin"));
        bndProperty.addValue("-sources", new BndPropertiesValue("true"));
    }

    @Override
    protected String getTemplateFile() {
        return TEMPLATE_FILE;
    }

    @Override
    protected List<String> getImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("javax.portlet.Portlet");
        imports.add("com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet");
        imports.addAll(super.getImports());
        return imports;
    }

    @Override
    protected List<String> getProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.addAll(Arrays.asList(PROPERTIES_LIST));
        for (String property : super.getProperties()) {
            properties.add(property);
        }
        properties.add("javax.portlet.init-param.view-template=/" + this.componentClassName.toLowerCase() + "/view.jsp");
        return properties;
    }

    @Override
    protected String getExtensionClass() {
        return EXTENSION_CLASS;
    }

    @Override
    protected String getSuperClass() {
        return SUPER_CLASS;
    }
}

