/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.upgrade;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.AbstractUpgradeProjectHandler;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.SearchFilesVisitor;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class UpgradeMetadataHandler
extends AbstractUpgradeProjectHandler {
    private static final String publicid_regrex = "-\\//(?:[a-z][a-z]+)\\//(?:[a-z][a-z]+)[\\s+(?:[a-z][a-z0-9_]*)]*\\s+(\\d\\.\\d\\.\\d)\\//(?:[a-z][a-z]+)";
    private static final String systemid_regrex = "^http://www.liferay.com/dtd/[-A-Za-z0-9+&@#/%?=~_()]*(\\d_\\d_\\d).dtd";
    private static final String[] fileNames = new String[]{"liferay-portlet.xml", "liferay-display.xml", "service.xml", "liferay-hook.xml", "liferay-layout-templates.xml", "liferay-look-and-feel.xml", "liferay-portlet-ext.xml", "liferay-plugin-package.properties"};

    @Override
    public Status execute(IProject project, String runtimeName, IProgressMonitor monitor, int perUnit) {
        Status retval = Status.createOkStatus();
        try {
            IFile[] metaFiles;
            int worked = 0;
            IProgressMonitor submon = CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)25);
            submon.subTask("Prograde Upgrade Update DTD Header");
            IFile[] iFileArray = metaFiles = this.getUpgradeDTDFiles(project);
            int n = metaFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                IStructuredModel editModel = StructuredModelManager.getModelManager().getModelForEdit(file);
                try {
                    if (editModel != null && editModel instanceof IDOMModel) {
                        submon.worked(worked += perUnit);
                        IDOMDocument xmlDocument = ((IDOMModel)editModel).getDocument();
                        DocumentTypeImpl docType = (DocumentTypeImpl)xmlDocument.getDoctype();
                        String publicId = docType.getPublicId();
                        String newPublicId = this.getNewDoctTypeSetting(publicId, "6.2.0", publicid_regrex);
                        if (newPublicId != null) {
                            docType.setPublicId(newPublicId);
                        }
                        submon.worked(worked += perUnit);
                        String systemId = docType.getSystemId();
                        String newSystemId = this.getNewDoctTypeSetting(systemId, "6_2_0", systemid_regrex);
                        if (newSystemId != null) {
                            docType.setSystemId(newSystemId);
                        }
                        editModel.save();
                        submon.worked(worked += perUnit);
                    } else {
                        this.updateProperties(file, "liferay-versions", "6.2.0+");
                    }
                }
                finally {
                    editModel.releaseFromEdit();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            IStatus error = ProjectCore.createErrorStatus("Unable to upgrade deployment meta file for " + project.getName(), e);
            ProjectCore.logError(error);
            retval = StatusBridge.create((IStatus)error);
        }
        return retval;
    }

    private String getNewDoctTypeSetting(String doctypeSetting, String newValue, String regrex) {
        String newDoctTypeSetting = null;
        Pattern p = Pattern.compile(regrex, 34);
        Matcher m = p.matcher(doctypeSetting);
        if (m.find()) {
            String oldVersionString = m.group(m.groupCount());
            newDoctTypeSetting = doctypeSetting.replace(oldVersionString, newValue);
        }
        return newDoctTypeSetting;
    }

    private IFile[] getUpgradeDTDFiles(IProject project) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            files.addAll(new SearchFilesVisitor().searchFiles((IResource)project, name));
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    private void updateProperties(IFile file, String propertyName, String propertiesValue) throws Exception {
        File osfile = new File(file.getLocation().toOSString());
        PropertiesConfiguration pluginPackageProperties = new PropertiesConfiguration();
        pluginPackageProperties.load(osfile);
        pluginPackageProperties.setProperty(propertyName, (Object)propertiesValue);
        try (FileWriter output = new FileWriter(osfile);){
            pluginPackageProperties.save((Writer)output);
        }
        file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
    }
}

