/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ClasspathUtil {
    public static boolean isPluginContainerEntry(IClasspathEntry e) {
        return e != null && e.getEntryKind() == 5 && e.getPath().segment(0).equals("com.liferay.ide.sdk.container");
    }

    public static boolean hasNewLiferaySDKContainer(IClasspathEntry[] entries) {
        boolean retVal = false;
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("com.liferay.ide.sdk.container")) {
                retVal = true;
                break;
            }
            ++n2;
        }
        return retVal;
    }

    public static void updateRequestContainer(IProject project) throws CoreException {
        IClasspathEntry[] entries;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath containerPath = null;
        IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("com.liferay.ide.sdk.container")) {
                containerPath = entry.getPath();
                break;
            }
            ++n2;
        }
        if (containerPath != null) {
            IClasspathContainer classpathContainer = JavaCore.getClasspathContainer(containerPath, (IJavaProject)javaProject);
            String id = containerPath.segment(0);
            if (id.equals("com.liferay.ide.sdk.container")) {
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)id);
                initializer.requestClasspathContainerUpdate(containerPath, javaProject, classpathContainer);
            }
        }
    }
}

