/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExtractInterfaceWizard
extends RefactoringWizard {
    private final ExtractInterfaceProcessor fProcessor;

    public ExtractInterfaceWizard(ExtractInterfaceProcessor processor, Refactoring refactoring) {
        super(refactoring, 4);
        this.fProcessor = processor;
        this.setDefaultPageTitle(RefactoringMessages.ExtractInterfaceWizard_Extract_Interface);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ExtractInterfaceInputPage(this.fProcessor));
    }

    private static class ExtractInterfaceInputPage
    extends TextInputWizardPage {
        private Button fReplaceAllCheckbox;
        private Button fGenerateAnnotationsCheckbox;
        private Button fGenerateCommentsCheckbox;
        private Button fInstanceofCheckbox;
        private CheckboxTableViewer fTableViewer;
        private static final String DESCRIPTION = RefactoringMessages.ExtractInterfaceInputPage_description;
        private static final String SETTING_ANNOTATIONS = "Annotations";
        private static final String SETTING_REPLACE = "Replace";
        private static final String SETTING_COMMENTS = "Comments";
        private static final String SETTING_INSTANCEOF = "InstanceOf";
        private Button fSelectAllButton;
        private Button fDeselectAllButton;
        private final ExtractInterfaceProcessor fProcessor;

        public ExtractInterfaceInputPage(ExtractInterfaceProcessor processor) {
            super(DESCRIPTION, true);
            this.fProcessor = processor;
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            Label label = new Label(result, 0);
            label.setText(RefactoringMessages.ExtractInterfaceInputPage_Interface_name);
            Text text = this.createTextInputField(result);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            this.addReplaceAllCheckbox(result);
            this.addInstanceofCheckbox(result, layout.marginWidth);
            this.fReplaceAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractInterfaceInputPage.this.fInstanceofCheckbox.setEnabled(ExtractInterfaceInputPage.this.fReplaceAllCheckbox.getSelection());
                }
            });
            this.addGenerateAnnotationsCheckbox(result);
            Label separator = new Label(result, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            separator.setLayoutData((Object)gd);
            Label tableLabel = new Label(result, 0);
            tableLabel.setText(RefactoringMessages.ExtractInterfaceInputPage_Members);
            tableLabel.setEnabled(this.anyMembersToExtract());
            gd = new GridData();
            gd.horizontalSpan = 2;
            tableLabel.setLayoutData((Object)gd);
            this.addMemberListComposite(result);
            this.addGenerateCommentsCheckbox(result);
            Dialog.applyDialogFont((Control)result);
            this.initializeCheckboxes();
            this.updateUIElementEnablement();
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.extract_interface_temp_page_context");
        }

        private void addGenerateAnnotationsCheckbox(Composite result) {
            String title = RefactoringMessages.ExtractInterfaceWizard_generate_annotations;
            this.fGenerateAnnotationsCheckbox = ExtractInterfaceInputPage.createCheckbox(result, title, false);
            this.fProcessor.setAnnotations(this.fGenerateAnnotationsCheckbox.getSelection());
            this.fGenerateAnnotationsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractInterfaceInputPage.this.fProcessor.setAnnotations(ExtractInterfaceInputPage.this.fGenerateAnnotationsCheckbox.getSelection());
                }
            });
        }

        private void addGenerateCommentsCheckbox(Composite result) {
            String title = RefactoringMessages.ExtractInterfaceWizard_generate_comments;
            this.fGenerateCommentsCheckbox = ExtractInterfaceInputPage.createCheckbox(result, title, false);
            this.fProcessor.setComments(this.fGenerateCommentsCheckbox.getSelection());
            this.fGenerateCommentsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractInterfaceInputPage.this.fProcessor.setComments(ExtractInterfaceInputPage.this.fGenerateCommentsCheckbox.getSelection());
                }
            });
        }

        private void addInstanceofCheckbox(Composite result, int margin) {
            String title = RefactoringMessages.ExtractInterfaceWizard_use_supertype;
            this.fInstanceofCheckbox = new Button(result, 32);
            this.fInstanceofCheckbox.setSelection(false);
            GridData gd = new GridData();
            gd.horizontalIndent = margin + this.fInstanceofCheckbox.computeSize((int)-1, (int)-1).x;
            gd.horizontalSpan = 2;
            this.fInstanceofCheckbox.setLayoutData((Object)gd);
            this.fInstanceofCheckbox.setText(title);
            this.fProcessor.setInstanceOf(this.fInstanceofCheckbox.getSelection());
            this.fInstanceofCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractInterfaceInputPage.this.fProcessor.setInstanceOf(ExtractInterfaceInputPage.this.fInstanceofCheckbox.getSelection());
                }
            });
        }

        private void addMemberListComposite(Composite result) {
            Composite composite = new Composite(result, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            GridData gd = new GridData(1808);
            gd.heightHint = this.convertHeightInCharsToPixels(12);
            gd.horizontalSpan = 2;
            composite.setLayoutData((Object)gd);
            this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
            this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
            this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            try {
                this.fTableViewer.setInput((Object)this.getExtractableMembers());
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.ExtractInterfaceInputPage_Extract_Interface, RefactoringMessages.ExtractInterfaceInputPage_Internal_Error);
                this.fTableViewer.setInput((Object)new IMember[0]);
            }
            this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ExtractInterfaceInputPage.this.updateUIElementEnablement();
                }
            });
            this.fTableViewer.setComparator((ViewerComparator)new JavaElementComparator());
            this.fTableViewer.getControl().setEnabled(this.anyMembersToExtract());
            this.createButtonComposite(composite);
        }

        private IMember[] getExtractableMembers() throws JavaModelException {
            return this.fProcessor.getExtractableMembers();
        }

        protected void updateUIElementEnablement() {
            IMember[] extractable;
            IMember[] checked = this.getCheckedMembers();
            try {
                extractable = this.getExtractableMembers();
            }
            catch (JavaModelException exception) {
                extractable = new IMember[]{};
                JavaPlugin.log(exception);
            }
            boolean enabled = ExtractInterfaceInputPage.containsMethods(checked);
            this.fGenerateAnnotationsCheckbox.setEnabled(enabled);
            this.fGenerateCommentsCheckbox.setEnabled(enabled);
            this.fInstanceofCheckbox.setEnabled(this.fReplaceAllCheckbox.getSelection());
            this.fSelectAllButton.setEnabled(checked.length < extractable.length);
            this.fDeselectAllButton.setEnabled(checked.length > 0);
        }

        private static boolean containsMethods(IMember[] members) {
            int i = 0;
            while (i < members.length) {
                if (members[i].getElementType() == 9) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private ILabelProvider createLabelProvider() {
            AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(36283885830185L, 1);
            return new DecoratingJavaLabelProvider(lprovider);
        }

        private void createButtonComposite(Composite composite) {
            Composite buttonComposite = new Composite(composite, 0);
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            buttonComposite.setLayout((Layout)gl);
            GridData gd = new GridData(1040);
            buttonComposite.setLayoutData((Object)gd);
            this.fSelectAllButton = new Button(buttonComposite, 8);
            this.fSelectAllButton.setText(RefactoringMessages.ExtractInterfaceInputPage_Select_All);
            this.fSelectAllButton.setEnabled(this.anyMembersToExtract());
            this.fSelectAllButton.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
            this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractInterfaceInputPage.this.fTableViewer.setAllChecked(true);
                    ExtractInterfaceInputPage.this.updateUIElementEnablement();
                }
            });
            this.fDeselectAllButton = new Button(buttonComposite, 8);
            this.fDeselectAllButton.setText(RefactoringMessages.ExtractInterfaceInputPage_Deselect_All);
            this.fDeselectAllButton.setEnabled(this.anyMembersToExtract());
            this.fDeselectAllButton.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(this.fDeselectAllButton);
            this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractInterfaceInputPage.this.fTableViewer.setAllChecked(false);
                    ExtractInterfaceInputPage.this.updateUIElementEnablement();
                }
            });
        }

        private boolean anyMembersToExtract() {
            try {
                return this.getExtractableMembers().length > 0;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }

        private void addReplaceAllCheckbox(Composite result) {
            String title = RefactoringMessages.ExtractInterfaceInputPage_change_references;
            boolean defaultValue = this.fProcessor.isReplace();
            this.fReplaceAllCheckbox = ExtractInterfaceInputPage.createCheckbox(result, title, defaultValue);
            this.fProcessor.setReplace(this.fReplaceAllCheckbox.getSelection());
            this.fReplaceAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractInterfaceInputPage.this.fProcessor.setReplace(ExtractInterfaceInputPage.this.fReplaceAllCheckbox.getSelection());
                }
            });
        }

        private static Button createCheckbox(Composite parent, String title, boolean value) {
            Button checkBox = new Button(parent, 32);
            checkBox.setText(title);
            checkBox.setSelection(value);
            GridData layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            checkBox.setLayoutData((Object)layoutData);
            return checkBox;
        }

        @Override
        protected RefactoringStatus validateTextField(String text) {
            ExtractInterfaceProcessor processor = this.fProcessor;
            processor.setTypeName(text);
            return processor.checkTypeName(text);
        }

        public IWizardPage getNextPage() {
            try {
                this.initializeRefactoring();
                this.storeDialogSettings();
                return super.getNextPage();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return null;
            }
        }

        public boolean performFinish() {
            try {
                this.initializeRefactoring();
                this.storeDialogSettings();
                return super.performFinish();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return false;
            }
        }

        private void initializeRefactoring() throws JavaModelException {
            this.fProcessor.setTypeName(this.getText());
            this.fProcessor.setReplace(this.fReplaceAllCheckbox.getSelection());
            this.fProcessor.setExtractedMembers(this.getCheckedMembers());
            this.fProcessor.setAnnotations(this.fGenerateAnnotationsCheckbox.getSelection());
            this.fProcessor.setComments(this.fGenerateCommentsCheckbox.getSelection());
            this.fProcessor.setInstanceOf(this.fInstanceofCheckbox.getSelection());
        }

        private IMember[] getCheckedMembers() {
            List<Object> checked = Arrays.asList(this.fTableViewer.getCheckedElements());
            return checked.toArray(new IMember[checked.size()]);
        }

        @Override
        public void dispose() {
            this.fInstanceofCheckbox = null;
            this.fGenerateCommentsCheckbox = null;
            this.fReplaceAllCheckbox = null;
            this.fTableViewer = null;
            super.dispose();
        }

        private void initializeCheckboxes() {
            this.initializeCheckBox(this.fGenerateAnnotationsCheckbox, SETTING_ANNOTATIONS, true);
            this.initializeCheckBox(this.fReplaceAllCheckbox, SETTING_REPLACE, true);
            this.initializeCheckBox(this.fGenerateCommentsCheckbox, SETTING_COMMENTS, true);
            this.initializeCheckBox(this.fInstanceofCheckbox, SETTING_INSTANCEOF, false);
        }

        private void initializeCheckBox(Button checkbox, String property, boolean def) {
            String s = JavaPlugin.getDefault().getDialogSettings().get(property);
            if (s != null) {
                checkbox.setSelection(Boolean.parseBoolean(s));
            } else {
                checkbox.setSelection(def);
            }
        }

        private void storeDialogSettings() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            settings.put(SETTING_ANNOTATIONS, this.fGenerateAnnotationsCheckbox.getSelection());
            settings.put(SETTING_REPLACE, this.fReplaceAllCheckbox.getSelection());
            settings.put(SETTING_COMMENTS, this.fGenerateCommentsCheckbox.getSelection());
            settings.put(SETTING_INSTANCEOF, this.fInstanceofCheckbox.getSelection());
        }
    }
}

