/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.AbstractAddCredentialsProviderInterceptor;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsAuthenticationStrategy;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;

public class CacheCredentialsInterceptor
extends AbstractAddCredentialsProviderInterceptor {
    private final CredentialsProvider credentialsCache;

    public CacheCredentialsInterceptor(CacheCredentialsProvider credentialsCache) {
        this.credentialsCache = credentialsCache;
    }

    public CacheCredentialsInterceptor() {
        this.credentialsCache = new CacheCredentialsProvider();
    }

    public HttpContext intercept(HttpClient client, HttpContext context) {
        this.addCredentialsProvider(CacheCredentialsAuthenticationStrategy.CREDENTIALS_CACHE_ATTRIBUTE, context);
        return context;
    }

    protected boolean isMatchingProvider(CredentialsProvider credentialsProvider) {
        return credentialsProvider == this.credentialsCache;
    }

    protected CredentialsProvider getCredentialsProviderToAdd() {
        return this.credentialsCache;
    }

    protected ChainedCredentialsProvider chainCredentialsProviders(CredentialsProvider existingProvider, CredentialsProvider addedProvider) {
        return super.chainCredentialsProviders(addedProvider, existingProvider);
    }
}

